/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.common.constellation.effect.aoe;

import hellfirepvp.astralsorcery.client.effect.EffectHandler;
import hellfirepvp.astralsorcery.client.effect.controller.orbital.OrbitalEffectController;
import hellfirepvp.astralsorcery.client.effect.controller.orbital.OrbitalEffectLucerna;
import hellfirepvp.astralsorcery.common.constellation.IMinorConstellation;
import hellfirepvp.astralsorcery.common.constellation.distribution.ConstellationSkyHandler;
import hellfirepvp.astralsorcery.common.constellation.effect.ConstellationEffect;
import hellfirepvp.astralsorcery.common.constellation.effect.ConstellationEffectProperties;
import hellfirepvp.astralsorcery.common.constellation.effect.ConstellationEffectStatus;
import hellfirepvp.astralsorcery.common.event.listener.EventHandlerEntity;
import hellfirepvp.astralsorcery.common.lib.Constellations;
import hellfirepvp.astralsorcery.common.tile.TileRitualPedestal;
import hellfirepvp.astralsorcery.common.util.ILocatable;
import hellfirepvp.astralsorcery.common.util.data.TickTokenizedMap;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import hellfirepvp.astralsorcery.common.util.data.WorldBlockPos;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CEffectLucerna
extends ConstellationEffect
implements ConstellationEffectStatus {
    public static boolean enabled = true;
    public static double potencyMultiplier = 1.0;
    public static double range = 64.0;
    public static double rangeIncrease = 64.0;
    private int rememberedTimeout = 0;

    public CEffectLucerna(@Nullable ILocatable origin) {
        super(origin, Constellations.lucerna, "lucerna");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void playClientEffect(World world, BlockPos pos, TileRitualPedestal pedestal, float percEffectVisibility, boolean extendedEffects) {
        if (pedestal.getTicksExisted() % 20 == 0) {
            OrbitalEffectLucerna luc = new OrbitalEffectLucerna();
            OrbitalEffectController ctrl = EffectHandler.getInstance().orbital(luc, luc, luc);
            ctrl.setOffset(new Vector3(pos).add(0.5, 0.5, 0.5));
            ctrl.setOrbitRadius(0.8 + (double)rand.nextFloat() * 0.7);
            ctrl.setOrbitAxis(Vector3.RotAxis.Y_AXIS);
            ctrl.setTicksPerRotation(20 + rand.nextInt(20));
        }
    }

    @Override
    public boolean runEffect(World world, BlockPos pos, int mirrorAmount, ConstellationEffectProperties modified, @Nullable IMinorConstellation possibleTraitEffect) {
        if (!enabled) {
            return false;
        }
        if (modified.isCorrupted()) {
            if (ConstellationSkyHandler.getInstance().isNight(world) && rand.nextBoolean()) {
                ConstellationSkyHandler.getInstance().revertWorldTimeTick(world);
            }
            return true;
        }
        WorldBlockPos at = new WorldBlockPos(world, pos);
        TickTokenizedMap.SimpleTickToken token = (TickTokenizedMap.SimpleTickToken)EventHandlerEntity.spawnDenyRegions.get((Object)at);
        if (token != null && Math.abs((Double)token.getValue() - modified.getSize()) < 0.001) {
            int next = token.getRemainingTimeout() + 80;
            if (next > 400) {
                next = 400;
            }
            token.setTimeout(next);
            this.rememberedTimeout = next;
        } else {
            if (token != null) {
                token.setTimeout(0);
            }
            this.rememberedTimeout = Math.min(400, this.rememberedTimeout + 80);
            EventHandlerEntity.spawnDenyRegions.put(at, new TickTokenizedMap.SimpleTickToken<Double>(modified.getSize(), this.rememberedTimeout));
        }
        return true;
    }

    @Override
    @Deprecated
    public boolean playEffect(World world, BlockPos pos, float percStrength, ConstellationEffectProperties modified, @Nullable IMinorConstellation possibleTraitEffect) {
        return false;
    }

    @Override
    public ConstellationEffectProperties provideProperties(int mirrorCount) {
        return new ConstellationEffectProperties(range + (double)mirrorCount * rangeIncrease);
    }

    @Override
    public void readFromNBT(NBTTagCompound cmp) {
        super.readFromNBT(cmp);
        this.rememberedTimeout = cmp.func_74762_e("rememberedTimeout");
    }

    @Override
    public void writeToNBT(NBTTagCompound cmp) {
        super.writeToNBT(cmp);
        cmp.func_74768_a("rememberedTimeout", this.rememberedTimeout);
    }

    @Override
    public void loadFromConfig(Configuration cfg) {
        enabled = cfg.getBoolean(this.getKey() + "Enabled", this.getConfigurationSection(), true, "Set to false to disable this ConstellationEffect.");
        range = cfg.getFloat(this.getKey() + "DenyRange", this.getConfigurationSection(), (float)range, 2.0f, 2048.0f, "Defines the range in which the ritual will prevent mobspawning.");
        rangeIncrease = cfg.getFloat(this.getKey() + "DenyRangeIncrease", this.getConfigurationSection(), (float)rangeIncrease, 2.0f, 2048.0f, "Defines the range-increase that the ritual will get per additional lens focusing light back onto the pedestal");
        potencyMultiplier = cfg.getFloat(this.getKey() + "PotencyMultiplier", this.getConfigurationSection(), 1.0f, 0.01f, 100.0f, "Set the potency multiplier for this ritual effect. Will affect all ritual effects and their efficiency.");
    }
}

