/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.effect.controller;

import hellfirepvp.astralsorcery.client.effect.EffectHandler;
import hellfirepvp.astralsorcery.client.effect.IComplexEffect;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFloatingCube;
import hellfirepvp.astralsorcery.client.util.Blending;
import hellfirepvp.astralsorcery.client.util.resource.AssetLibrary;
import hellfirepvp.astralsorcery.client.util.resource.AssetLoader;
import hellfirepvp.astralsorcery.common.tile.IStructureAreaOfInfluence;
import hellfirepvp.astralsorcery.common.util.MiscUtils;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class InfluenceSizePreview
implements IComplexEffect {
    private static final int MAX_LIFE = 40;
    private static final float alphaPerFade = 0.025f;
    private boolean removed = false;
    private int fadeOutTicks = 1;
    private final IStructureAreaOfInfluence tile;
    private EntityFXFloatingCube cube1 = null;
    private EntityFXFloatingCube cube2 = null;

    public InfluenceSizePreview(IStructureAreaOfInfluence tile) {
        this.tile = tile;
    }

    public IStructureAreaOfInfluence getTile() {
        return this.tile;
    }

    @Override
    public boolean canRemove() {
        return this.fadeOutTicks <= 0 || Minecraft.func_71410_x().field_71441_e == null || Minecraft.func_71410_x().field_71441_e.field_73011_w.getDimension() != this.tile.getDimensionId();
    }

    @Override
    public boolean isRemoved() {
        return this.removed;
    }

    @Override
    public void flagAsRemoved() {
        this.removed = true;
    }

    @Override
    public void clearRemoveFlag() {
        this.removed = false;
    }

    @Override
    public void tick() {
        this.fadeOutTicks = this.needsFadeOut() ? Math.max(0, this.fadeOutTicks - 1) : Math.min(40, this.fadeOutTicks + 1);
        if (this.fadeOutTicks > 0 && this.tile != null) {
            BlockPos spawnAt = this.tile.getActualRenderOffsetPos();
            float radius = (float)this.tile.getRadius();
            radius *= 1.25f;
            if (spawnAt != null) {
                if (this.cube1 == null || this.cube1.isRemoved()) {
                    this.cube1 = this.setupCube(spawnAt, radius);
                }
                if (this.cube2 == null || this.cube2.isRemoved()) {
                    this.cube2 = this.setupCube(spawnAt, radius);
                }
                this.handleEffects(this.cube1, radius * 1.3f, (float)this.fadeOutTicks * 0.025f * 0.2f);
                this.handleEffects(this.cube2, radius * 0.85f, (float)this.fadeOutTicks * 0.025f * 0.2f);
            }
        }
    }

    protected boolean needsFadeOut() {
        double rad;
        block8: {
            block7: {
                double d;
                if (Minecraft.func_71410_x().field_71439_g == null || Minecraft.func_71410_x().field_71441_e == null) {
                    return true;
                }
                IStructureAreaOfInfluence aoe = EffectHandler.getInstance().getCurrentActiveAOEView();
                if (aoe == null || !aoe.equals(this.tile)) {
                    return true;
                }
                if (MiscUtils.getTileAt((IBlockAccess)Minecraft.func_71410_x().field_71441_e, aoe.getLocationPos(), IStructureAreaOfInfluence.class, false) == null) {
                    return true;
                }
                if (!this.tile.providesEffect()) break block7;
                rad = this.tile.getRadius();
                if (!(d <= 0.0)) break block8;
            }
            return true;
        }
        BlockPos offset = this.tile.getActualRenderOffsetPos();
        double dst = Minecraft.func_71410_x().field_71439_g.func_70011_f((double)offset.func_177958_n(), (double)offset.func_177956_o(), (double)offset.func_177952_p());
        if (dst <= 4.0) {
            return false;
        }
        return dst > 45.0 || dst > rad * 0.75;
    }

    private void handleEffects(EntityFXFloatingCube cube, float radius, float alpha) {
        cube.setTumbleIntensityMultiplier(0.06f);
        cube.setScale(radius);
        cube.setAlphaMultiplier(alpha);
        Color col = this.tile.getEffectRenderColor();
        if (col != null) {
            cube.setColorHandler(c -> col.brighter());
        }
    }

    private EntityFXFloatingCube setupCube(BlockPos at, float radius) {
        EntityFXFloatingCube cube = new EntityFXFloatingCube(AssetLibrary.loadTexture(AssetLoader.TextureLocation.BLOCKS, "core_edge"));
        cube.setRefreshFunction(() -> !this.isRemoved());
        cube.setAlphaMultiplier(0.0f);
        cube.setPosition(new Vector3(at).add(0.5, 0.5, 0.5));
        cube.setScale(radius);
        cube.setTumbleIntensityMultiplier(0.06f);
        cube.setBlendMode(Blending.DEFAULT);
        cube.tumble();
        EffectHandler.getInstance().registerFX(cube);
        return cube;
    }

    @Override
    public IComplexEffect.RenderTarget getRenderTarget() {
        return IComplexEffect.RenderTarget.RENDERLOOP;
    }

    @Override
    public void render(float pTicks) {
    }
}

