/*
 * Decompiled with CFR 0.152.
 */
package hellfirepvp.astralsorcery.client.effect;

import hellfirepvp.astralsorcery.AstralSorcery;
import hellfirepvp.astralsorcery.client.data.PersistentDataManager;
import hellfirepvp.astralsorcery.client.effect.EntityComplexFX;
import hellfirepvp.astralsorcery.client.effect.IComplexEffect;
import hellfirepvp.astralsorcery.client.effect.block.EffectTranslucentFallingBlock;
import hellfirepvp.astralsorcery.client.effect.compound.CompoundObjectEffect;
import hellfirepvp.astralsorcery.client.effect.controller.InfluenceSizePreview;
import hellfirepvp.astralsorcery.client.effect.controller.orbital.OrbitalEffectController;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFacingDepthParticle;
import hellfirepvp.astralsorcery.client.effect.fx.EntityFXFacingParticle;
import hellfirepvp.astralsorcery.client.effect.light.EffectLightbeam;
import hellfirepvp.astralsorcery.client.effect.light.EffectLightning;
import hellfirepvp.astralsorcery.client.effect.texture.TexturePlane;
import hellfirepvp.astralsorcery.client.effect.texture.TextureSpritePlane;
import hellfirepvp.astralsorcery.client.event.ClientGatewayHandler;
import hellfirepvp.astralsorcery.client.render.tile.TESRMapDrawingTable;
import hellfirepvp.astralsorcery.client.render.tile.TESRPrismLens;
import hellfirepvp.astralsorcery.client.render.tile.TESRTranslucentBlock;
import hellfirepvp.astralsorcery.client.util.StructureMatchPreview;
import hellfirepvp.astralsorcery.client.util.TextureHelper;
import hellfirepvp.astralsorcery.client.util.UIGateway;
import hellfirepvp.astralsorcery.client.util.UISextantTarget;
import hellfirepvp.astralsorcery.client.util.resource.AssetLibrary;
import hellfirepvp.astralsorcery.client.util.resource.BindableResource;
import hellfirepvp.astralsorcery.client.util.resource.SpriteSheetResource;
import hellfirepvp.astralsorcery.common.data.config.Config;
import hellfirepvp.astralsorcery.common.tile.IMultiblockDependantTile;
import hellfirepvp.astralsorcery.common.tile.IStructureAreaOfInfluence;
import hellfirepvp.astralsorcery.common.util.Counter;
import hellfirepvp.astralsorcery.common.util.data.Vector3;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.lwjgl.opengl.GL11;

public final class EffectHandler {
    public static final Random STATIC_EFFECT_RAND = new Random();
    public static final EffectHandler instance = new EffectHandler();
    private static boolean acceptsNewParticles = true;
    private static boolean cleanRequested = false;
    private static List<IComplexEffect> toAddBuffer = new LinkedList<IComplexEffect>();
    private UIGateway uiGateway = null;
    private int gatewayUITicks = 0;
    public boolean renderGateway = true;
    private StructureMatchPreview structurePreview = null;
    private InfluenceSizePreview influenceSizePreview = null;
    public static final Map<IComplexEffect.RenderTarget, Map<Integer, List<IComplexEffect>>> complexEffects = new HashMap<IComplexEffect.RenderTarget, Map<Integer, List<IComplexEffect>>>();
    public static final List<EntityFXFacingDepthParticle> fastRenderDepthParticles = new LinkedList<EntityFXFacingDepthParticle>();
    public static final List<EntityFXFacingParticle> fastRenderParticles = new LinkedList<EntityFXFacingParticle>();
    public static final List<EntityFXFacingParticle> fastRenderGatewayParticles = new LinkedList<EntityFXFacingParticle>();
    public static final List<EffectLightning> fastRenderLightnings = new LinkedList<EffectLightning>();
    public static final Map<CompoundObjectEffect.ObjectGroup, List<CompoundObjectEffect>> objects = new HashMap<CompoundObjectEffect.ObjectGroup, List<CompoundObjectEffect>>();

    private EffectHandler() {
    }

    public static EffectHandler getInstance() {
        return instance;
    }

    public void requestGatewayUIFor(World world, BlockPos gateway, Vector3 pos, double sphereRadius) {
        if (this.uiGateway == null || !this.uiGateway.getPos().equals(pos)) {
            this.uiGateway = UIGateway.initialize(world, gateway, pos, sphereRadius);
        }
        this.gatewayUITicks = 20;
    }

    public void requestStructurePreviewFor(IMultiblockDependantTile tile) {
        if (!(tile instanceof TileEntity)) {
            return;
        }
        if (this.structurePreview == null || !this.structurePreview.isOriginatingFrom(tile)) {
            this.structurePreview = new StructureMatchPreview(tile);
        }
        this.structurePreview.resetTimeout();
    }

    public void requestSizePreviewFor(IStructureAreaOfInfluence tile) {
        InfluenceSizePreview prev;
        if (!(tile instanceof TileEntity)) {
            return;
        }
        this.influenceSizePreview = prev = new InfluenceSizePreview(tile);
        this.register(prev);
    }

    @Nullable
    public UIGateway getUiGateway() {
        return this.uiGateway;
    }

    @Nullable
    public IStructureAreaOfInfluence getCurrentActiveAOEView() {
        return this.influenceSizePreview == null ? null : this.influenceSizePreview.getTile();
    }

    public static int getDebugEffectCount() {
        Counter c = new Counter(0);
        for (Map<Integer, List<IComplexEffect>> effects : complexEffects.values()) {
            for (List<IComplexEffect> eff : effects.values()) {
                c.value += eff.size();
            }
        }
        c.value += fastRenderParticles.size();
        c.value += fastRenderLightnings.size();
        objects.values().forEach(l -> c.value += l.size());
        return c.value;
    }

    @SubscribeEvent
    public void onOverlay(RenderGameOverlayEvent.Post event) {
        if (event.getType() == RenderGameOverlayEvent.ElementType.ALL) {
            acceptsNewParticles = false;
            Map<Integer, List<IComplexEffect>> layeredEffects = complexEffects.get((Object)IComplexEffect.RenderTarget.OVERLAY_TEXT);
            for (int i = 0; i <= 2; ++i) {
                for (IComplexEffect effect : layeredEffects.get(i)) {
                    GL11.glPushMatrix();
                    GL11.glPushAttrib((int)1048575);
                    effect.render(event.getPartialTicks());
                    GL11.glPopAttrib();
                    GL11.glPopMatrix();
                }
            }
            acceptsNewParticles = true;
        }
    }

    @SubscribeEvent
    public void onDebugText(RenderGameOverlayEvent.Text event) {
        if (Minecraft.func_71410_x().field_71474_y.field_74330_P) {
            event.getLeft().add("");
            event.getLeft().add(TextFormatting.BLUE + "[AstralSorcery]" + TextFormatting.RESET + " Use Local persistent data: " + PersistentDataManager.INSTANCE.usePersistent());
            event.getLeft().add(TextFormatting.BLUE + "[AstralSorcery]" + TextFormatting.RESET + " EffectHandler:");
            event.getLeft().add(TextFormatting.BLUE + "[AstralSorcery]" + TextFormatting.RESET + " > Complex effects: " + EffectHandler.getDebugEffectCount());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onRender(RenderWorldLastEvent event) {
        TESRPrismLens.renderColoredPrismsLast();
        float pTicks = event.getPartialTicks();
        acceptsNewParticles = false;
        if (this.structurePreview != null) {
            this.structurePreview.renderPreview(pTicks);
        }
        UISextantTarget.renderTargets(pTicks);
        GlStateManager.func_179097_i();
        EntityFXFacingParticle.renderFast(pTicks, fastRenderDepthParticles);
        GlStateManager.func_179126_j();
        EntityFXFacingParticle.renderFast(pTicks, fastRenderParticles);
        EffectLightning.renderFast(pTicks, fastRenderLightnings);
        Map<Integer, List<IComplexEffect>> layeredEffects = complexEffects.get((Object)IComplexEffect.RenderTarget.RENDERLOOP);
        for (int i = 0; i <= 2; ++i) {
            for (IComplexEffect effect : layeredEffects.get(i)) {
                effect.render(pTicks);
            }
        }
        TextureHelper.refreshTextureBindState();
        TESRTranslucentBlock.renderTranslucentBlocks();
        TESRMapDrawingTable.renderRemainingGlasses(pTicks);
        for (CompoundObjectEffect.ObjectGroup og : objects.keySet()) {
            og.prepareGLContext();
            for (CompoundObjectEffect effect : objects.get((Object)og)) {
                effect.render(pTicks);
            }
            og.revertGLContext();
        }
        if (this.uiGateway != null) {
            if (this.renderGateway) {
                this.uiGateway.renderIntoWorld(pTicks);
            }
            if (ClientGatewayHandler.focusingEntry != null) {
                this.uiGateway.renderGatewayTarget(pTicks);
            }
        }
        EntityFXFacingParticle.renderFast(pTicks, fastRenderGatewayParticles);
        acceptsNewParticles = true;
    }

    @SubscribeEvent
    public void onClTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        this.tick();
    }

    public EntityComplexFX registerFX(EntityComplexFX entityComplexFX) {
        this.register(entityComplexFX);
        return entityComplexFX;
    }

    public EffectTranslucentFallingBlock translucentFallingBlock(Vector3 position, IBlockState state) {
        EffectTranslucentFallingBlock block = new EffectTranslucentFallingBlock(state);
        block.setPosition(position.clone().add(-0.5, -0.5, -0.5));
        this.register(block);
        return block;
    }

    public EffectLightning lightning(Vector3 from, Vector3 to) {
        return EffectLightning.buildAndRegisterLightning(from, to);
    }

    public OrbitalEffectController orbital(OrbitalEffectController.OrbitPointEffect pointEffect, @Nullable OrbitalEffectController.OrbitPersistence persistence, @Nullable OrbitalEffectController.OrbitTickModifier tickModifier) {
        OrbitalEffectController ctrl = new OrbitalEffectController(pointEffect, persistence, tickModifier);
        this.register(ctrl);
        return ctrl;
    }

    public TextureSpritePlane textureSpritePlane(SpriteSheetResource sheetResource, Vector3 rotationAxis) {
        TextureSpritePlane plane = new TextureSpritePlane(sheetResource, rotationAxis);
        this.register(plane);
        return plane;
    }

    public TexturePlane texturePlane(BindableResource texture, Vector3 rotationAxis) {
        TexturePlane plane = new TexturePlane(texture, rotationAxis);
        this.register(plane);
        return plane;
    }

    public EffectLightbeam lightbeam(Vector3 from, Vector3 to, double beamRadSize) {
        EffectLightbeam beam = new EffectLightbeam(from, to, beamRadSize);
        this.register(beam);
        return beam;
    }

    public EffectLightbeam lightbeam(Vector3 from, Vector3 to, double fromBeamSize, double toBeamSize) {
        EffectLightbeam beam = new EffectLightbeam(from, to, fromBeamSize, toBeamSize);
        this.register(beam);
        return beam;
    }

    private void register(IComplexEffect effect) {
        if (AssetLibrary.reloading || effect == null || Minecraft.func_71410_x().func_147113_T()) {
            return;
        }
        if (!Thread.currentThread().getName().contains("Client thread")) {
            AstralSorcery.proxy.scheduleClientside(() -> this.register(effect));
            return;
        }
        if (acceptsNewParticles) {
            this.registerUnsafe(effect);
        } else {
            toAddBuffer.add(effect);
        }
    }

    private void registerUnsafe(IComplexEffect effect) {
        if (!EffectHandler.mayAcceptParticle(effect)) {
            return;
        }
        if (effect instanceof EffectLightning) {
            fastRenderLightnings.add((EffectLightning)effect);
        } else if (effect instanceof EntityFXFacingParticle.Gateway) {
            fastRenderGatewayParticles.add((EntityFXFacingParticle)effect);
        } else if (effect instanceof EntityFXFacingDepthParticle) {
            fastRenderDepthParticles.add((EntityFXFacingDepthParticle)effect);
        } else if (effect instanceof EntityFXFacingParticle) {
            fastRenderParticles.add((EntityFXFacingParticle)effect);
        } else if (effect instanceof CompoundObjectEffect) {
            CompoundObjectEffect.ObjectGroup group = ((CompoundObjectEffect)effect).getGroup();
            if (!objects.containsKey((Object)group)) {
                objects.put(group, new LinkedList());
            }
            objects.get((Object)group).add((CompoundObjectEffect)effect);
        } else {
            complexEffects.get((Object)effect.getRenderTarget()).get(effect.getLayer()).add(effect);
        }
        effect.clearRemoveFlag();
    }

    /*
     * WARNING - void declaration
     */
    public void tick() {
        IComplexEffect effect;
        if (cleanRequested) {
            void var3_6;
            IComplexEffect.RenderTarget[] renderTargetArray = IComplexEffect.RenderTarget.values();
            int n = renderTargetArray.length;
            boolean bl = false;
            while (var3_6 < n) {
                IComplexEffect.RenderTarget t = renderTargetArray[var3_6];
                for (int i = 0; i <= 2; ++i) {
                    List<IComplexEffect> effects = complexEffects.get((Object)t).get(i);
                    effects.forEach(IComplexEffect::flagAsRemoved);
                    effects.clear();
                }
                ++var3_6;
            }
            fastRenderParticles.clear();
            fastRenderLightnings.clear();
            objects.clear();
            toAddBuffer.clear();
            this.uiGateway = null;
            this.structurePreview = null;
            this.influenceSizePreview = null;
            this.gatewayUITicks = 0;
            cleanRequested = false;
        }
        if (this.influenceSizePreview != null && this.influenceSizePreview.isRemoved()) {
            this.influenceSizePreview = null;
        }
        if (Minecraft.func_71410_x().field_71439_g == null) {
            return;
        }
        if (this.structurePreview != null) {
            this.structurePreview.tick();
            if (this.structurePreview.shouldBeRemoved()) {
                this.structurePreview = null;
            }
        }
        if (this.gatewayUITicks > 0) {
            --this.gatewayUITicks;
            if (this.gatewayUITicks <= 0) {
                this.uiGateway = null;
            }
        }
        acceptsNewParticles = false;
        for (IComplexEffect.RenderTarget target : complexEffects.keySet()) {
            Map<Integer, List<IComplexEffect>> map = complexEffects.get((Object)target);
            for (int i = 0; i <= 2; ++i) {
                Iterator<IComplexEffect> iterator = map.get(i).iterator();
                while (iterator.hasNext()) {
                    effect = iterator.next();
                    effect.tick();
                    if (!effect.canRemove()) continue;
                    effect.flagAsRemoved();
                    iterator.remove();
                }
            }
        }
        Vector3 playerPos = Vector3.atEntityCorner((Entity)Minecraft.func_71410_x().field_71439_g);
        for (EntityFXFacingParticle entityFXFacingParticle : new ArrayList<EntityFXFacingParticle>(fastRenderParticles)) {
            if (entityFXFacingParticle == null) {
                fastRenderParticles.remove(null);
                continue;
            }
            entityFXFacingParticle.tick();
            if (!entityFXFacingParticle.canRemove() && (!entityFXFacingParticle.isDistanceRemovable() || !(entityFXFacingParticle.getPosition().distanceSquared(playerPos) >= (double)Config.maxEffectRenderDistanceSq))) continue;
            entityFXFacingParticle.flagAsRemoved();
            fastRenderParticles.remove(entityFXFacingParticle);
        }
        for (EntityFXFacingParticle entityFXFacingParticle : new ArrayList<EntityFXFacingDepthParticle>(fastRenderDepthParticles)) {
            if (entityFXFacingParticle == null) {
                fastRenderDepthParticles.remove(null);
                continue;
            }
            entityFXFacingParticle.tick();
            if (!entityFXFacingParticle.canRemove() && (!entityFXFacingParticle.isDistanceRemovable() || !(entityFXFacingParticle.getPosition().distanceSquared(playerPos) >= (double)Config.maxEffectRenderDistanceSq))) continue;
            entityFXFacingParticle.flagAsRemoved();
            fastRenderDepthParticles.remove(entityFXFacingParticle);
        }
        for (EntityFXFacingParticle entityFXFacingParticle : new ArrayList<EntityFXFacingParticle>(fastRenderGatewayParticles)) {
            if (entityFXFacingParticle == null) {
                fastRenderGatewayParticles.remove(null);
                continue;
            }
            entityFXFacingParticle.tick();
            if (!entityFXFacingParticle.canRemove() && (!entityFXFacingParticle.isDistanceRemovable() || !(entityFXFacingParticle.getPosition().distanceSquared(playerPos) >= (double)Config.maxEffectRenderDistanceSq))) continue;
            entityFXFacingParticle.flagAsRemoved();
            fastRenderGatewayParticles.remove(entityFXFacingParticle);
        }
        for (EffectLightning effectLightning : new ArrayList<EffectLightning>(fastRenderLightnings)) {
            if (effectLightning == null) {
                fastRenderLightnings.remove(null);
                continue;
            }
            effectLightning.tick();
            if (!effectLightning.canRemove()) continue;
            effectLightning.flagAsRemoved();
            fastRenderLightnings.remove(effectLightning);
        }
        Iterator<CompoundObjectEffect.ObjectGroup> itGroups = objects.keySet().iterator();
        while (itGroups.hasNext()) {
            CompoundObjectEffect.ObjectGroup objectGroup = itGroups.next();
            List<CompoundObjectEffect> effects = objects.get((Object)objectGroup);
            if (effects == null || effects.isEmpty()) {
                itGroups.remove();
                continue;
            }
            Iterator<CompoundObjectEffect> itObjects = effects.iterator();
            while (itObjects.hasNext()) {
                effect = itObjects.next();
                if (effect == null) {
                    itObjects.remove();
                    continue;
                }
                ((EntityComplexFX)effect).tick();
                if (!((EntityComplexFX)effect).canRemove()) continue;
                ((EntityComplexFX)effect).flagAsRemoved();
                itObjects.remove();
            }
        }
        acceptsNewParticles = true;
        LinkedList<IComplexEffect> linkedList = new LinkedList<IComplexEffect>(toAddBuffer);
        toAddBuffer.clear();
        for (IComplexEffect eff : linkedList) {
            this.registerUnsafe(eff);
        }
    }

    public static boolean mayAcceptParticle(IComplexEffect effect) {
        int cfg = Config.particleAmount;
        if (cfg > 1 && !Minecraft.func_71375_t()) {
            cfg = 1;
        }
        if (effect instanceof IComplexEffect.PreventRemoval || cfg == 2) {
            return true;
        }
        return cfg == 1 && STATIC_EFFECT_RAND.nextInt(3) == 0;
    }

    public static void cleanUp() {
        cleanRequested = true;
    }

    static {
        for (IComplexEffect.RenderTarget target : IComplexEffect.RenderTarget.values()) {
            HashMap layeredEffects = new HashMap();
            for (int i = 0; i <= 2; ++i) {
                layeredEffects.put(i, new LinkedList());
            }
            complexEffects.put(target, layeredEffects);
        }
    }
}

