/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.network.message;

import com.google.common.collect.Maps;
import com.mrcrayfish.furniture.gui.components.ValueComponent;
import com.mrcrayfish.furniture.tileentity.IValueContainer;
import com.mrcrayfish.furniture.util.TileEntityUtil;
import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class MessageUpdateValueContainer
implements IMessage,
IMessageHandler<MessageUpdateValueContainer, IMessage> {
    private Map<String, String> entryMap;
    private BlockPos pos;

    public MessageUpdateValueContainer() {
    }

    public MessageUpdateValueContainer(List<ValueComponent> valueEntries, IValueContainer valueContainer) {
        this.pos = valueContainer.getContainerPos();
        this.entryMap = valueEntries.stream().collect(Collectors.toMap(ValueComponent::getId, ValueComponent::getValue));
    }

    public void toBytes(ByteBuf buf) {
        buf.writeLong(this.pos.func_177986_g());
        buf.writeInt(this.entryMap.size());
        this.entryMap.forEach((key, value) -> {
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)key);
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)value);
        });
    }

    public void fromBytes(ByteBuf buf) {
        this.pos = BlockPos.func_177969_a((long)buf.readLong());
        int size = buf.readInt();
        this.entryMap = Maps.newHashMap();
        for (int i = 0; i < size; ++i) {
            String id = ByteBufUtils.readUTF8String((ByteBuf)buf);
            String value = ByteBufUtils.readUTF8String((ByteBuf)buf);
            this.entryMap.put(id, value);
        }
    }

    public IMessage onMessage(MessageUpdateValueContainer message, MessageContext ctx) {
        WorldServer world = ctx.getServerHandler().field_147369_b.func_71121_q();
        TileEntity tileEntity = world.func_175625_s(message.pos);
        if (tileEntity instanceof IValueContainer) {
            ((IValueContainer)tileEntity).updateEntries(message.entryMap);
            TileEntityUtil.syncToClient(tileEntity);
        }
        return null;
    }
}

