/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.client;

import com.mrcrayfish.furniture.client.GifCache;
import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.AbstractMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;

public class GifDownloadThread
extends Thread {
    private static final Set<String> LOADING_URLS = new HashSet<String>();
    private static final Map<Pattern, String> MAP_OF_GIF_HOSTS = Stream.of(new AbstractMap.SimpleEntry<Pattern, String>(Pattern.compile("https:\\/\\/giphy\\.com\\/gifs\\/(?:.*)-(.*)"), "https://i.giphy.com/media/%s/giphy.gif"), new AbstractMap.SimpleEntry<Pattern, String>(Pattern.compile("https:\\/\\/(?:i|media)\\.giphy\\.com\\/media\\/(.*)\\/giphy\\.gif"), "https://i.giphy.com/media/%s/giphy.gif")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    private static final long MAX_FILE_SIZE = 0x200000L;
    private String url;
    private ResponseProcessor processor;
    private int tryCount;

    public GifDownloadThread(String url, ResponseProcessor processor) {
        super("Image Download Thread");
        this.url = url;
        this.processor = processor;
    }

    @Override
    public void run() {
        if (GifCache.INSTANCE.loadCached(this.url)) {
            this.processor.process(ImageDownloadResult.SUCCESS, "Successfully processed GIF");
            return;
        }
        if (GifDownloadThread.isLoading(this.url)) {
            do {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                if (!GifCache.INSTANCE.isCached(this.url)) continue;
                this.processor.process(ImageDownloadResult.SUCCESS, "Successfully processed GIF");
                return;
            } while (this.tryCount++ != 10);
            this.processor.process(ImageDownloadResult.FAILED, "Unable to process GIF");
            return;
        }
        try {
            String asset_url = this.sanatizeUrl(this.url);
            URLConnection connection = new URL(asset_url).openConnection();
            connection.addRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.0)");
            if (!"image/gif".equals(connection.getContentType())) {
                this.processor.process(ImageDownloadResult.UNKNOWN_FILE, "The file is not a GIF");
                return;
            }
            long length = Long.parseLong(connection.getHeaderField("Content-Length"));
            if (length > 0x200000L) {
                this.processor.process(ImageDownloadResult.TOO_LARGE, "The GIF is greater than 2048.0MB");
                return;
            }
            GifDownloadThread.setLoading(this.url, true);
            byte[] data = IOUtils.toByteArray((URLConnection)connection);
            if (GifCache.INSTANCE.add(this.url, data)) {
                GifDownloadThread.setLoading(this.url, false);
                this.processor.process(ImageDownloadResult.SUCCESS, "Successfully processed GIF");
                return;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.processor.process(ImageDownloadResult.FAILED, "Unable to process GIF");
        GifDownloadThread.setLoading(this.url, false);
    }

    private String sanatizeUrl(String url) {
        for (Map.Entry<Pattern, String> host : MAP_OF_GIF_HOSTS.entrySet()) {
            try {
                Matcher matcher = host.getKey().matcher(url);
                if (!matcher.find()) continue;
                return String.format(host.getValue(), matcher.group(1));
            }
            catch (Exception exception) {
            }
        }
        return url;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setLoading(String url, boolean loading) {
        Set<String> set = LOADING_URLS;
        synchronized (set) {
            if (loading) {
                LOADING_URLS.add(url);
            } else {
                LOADING_URLS.remove(url);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isLoading(String url) {
        Set<String> set = LOADING_URLS;
        synchronized (set) {
            return LOADING_URLS.contains(url);
        }
    }

    public static enum ImageDownloadResult {
        SUCCESS("cfm.tv.success"),
        FAILED("cfm.tv.failed"),
        UNKNOWN_FILE("cfm.tv.unknown_file"),
        TOO_LARGE("cfm.tv.too_large");

        private String key;

        private ImageDownloadResult(String key) {
            this.key = key;
        }

        public String getKey() {
            return this.key;
        }
    }

    public static interface ResponseProcessor {
        public void process(ImageDownloadResult var1, String var2);
    }
}

