/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.network;

import com.brandon3055.brandonscore.network.MessageHandlerWrapper;
import com.brandon3055.draconicevolution.blocks.tileentity.TileParticleGenerator;
import io.netty.buffer.ByteBuf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketParticleGenerator
implements IMessage {
    private int tileX;
    private int tileY;
    private int tileZ;
    private byte key;
    private int value;
    private int randomValue;

    public PacketParticleGenerator() {
    }

    public PacketParticleGenerator(int tileX, int tileY, int tileZ, byte key, int value, int rValue) {
        this.tileX = tileX;
        this.tileY = tileY;
        this.tileZ = tileZ;
        this.key = key;
        this.value = value;
        this.randomValue = rValue;
    }

    public void fromBytes(ByteBuf buf) {
        this.tileX = buf.readInt();
        this.tileY = buf.readInt();
        this.tileZ = buf.readInt();
        this.key = buf.readByte();
        this.value = buf.readInt();
        this.randomValue = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.tileX);
        buf.writeInt(this.tileY);
        buf.writeInt(this.tileZ);
        buf.writeByte((int)this.key);
        buf.writeInt(this.value);
        buf.writeInt(this.randomValue);
    }

    public static class Handler
    extends MessageHandlerWrapper<PacketParticleGenerator, IMessage> {
        public IMessage handleMessage(PacketParticleGenerator message, MessageContext ctx) {
            TileParticleGenerator gen;
            TileEntity tile = ctx.getServerHandler().field_147369_b.field_70170_p.func_175625_s(new BlockPos(message.tileX, message.tileY, message.tileZ));
            TileParticleGenerator tileParticleGenerator = gen = tile instanceof TileParticleGenerator ? (TileParticleGenerator)tile : null;
            if (gen != null) {
                switch (message.key) {
                    case 0: {
                        gen.RED.value = message.value;
                        gen.RANDOM_RED.value = message.randomValue;
                        break;
                    }
                    case 1: {
                        gen.GREEN.value = message.value;
                        gen.RANDOM_GREEN.value = message.randomValue;
                        break;
                    }
                    case 2: {
                        gen.BLUE.value = message.value;
                        gen.RANDOM_BLUE.value = message.randomValue;
                        break;
                    }
                    case 3: {
                        gen.ALPHA.value = message.value;
                        gen.RANDOM_ALPHA.value = message.randomValue;
                        break;
                    }
                    case 4: {
                        gen.SCALE.value = (double)message.value / 10000.0;
                        gen.RANDOM_SCALE.value = (double)message.randomValue / 10000.0;
                        break;
                    }
                    case 5: {
                        gen.LIFE.value = message.value;
                        gen.RANDOM_LIFE.value = message.randomValue;
                        break;
                    }
                    case 6: {
                        gen.GRAVITY.value = (double)message.value / 10000.0;
                        gen.RANDOM_GRAVITY.value = (double)message.randomValue / 10000.0;
                        break;
                    }
                    case 7: {
                        gen.FADE.value = message.value;
                        gen.RANDOM_FADE.value = message.randomValue;
                        break;
                    }
                    case 8: {
                        gen.TYPE.value = message.value;
                        break;
                    }
                    case 9: {
                        gen.COLLISION.value = message.value == 1;
                        break;
                    }
                    case 10: {
                        gen.MOTION_X.value = (double)message.value / 10000.0;
                        gen.RANDOM_MOTION_X.value = (double)message.randomValue / 10000.0;
                        break;
                    }
                    case 11: {
                        gen.MOTION_Y.value = (double)message.value / 10000.0;
                        gen.RANDOM_MOTION_Y.value = (double)message.randomValue / 10000.0;
                        break;
                    }
                    case 12: {
                        gen.MOTION_Z.value = (double)message.value / 10000.0;
                        gen.RANDOM_MOTION_Z.value = (double)message.randomValue / 10000.0;
                        break;
                    }
                    case 13: {
                        gen.SPAWN_X.value = (double)message.value / 10000.0;
                        gen.RANDOM_SPAWN_X.value = (double)message.randomValue / 10000.0;
                        break;
                    }
                    case 14: {
                        gen.SPAWN_Y.value = (double)message.value / 10000.0;
                        gen.RANDOM_SPAWN_Y.value = (double)message.randomValue / 10000.0;
                        break;
                    }
                    case 15: {
                        gen.SPAWN_Z.value = (double)message.value / 10000.0;
                        gen.RANDOM_SPAWN_Z.value = (double)message.randomValue / 10000.0;
                        break;
                    }
                    case 16: {
                        gen.DELAY.value = message.value;
                    }
                }
            }
            return null;
        }
    }
}

