/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.integration.jei;

import com.brandon3055.draconicevolution.integration.ModHelper;
import com.brandon3055.draconicevolution.integration.jei.DEJEIPlugin;
import com.brandon3055.draconicevolution.integration.jei.IRecipeRenderer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import mezz.jei.api.IRecipeRegistry;
import mezz.jei.api.gui.IRecipeLayoutDrawable;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.StringUtils;
import net.minecraftforge.fml.common.Optional;

public class JeiHelper {
    public static boolean jeiAvailable() {
        if (!ModHelper.isJEIInstalled) {
            return false;
        }
        return JeiHelper.checkJEDRuntime();
    }

    @Optional.Method(modid="jei")
    public static boolean checkJEDRuntime() {
        return DEJEIPlugin.jeiRuntime != null;
    }

    public static List<IRecipeRenderer> getRecipeRenderers(ItemStack result) {
        if (!JeiHelper.jeiAvailable()) {
            return null;
        }
        return JeiHelper.getRenderers(result);
    }

    @Optional.Method(modid="jei")
    private static List<IRecipeRenderer> getRenderers(ItemStack result) {
        ArrayList<IRecipeRenderer> renderers = new ArrayList<IRecipeRenderer>();
        IRecipeRegistry registry = DEJEIPlugin.jeiRuntime.getRecipeRegistry();
        LinkedList categories = new LinkedList();
        categories.addAll(registry.getRecipeCategories(registry.createFocus(IFocus.Mode.OUTPUT, (Object)result)));
        for (IRecipeCategory category : categories) {
            List wrappers = registry.getRecipeWrappers(category, registry.createFocus(IFocus.Mode.OUTPUT, (Object)result));
            for (Object wrapper : wrappers) {
                try {
                    renderers.add(new RecipeRenderer(category, (IRecipeWrapper)wrapper, result));
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
        return renderers;
    }

    private static class RecipeRenderer
    implements IRecipeRenderer {
        private IRecipeLayoutDrawable recipeLayout;
        private int width;
        private int height;
        private int xPos = 0;
        private int yPos = 0;
        private String title;

        public RecipeRenderer(IRecipeCategory category, IRecipeWrapper wrapper, ItemStack result) {
            IFocus f = DEJEIPlugin.jeiRuntime.getRecipeRegistry().createFocus(IFocus.Mode.OUTPUT, (Object)result);
            this.recipeLayout = DEJEIPlugin.jeiRuntime.getRecipeRegistry().createRecipeLayoutDrawable(category, wrapper, f);
            this.width = category.getBackground().getWidth();
            this.height = category.getBackground().getHeight();
            this.title = category.getTitle();
            if (StringUtils.func_151246_b((String)this.title)) {
                this.title = "[Unknown Crafting Type]";
            }
        }

        @Override
        public int getWidth() {
            return this.width;
        }

        @Override
        public int getHeight() {
            return this.height;
        }

        @Override
        public void render(Minecraft mc, int xPos, int yPos, int mouseX, int mouseY) {
            if (this.xPos != xPos || this.yPos != yPos) {
                this.xPos = xPos;
                this.yPos = yPos;
                this.recipeLayout.setPosition(xPos, yPos);
            }
            this.recipeLayout.draw(mc, mouseX, mouseY);
        }

        @Override
        public boolean handleClick(Minecraft minecraft, int mouseX, int mouseY, int mouseButton) {
            Object clicked = this.recipeLayout.getIngredientUnderMouse(mouseX, mouseY);
            if (clicked != null) {
                IFocus f = DEJEIPlugin.jeiRuntime.getRecipeRegistry().createFocus(mouseButton == 0 ? IFocus.Mode.OUTPUT : IFocus.Mode.INPUT, clicked);
                DEJEIPlugin.jeiRuntime.getRecipesGui().show(f);
            }
            return false;
        }

        @Override
        public String getTitle() {
            return this.title;
        }
    }
}

