/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.gui.modwiki.moddata.guidoctree;

import com.brandon3055.brandonscore.client.gui.modulargui_old.IModularGui;
import com.brandon3055.brandonscore.client.gui.modulargui_old.MGuiElementBase;
import com.brandon3055.brandonscore.client.gui.modulargui_old.modularelements.MGuiListEntry;
import com.brandon3055.draconicevolution.client.gui.modwiki.GuiModWiki;
import com.brandon3055.draconicevolution.client.gui.modwiki.WikiContentList;
import com.brandon3055.draconicevolution.client.gui.modwiki.moddata.WikiDocManager;
import com.brandon3055.draconicevolution.client.gui.modwiki.moddata.displaycontent.DisplayComponentBase;
import com.brandon3055.draconicevolution.client.gui.modwiki.moddata.displaycontent.DisplayComponentRegistry;
import com.brandon3055.draconicevolution.client.gui.modwiki.swing.SwingHelper;
import com.brandon3055.draconicevolution.client.gui.modwiki.swing.UIAddModBranch;
import com.brandon3055.draconicevolution.utils.LogHelper;
import java.io.IOException;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.SoundEvent;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TreeBranchRoot
extends MGuiListEntry {
    public static final String ATTRIB_WEIGHT = "sortingWeight";
    public Element branchData;
    public GuiModWiki guiWiki;
    public LinkedList<TreeBranchRoot> subBranches = new LinkedList();
    public LinkedList<DisplayComponentBase> branchContent = new LinkedList();
    public TreeBranchRoot parent;
    public String branchName = "[Unknown Branch]";
    public String branchID = "ROOT";
    public boolean isModBranch = false;
    public int sortingWeight = 0;
    public static Comparator<DisplayComponentBase> CONTENT_SORTER = new Comparator<DisplayComponentBase>(){

        @Override
        public int compare(DisplayComponentBase o1, DisplayComponentBase o2) {
            return o1.posIndex < o2.posIndex ? -1 : (o1.posIndex > o2.posIndex ? 1 : 0);
        }
    };
    public static Comparator<TreeBranchRoot> BRANCH_SORTER = new Comparator<TreeBranchRoot>(){

        @Override
        public int compare(TreeBranchRoot o1, TreeBranchRoot o2) {
            return o1.sortingWeight < o2.sortingWeight ? -1 : (o1.sortingWeight > o2.sortingWeight ? 1 : 0);
        }
    };

    public TreeBranchRoot(GuiModWiki guiWiki, TreeBranchRoot parent, String branchName) {
        super((IModularGui)guiWiki);
        this.parent = parent;
        this.branchName = branchName;
        this.guiWiki = guiWiki;
        this.ySize = 20;
        this.xSize = guiWiki.wikiList != null ? guiWiki.wikiList.getListEntryWidth() : 50;
    }

    public void initBranches() {
        for (TreeBranchRoot sub : this.subBranches) {
            sub.initBranches();
        }
    }

    public void addSubBranch(TreeBranchRoot branch) {
        this.subBranches.add(branch);
    }

    public int getEntryHeight() {
        return this.ySize;
    }

    public void moveEntry(int newXPos, int newYPos) {
        this.xPos = newXPos;
        this.yPos = newYPos;
        for (MGuiElementBase element : this.childElements) {
            element.xPos = newXPos;
            element.yPos = newYPos;
        }
        this.positionElements(newXPos, newYPos);
    }

    public void positionElements(int newXPos, int newYPos) {
    }

    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (this.isMouseOver(mouseX, mouseY)) {
            this.guiWiki.wikiDataTree.setActiveBranch(this);
            this.modularGui.getMinecraft().func_147118_V().func_147682_a((ISound)PositionedSoundRecord.func_184371_a((SoundEvent)SoundEvents.field_187909_gi, (float)1.0f));
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public void createNewSubBranch() {
        UIAddModBranch frame = new UIAddModBranch(this);
        frame.pack();
        frame.setVisible(true);
        SwingHelper.centerOnMinecraftWindow(frame);
    }

    public void createNewSubBranch(String name, String id, String category, TreeBranchRoot branch) {
        this.guiWiki.wikiList.toAddList.add(new WikiContentList.ToAdd(name, id, category, branch));
    }

    public void setBranchID(String id) {
        this.branchID = id;
        this.guiWiki.wikiDataTree.idToBranchMap.put(id, this);
    }

    public void save() throws Exception {
        WikiDocManager.saveChanges(this.branchData.getOwnerDocument());
    }

    public void loadBranchContent() {
        this.branchContent.clear();
        if (this.branchData.hasAttribute(ATTRIB_WEIGHT)) {
            try {
                this.sortingWeight = Integer.parseInt(this.branchData.getAttribute(ATTRIB_WEIGHT));
                if (this.sortingWeight < 0) {
                    this.sortingWeight = 0;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        NodeList nodeList = this.branchData.getElementsByTagName("content");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getParentNode() != this.branchData) continue;
            if (!(node instanceof Element)) {
                LogHelper.dev("Node Is Not An Element: " + node);
                continue;
            }
            Element content = (Element)node;
            String type = content.getAttribute("type");
            DisplayComponentBase displayComponent = DisplayComponentRegistry.createComponent(this.guiWiki, type, content, this);
            if (displayComponent == null) continue;
            this.branchContent.add(displayComponent);
        }
        Collections.sort(this.branchContent, CONTENT_SORTER);
    }
}

