/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.itemupgrade;

import com.brandon3055.brandonscore.utils.InfoHelper;
import com.brandon3055.draconicevolution.api.itemupgrade.IUpgradableItem;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class UpgradeHelper {
    public static final String UPGRADE_TAG = "DEUpgrades";

    public static int getUpgradeLevel(ItemStack stack, String upgrade) {
        if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b(UPGRADE_TAG)) {
            return 0;
        }
        NBTTagCompound upgradeTag = stack.func_190925_c(UPGRADE_TAG);
        return upgradeTag.func_74771_c(upgrade);
    }

    public static void setUpgradeLevel(ItemStack stack, String upgrade, int level) {
        NBTTagCompound upgradeTag = stack.func_190925_c(UPGRADE_TAG);
        upgradeTag.func_74774_a(upgrade, (byte)level);
    }

    public static Map<String, Integer> getUpgrades(ItemStack stack) {
        HashMap<String, Integer> upgrades = new HashMap<String, Integer>();
        if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b(UPGRADE_TAG)) {
            return upgrades;
        }
        NBTTagCompound upgradeTag = stack.func_190925_c(UPGRADE_TAG);
        for (String upgrade : upgradeTag.func_150296_c()) {
            if (!upgradeTag.func_150297_b(upgrade, 1)) continue;
            upgrades.put(upgrade, Integer.valueOf(upgradeTag.func_74771_c(upgrade)));
        }
        return upgrades;
    }

    public static void setUpgrades(ItemStack stack, Map<String, Integer> upgrades) {
        if (!(stack.func_77973_b() instanceof IUpgradableItem)) {
            return;
        }
        IUpgradableItem item = (IUpgradableItem)stack.func_77973_b();
        for (String upgrade : upgrades.keySet()) {
            if (!item.getValidUpgrades(stack).contains(upgrade)) continue;
            UpgradeHelper.setUpgradeLevel(stack, upgrade, upgrades.get(upgrade));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static List<String> getUpgradeStats(ItemStack stack) {
        ArrayList<String> list = new ArrayList<String>();
        if (stack.func_77973_b() instanceof IUpgradableItem) {
            for (String upgrade : ((IUpgradableItem)stack.func_77973_b()).getValidUpgrades(stack)) {
                list.add(InfoHelper.ITC() + I18n.func_135052_a((String)("upgrade.de." + upgrade + ".name"), (Object[])new Object[0]) + " " + InfoHelper.HITC() + I18n.func_135052_a((String)("upgrade.level." + UpgradeHelper.getUpgradeLevel(stack, upgrade)), (Object[])new Object[0]));
            }
        }
        return list;
    }
}

