/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api.itemupgrade;

import com.brandon3055.draconicevolution.DEFeatures;
import com.brandon3055.draconicevolution.api.OreDictHelper;
import com.brandon3055.draconicevolution.api.fusioncrafting.ICraftingInjector;
import com.brandon3055.draconicevolution.api.fusioncrafting.IFusionCraftingInventory;
import com.brandon3055.draconicevolution.api.fusioncrafting.IFusionRecipe;
import com.brandon3055.draconicevolution.api.itemupgrade.IUpgradableItem;
import com.brandon3055.draconicevolution.api.itemupgrade.UpgradeHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class FusionUpgradeRecipe
implements IFusionRecipe {
    public final int upgradeLevel;
    public final ItemStack upgradeKey;
    public final String upgrade;
    protected List<Object> ingredients;
    protected long energyCost;
    protected int craftingTier;
    private static Item[] tools = new Item[]{DEFeatures.wyvernAxe, DEFeatures.draconicAxe, DEFeatures.wyvernShovel, DEFeatures.draconicShovel, DEFeatures.wyvernPick, DEFeatures.draconicPick, DEFeatures.wyvernSword, DEFeatures.draconicSword, DEFeatures.wyvernBow, DEFeatures.draconicBow, DEFeatures.draconicStaffOfPower};
    private static Random rand = new Random();

    public FusionUpgradeRecipe(String upgrade, ItemStack upgradeKey, long energyCost, int craftingTier, int upgradeLevel, Object ... ingredients) {
        this.upgrade = upgrade;
        this.upgradeLevel = upgradeLevel;
        this.upgradeKey = upgradeKey;
        this.ingredients = new LinkedList<Object>();
        Collections.addAll(this.ingredients, ingredients);
        this.ingredients.add(upgradeKey);
        this.energyCost = energyCost;
        this.craftingTier = craftingTier;
    }

    @Override
    public ItemStack getRecipeOutput(@Nonnull ItemStack catalyst) {
        if (catalyst.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack stack = catalyst.func_77946_l();
        UpgradeHelper.setUpgradeLevel(stack, this.upgrade, this.upgradeLevel);
        return stack;
    }

    @Override
    public boolean isRecipeCatalyst(ItemStack catalyst) {
        return !catalyst.func_190926_b() && catalyst.func_77973_b() instanceof IUpgradableItem && ((IUpgradableItem)catalyst.func_77973_b()).getValidUpgrades(catalyst).contains(this.upgrade);
    }

    @Override
    public ItemStack getRecipeCatalyst() {
        return ItemStack.field_190927_a;
    }

    @Override
    public int getRecipeTier() {
        return this.craftingTier;
    }

    @Override
    public List<Object> getRecipeIngredients() {
        return this.ingredients;
    }

    @Override
    public boolean matches(IFusionCraftingInventory inventory, World world, BlockPos pos) {
        ArrayList<ICraftingInjector> pedestals = new ArrayList<ICraftingInjector>();
        pedestals.addAll(inventory.getInjectors());
        if (!this.isRecipeCatalyst(inventory.getStackInCore(0))) {
            return false;
        }
        boolean flag = false;
        for (ICraftingInjector pedestal : pedestals) {
            if (pedestal.getStackInPedestal().func_190926_b() || !this.upgradeKey.func_77969_a(pedestal.getStackInPedestal())) continue;
            flag = true;
            break;
        }
        if (!flag) {
            return false;
        }
        for (Object ingredient : this.ingredients) {
            flag = false;
            for (ICraftingInjector pedestal : pedestals) {
                if (pedestal.getStackInPedestal().func_190926_b() || !OreDictHelper.areStacksEqual(ingredient, pedestal.getStackInPedestal())) continue;
                flag = true;
                pedestals.remove(pedestal);
                break;
            }
            if (flag) continue;
            return false;
        }
        for (ICraftingInjector pedestal : pedestals) {
            if (pedestal.getStackInPedestal().func_190926_b() || pedestal.getStackInPedestal().func_77969_a(this.upgradeKey)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String canCraft(IFusionCraftingInventory inventory, World world, BlockPos pos) {
        if (!this.isRecipeCatalyst(inventory.getStackInCore(0))) {
            return "upgrade.de.upgradeNA.info";
        }
        if (!inventory.getStackInCore(1).func_190926_b()) {
            return "outputObstructed";
        }
        IUpgradableItem item = (IUpgradableItem)inventory.getStackInCore(0).func_77973_b();
        if (item.getMaxUpgradeLevel(inventory.getStackInCore(0), this.upgrade) < this.upgradeLevel) {
            return "upgrade.de.upgradeLevelToHigh.info";
        }
        if (UpgradeHelper.getUpgradeLevel(inventory.getStackInCore(0), this.upgrade) >= this.upgradeLevel) {
            return "upgrade.de.upgradeApplied.info";
        }
        if (UpgradeHelper.getUpgradeLevel(inventory.getStackInCore(0), this.upgrade) < this.upgradeLevel - 1) {
            return "upgrade.de.upgradePrevLevelRequired.info";
        }
        ArrayList<ICraftingInjector> pedestals = new ArrayList<ICraftingInjector>();
        pedestals.addAll(inventory.getInjectors());
        for (ICraftingInjector pedestal : pedestals) {
            if (pedestal.getStackInPedestal().func_190926_b() || pedestal.getPedestalTier() >= this.craftingTier) continue;
            return "tierLow";
        }
        return "true";
    }

    @Override
    public void craft(IFusionCraftingInventory inventory, World world, BlockPos pos) {
        if (!this.matches(inventory, world, pos)) {
            return;
        }
        ArrayList<ICraftingInjector> pedestals = new ArrayList<ICraftingInjector>();
        pedestals.addAll(inventory.getInjectors());
        block0: for (Object ingredient : this.ingredients) {
            for (ICraftingInjector pedestal : pedestals) {
                if (pedestal.getStackInPedestal().func_190926_b() || !OreDictHelper.areStacksEqual(ingredient, pedestal.getStackInPedestal()) || pedestal.getPedestalTier() < this.craftingTier || pedestal.getStackInPedestal().func_77969_a(this.upgradeKey)) continue;
                ItemStack stack = pedestal.getStackInPedestal();
                if (stack.func_77973_b().hasContainerItem(stack)) {
                    stack = stack.func_77973_b().getContainerItem(stack);
                } else {
                    stack.func_190918_g(1);
                    if (stack.func_190916_E() <= 0) {
                        stack = ItemStack.field_190927_a;
                    }
                }
                pedestal.setStackInPedestal(stack);
                pedestals.remove(pedestal);
                continue block0;
            }
        }
        ItemStack stack = inventory.getStackInCore(0);
        inventory.setStackInCore(0, ItemStack.field_190927_a);
        UpgradeHelper.setUpgradeLevel(stack, this.upgrade, this.upgradeLevel);
        inventory.setStackInCore(1, stack);
    }

    @Override
    public long getIngredientEnergyCost() {
        return this.energyCost;
    }

    @Override
    public void onCraftingTick(IFusionCraftingInventory inventory, World world, BlockPos pos) {
    }

    public String toString() {
        return String.format("FusionUpgradeRecipe: [Upgrade: %s, Level: %s]", this.upgrade, this.upgradeLevel);
    }
}

