/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.api;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.oredict.OreDictionary;

public class OreDictHelper {
    public static boolean areStacksEqual(Object oreStack, ItemStack compare) {
        if (oreStack instanceof String) {
            int[] ids;
            if (!OreDictionary.doesOreNameExist((String)((String)oreStack))) {
                return false;
            }
            for (int id : ids = OreDictionary.getOreIDs((ItemStack)compare)) {
                if (!OreDictionary.getOreName((int)id).equals(oreStack)) continue;
                return true;
            }
        } else {
            if (oreStack instanceof ItemStack) {
                return OreDictionary.itemMatches((ItemStack)compare, (ItemStack)((ItemStack)oreStack), (boolean)false);
            }
            if (oreStack instanceof Item) {
                return OreDictHelper.areStacksEqual(new ItemStack((Item)oreStack), compare);
            }
            if (oreStack instanceof Block) {
                return OreDictHelper.areStacksEqual(new ItemStack((Block)oreStack), compare);
            }
        }
        return false;
    }

    @Nonnull
    public static ItemStack findFirstOreMatch(String oreName) {
        if (!OreDictionary.doesOreNameExist((String)oreName)) {
            return ItemStack.field_190927_a;
        }
        NonNullList stacks = OreDictionary.getOres((String)oreName);
        if (stacks.size() == 0) {
            return ItemStack.field_190927_a;
        }
        if (stacks.size() == 1) {
            return (ItemStack)stacks.get(0);
        }
        if (Loader.isModLoaded((String)"ThermalFoundation")) {
            for (ItemStack stack : stacks) {
                ResourceLocation name;
                if (!(stack.func_77973_b() instanceof ItemBlock ? (name = (ResourceLocation)Block.field_149771_c.func_177774_c((Object)((ItemBlock)stack.func_77973_b()).func_179223_d())).func_110624_b().equals("ThermalFoundation") : (name = (ResourceLocation)Item.field_150901_e.func_177774_c((Object)stack.func_77973_b())) != null && name.func_110624_b().equals("ThermalFoundation"))) continue;
                return stack;
            }
        }
        return (ItemStack)stacks.get(0);
    }

    @Nonnull
    public static ItemStack resolveObject(Object object) {
        if (object instanceof String) {
            return OreDictHelper.findFirstOreMatch((String)object);
        }
        if (object instanceof ItemStack) {
            return (ItemStack)object;
        }
        if (object instanceof Item) {
            return new ItemStack((Item)object);
        }
        if (object instanceof Block) {
            return new ItemStack((Block)object);
        }
        return ItemStack.field_190927_a;
    }
}

