/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.useful_railroads.block;

import com.google.common.collect.Maps;
import info.u_team.useful_railroads.block.BlockCustomRail;
import java.util.LinkedHashMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockRailIntersection
extends BlockCustomRail {
    public BlockRailIntersection(String name) {
        super(name);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel() {
        super.registerModel();
        ModelLoader.setCustomStateMapper((Block)this, block -> {
            LinkedHashMap models = Maps.newLinkedHashMap();
            ResourceLocation registryname = block.getRegistryName();
            for (BlockRailBase.EnumRailDirection direction : BlockRailBase.EnumRailDirection.values()) {
                models.put(this.func_176223_P().func_177226_a((IProperty)field_176565_b, (Comparable)direction), new ModelResourceLocation(registryname, "normal"));
            }
            return models;
        });
    }

    public BlockRailBase.EnumRailDirection getRailDirection(IBlockAccess world, BlockPos pos, IBlockState state, EntityMinecart cart) {
        if (cart != null) {
            if (Math.abs(cart.field_70159_w) > Math.abs(cart.field_70179_y)) {
                return BlockRailBase.EnumRailDirection.EAST_WEST;
            }
            return BlockRailBase.EnumRailDirection.NORTH_SOUTH;
        }
        return super.getRailDirection(world, pos, state, cart);
    }

    public boolean canMakeSlopes(IBlockAccess world, BlockPos pos) {
        return false;
    }

    public boolean isFlexibleRail(IBlockAccess world, BlockPos pos) {
        return false;
    }
}

