/*
 * Decompiled with CFR 0.152.
 */
package info.u_team.useful_railroads.block;

import com.google.common.collect.Maps;
import info.u_team.useful_railroads.block.BlockCustomRailPowered;
import java.util.LinkedHashMap;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRailBase;
import net.minecraft.block.BlockRailPowered;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockRailDirection
extends BlockCustomRailPowered {
    public static final PropertyBool AXIS_DIRECTION = PropertyBool.func_177716_a((String)"positive_axis");

    public BlockRailDirection(String name) {
        super(name);
        this.func_180632_j(this.func_176223_P().func_177226_a((IProperty)AXIS_DIRECTION, (Comparable)Boolean.valueOf(false)));
    }

    @Override
    public void onMinecartPassPowered(World world, EntityMinecart cart, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        BlockRailBase.EnumRailDirection shape = this.getRailDirection((IBlockAccess)world, pos, state, cart);
        boolean positive_axis = (Boolean)state.func_177229_b((IProperty)AXIS_DIRECTION);
        if (shape == BlockRailBase.EnumRailDirection.EAST_WEST) {
            cart.field_70159_w = positive_axis ? 0.6 : -0.6;
        } else if (shape == BlockRailBase.EnumRailDirection.NORTH_SOUTH) {
            cart.field_70179_y = positive_axis ? 0.6 : -0.6;
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel() {
        this.setModel(this.getItem(), 0, this.getRegistryName());
        ModelLoader.setCustomStateMapper((Block)this, block -> {
            LinkedHashMap models = Maps.newLinkedHashMap();
            ResourceLocation registryname = block.getRegistryName();
            models.put(this.func_176223_P().func_177226_a((IProperty)field_176569_M, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)field_176568_b, (Comparable)BlockRailBase.EnumRailDirection.NORTH_SOUTH).func_177226_a((IProperty)AXIS_DIRECTION, (Comparable)Boolean.valueOf(false)), new ModelResourceLocation(registryname, "powered=false,shape=north"));
            models.put(this.func_176223_P().func_177226_a((IProperty)field_176569_M, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)field_176568_b, (Comparable)BlockRailBase.EnumRailDirection.EAST_WEST).func_177226_a((IProperty)AXIS_DIRECTION, (Comparable)Boolean.valueOf(false)), new ModelResourceLocation(registryname, "powered=false,shape=west"));
            models.put(this.func_176223_P().func_177226_a((IProperty)field_176569_M, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)field_176568_b, (Comparable)BlockRailBase.EnumRailDirection.NORTH_SOUTH).func_177226_a((IProperty)AXIS_DIRECTION, (Comparable)Boolean.valueOf(false)), new ModelResourceLocation(registryname, "powered=true,shape=north"));
            models.put(this.func_176223_P().func_177226_a((IProperty)field_176569_M, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)field_176568_b, (Comparable)BlockRailBase.EnumRailDirection.EAST_WEST).func_177226_a((IProperty)AXIS_DIRECTION, (Comparable)Boolean.valueOf(false)), new ModelResourceLocation(registryname, "powered=true,shape=west"));
            models.put(this.func_176223_P().func_177226_a((IProperty)field_176569_M, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)field_176568_b, (Comparable)BlockRailBase.EnumRailDirection.NORTH_SOUTH).func_177226_a((IProperty)AXIS_DIRECTION, (Comparable)Boolean.valueOf(true)), new ModelResourceLocation(registryname, "powered=false,shape=south"));
            models.put(this.func_176223_P().func_177226_a((IProperty)field_176569_M, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)field_176568_b, (Comparable)BlockRailBase.EnumRailDirection.EAST_WEST).func_177226_a((IProperty)AXIS_DIRECTION, (Comparable)Boolean.valueOf(true)), new ModelResourceLocation(registryname, "powered=false,shape=east"));
            models.put(this.func_176223_P().func_177226_a((IProperty)field_176569_M, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)field_176568_b, (Comparable)BlockRailBase.EnumRailDirection.NORTH_SOUTH).func_177226_a((IProperty)AXIS_DIRECTION, (Comparable)Boolean.valueOf(true)), new ModelResourceLocation(registryname, "powered=true,shape=south"));
            models.put(this.func_176223_P().func_177226_a((IProperty)field_176569_M, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)field_176568_b, (Comparable)BlockRailBase.EnumRailDirection.EAST_WEST).func_177226_a((IProperty)AXIS_DIRECTION, (Comparable)Boolean.valueOf(true)), new ModelResourceLocation(registryname, "powered=true,shape=east"));
            return models;
        });
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        EnumFacing placeFacing = placer.func_174811_aO();
        return this.func_176223_P().func_177226_a((IProperty)AXIS_DIRECTION, (Comparable)Boolean.valueOf(placeFacing.func_176743_c() == EnumFacing.AxisDirection.POSITIVE)).func_177226_a((IProperty)field_176568_b, (Comparable)(placeFacing.func_176740_k() == EnumFacing.Axis.Z ? BlockRailBase.EnumRailDirection.NORTH_SOUTH : BlockRailBase.EnumRailDirection.EAST_WEST));
    }

    public IBlockState func_176203_a(int meta) {
        boolean powered = (meta & 1) == 1;
        boolean axis_direction = (meta >> 1 & 1) == 1;
        int shape = meta >> 2 & 1;
        return this.func_176223_P().func_177226_a((IProperty)field_176569_M, (Comparable)Boolean.valueOf(powered)).func_177226_a((IProperty)AXIS_DIRECTION, (Comparable)Boolean.valueOf(axis_direction)).func_177226_a((IProperty)field_176568_b, (Comparable)BlockRailBase.EnumRailDirection.func_177016_a((int)shape));
    }

    public int func_176201_c(IBlockState state) {
        boolean powered = (Boolean)state.func_177229_b((IProperty)field_176569_M);
        boolean axis_direction = (Boolean)state.func_177229_b((IProperty)AXIS_DIRECTION);
        int shape = ((BlockRailBase.EnumRailDirection)state.func_177229_b((IProperty)field_176568_b)).func_177015_a();
        int meta = powered ? 1 : 0;
        meta |= (axis_direction ? 1 : 0) << 1;
        return meta |= (shape %= 2) << 2;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_176569_M, AXIS_DIRECTION, field_176568_b});
    }

    protected IBlockState func_176564_a(World world, BlockPos pos, IBlockState state, boolean initialPlacement) {
        return world.field_72995_K ? state : new DirectionRail(world, pos, state).func_180364_a(world.func_175640_z(pos), initialPlacement).func_180362_b();
    }

    public class DirectionRail
    extends BlockRailBase.Rail {
        public DirectionRail(World world, BlockPos pos, IBlockState state) {
            super((BlockRailBase)BlockRailDirection.this, world, pos, state);
        }

        public BlockRailBase.Rail func_180364_a(boolean powered, boolean initialPlacement) {
            boolean hasRailNorth = this.func_180361_d(this.field_180367_c.func_177978_c());
            boolean hasRailSouth = this.func_180361_d(this.field_180367_c.func_177968_d());
            boolean hasRailWest = this.func_180361_d(this.field_180367_c.func_177976_e());
            boolean hasRailEast = this.func_180361_d(this.field_180367_c.func_177974_f());
            BlockRailBase.EnumRailDirection direction = null;
            boolean positive_axis = (Boolean)this.field_180366_e.func_177229_b((IProperty)AXIS_DIRECTION);
            if ((hasRailNorth || hasRailSouth) && !hasRailWest && !hasRailEast) {
                direction = BlockRailBase.EnumRailDirection.NORTH_SOUTH;
                if (hasRailNorth && !hasRailSouth) {
                    positive_axis = false;
                } else if (hasRailSouth && !hasRailNorth) {
                    positive_axis = true;
                }
            }
            if ((hasRailWest || hasRailEast) && !hasRailNorth && !hasRailSouth) {
                direction = BlockRailBase.EnumRailDirection.EAST_WEST;
                if (hasRailWest && !hasRailEast) {
                    positive_axis = false;
                } else if (hasRailEast && !hasRailWest) {
                    positive_axis = true;
                }
            }
            if (direction == null) {
                direction = (BlockRailBase.EnumRailDirection)this.field_180366_e.func_177229_b((IProperty)BlockRailPowered.field_176568_b);
            }
            this.func_180360_a(direction);
            this.field_180366_e = this.field_180366_e.func_177226_a((IProperty)BlockRailPowered.field_176568_b, (Comparable)direction).func_177226_a((IProperty)AXIS_DIRECTION, (Comparable)Boolean.valueOf(positive_axis));
            if (initialPlacement || this.field_150660_b.func_180495_p(this.field_180367_c) != this.field_180366_e) {
                this.field_150660_b.func_180501_a(this.field_180367_c, this.field_180366_e, 3);
                for (int i = 0; i < this.field_150657_g.size(); ++i) {
                    BlockRailBase.Rail rail = this.func_180697_b((BlockPos)this.field_150657_g.get(i));
                    if (rail == null) continue;
                    rail.func_150651_b();
                    if (!rail.func_150649_b((BlockRailBase.Rail)this)) continue;
                    rail.func_150645_c((BlockRailBase.Rail)this);
                }
            }
            return this;
        }
    }
}

