/*
 * Decompiled with CFR 0.152.
 */
package com.blakebr0.cucumber.fluid;

import com.blakebr0.cucumber.iface.IFluidHolder;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class FluidHolderItemWrapper
implements ICapabilityProvider {
    private ItemStack stack;
    private IFluidHolder holder;
    private boolean canFill;
    private boolean canDrain;

    public FluidHolderItemWrapper(ItemStack stack, IFluidHolder holder, boolean canFill, boolean canDrain) {
        this.stack = stack;
        this.holder = holder;
        this.canFill = canFill;
        this.canDrain = canDrain;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY;
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (!this.hasCapability(capability, facing)) {
            return null;
        }
        return (T)CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY.cast((Object)new IFluidHandlerItem(){

            public IFluidTankProperties[] getTankProperties() {
                return new IFluidTankProperties[]{new FluidTankProperties(FluidHolderItemWrapper.this.holder.getFluid(FluidHolderItemWrapper.this.stack), FluidHolderItemWrapper.this.holder.getCapacity(FluidHolderItemWrapper.this.stack), FluidHolderItemWrapper.this.canFill, FluidHolderItemWrapper.this.canDrain)};
            }

            public int fill(FluidStack fluid, boolean canFill) {
                return FluidHolderItemWrapper.this.holder.fill(FluidHolderItemWrapper.this.stack, fluid, canFill);
            }

            public FluidStack drain(int amount, boolean canDrain) {
                return FluidHolderItemWrapper.this.holder.drain(FluidHolderItemWrapper.this.stack, amount, canDrain);
            }

            public FluidStack drain(FluidStack fluid, boolean canDrain) {
                if (fluid.isFluidEqual(FluidHolderItemWrapper.this.holder.getFluid(FluidHolderItemWrapper.this.stack))) {
                    return FluidHolderItemWrapper.this.holder.drain(FluidHolderItemWrapper.this.stack, fluid.amount, canDrain);
                }
                return null;
            }

            public ItemStack getContainer() {
                return FluidHolderItemWrapper.this.stack;
            }
        });
    }
}

