/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.network;

import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import twilightforest.capabilities.CapabilityList;
import twilightforest.capabilities.shield.IShieldCapability;

public class PacketUpdateShield
implements IMessage {
    private int entityID;
    private int temporaryShields;
    private int permanentShields;

    public PacketUpdateShield() {
    }

    public PacketUpdateShield(int id, IShieldCapability cap) {
        this.entityID = id;
        this.temporaryShields = cap.temporaryShieldsLeft();
        this.permanentShields = cap.permanentShieldsLeft();
    }

    public PacketUpdateShield(Entity entity, IShieldCapability cap) {
        this(entity.func_145782_y(), cap);
    }

    public void fromBytes(ByteBuf buf) {
        this.entityID = buf.readInt();
        this.temporaryShields = buf.readInt();
        this.permanentShields = buf.readInt();
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.entityID);
        buf.writeInt(this.temporaryShields);
        buf.writeInt(this.permanentShields);
    }

    public static class Handler
    implements IMessageHandler<PacketUpdateShield, IMessage> {
        public IMessage onMessage(final PacketUpdateShield message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(new Runnable(){

                @Override
                public void run() {
                    IShieldCapability cap;
                    Entity entity = Minecraft.func_71410_x().field_71441_e.func_73045_a(message.entityID);
                    if (entity instanceof EntityLivingBase && (cap = (IShieldCapability)entity.getCapability(CapabilityList.SHIELDS, null)) != null) {
                        cap.setShields(message.temporaryShields, true);
                        cap.setShields(message.permanentShields, false);
                    }
                }
            });
            return null;
        }
    }
}

