/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.passive;

import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootContext;
import twilightforest.TFFeature;
import twilightforest.TwilightForestMod;
import twilightforest.advancements.TFAdvancements;
import twilightforest.entity.ai.EntityAITFEatLoose;
import twilightforest.entity.ai.EntityAITFFindLoose;

public class EntityTFQuestRam
extends EntityAnimal {
    public static final ResourceLocation LOOT_TABLE = TwilightForestMod.prefix("entities/quest_ram");
    public static final ResourceLocation REWARD_LOOT_TABLE = TwilightForestMod.prefix("entities/questing_ram_rewards");
    private static final DataParameter<Integer> DATA_COLOR = EntityDataManager.func_187226_a(EntityTFQuestRam.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> DATA_REWARDED = EntityDataManager.func_187226_a(EntityTFQuestRam.class, (DataSerializer)DataSerializers.field_187198_h);
    private int randomTickDivider;

    public EntityTFQuestRam(World world) {
        super(world);
        this.func_70105_a(1.25f, 2.9f);
        this.randomTickDivider = 0;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIPanic((EntityCreature)this, (double)1.38f));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.0, Item.func_150898_a((Block)Blocks.field_150325_L), false));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITFEatLoose(this, Item.func_150898_a((Block)Blocks.field_150325_L)));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAITFFindLoose((EntityCreature)this, 1.0f, Item.func_150898_a((Block)Blocks.field_150325_L)));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    public EntityAnimal createChild(EntityAgeable entityanimal) {
        return null;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(70.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.23f);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATA_COLOR, (Object)0);
        this.field_70180_af.func_187214_a(DATA_REWARDED, (Object)false);
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public ResourceLocation func_184647_J() {
        return LOOT_TABLE;
    }

    protected void func_70619_bc() {
        if (--this.randomTickDivider <= 0) {
            int chunkZ;
            this.randomTickDivider = 70 + this.field_70146_Z.nextInt(50);
            int chunkX = MathHelper.func_76128_c((double)this.field_70165_t) / 16;
            TFFeature nearFeature = TFFeature.getNearestFeature(chunkX, chunkZ = MathHelper.func_76128_c((double)this.field_70161_v) / 16, this.field_70170_p);
            if (nearFeature != TFFeature.QUEST_GROVE) {
                this.func_110177_bN();
            } else {
                BlockPos cc = TFFeature.getNearestCenterXYZ(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70161_v), this.field_70170_p);
                this.func_175449_a(cc, 13);
            }
            if (this.countColorsSet() > 15 && !this.getRewarded()) {
                this.rewardQuest();
                this.setRewarded(true);
            }
        }
        super.func_70619_bc();
    }

    private void rewardQuest() {
        LootContext ctx = new LootContext.Builder((WorldServer)this.field_70170_p).func_186472_a((Entity)this).func_186471_a();
        for (ItemStack s : this.field_70170_p.func_184146_ak().func_186521_a(REWARD_LOOT_TABLE).func_186462_a(this.field_70170_p.field_73012_v, ctx)) {
            this.func_70099_a(s, 1.0f);
        }
        for (EntityPlayerMP player : this.field_70170_p.func_72872_a(EntityPlayerMP.class, this.func_174813_aQ().func_72314_b(16.0, 16.0, 16.0))) {
            TFAdvancements.QUEST_RAM_COMPLETED.trigger(player);
        }
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack currentItem = player.func_184586_b(hand);
        if (!currentItem.func_190926_b() && currentItem.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150325_L) && !this.isColorPresent(EnumDyeColor.func_176764_b((int)currentItem.func_77952_i()))) {
            this.setColorPresent(EnumDyeColor.func_176764_b((int)currentItem.func_77952_i()));
            this.animateAddColor(EnumDyeColor.func_176764_b((int)currentItem.func_77952_i()), 50);
            if (!player.field_71075_bZ.field_75098_d) {
                currentItem.func_190918_g(1);
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K && this.countColorsSet() > 15 && !this.getRewarded()) {
            this.animateAddColor(EnumDyeColor.func_176764_b((int)this.field_70146_Z.nextInt(16)), 5);
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("ColorFlags", this.getColorFlags());
        compound.func_74757_a("Rewarded", this.getRewarded());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setColorFlags(compound.func_74762_e("ColorFlags"));
        this.setRewarded(compound.func_74767_n("Rewarded"));
    }

    public int getColorFlags() {
        return (Integer)this.field_70180_af.func_187225_a(DATA_COLOR);
    }

    public void setColorFlags(int flags) {
        this.field_70180_af.func_187227_b(DATA_COLOR, (Object)flags);
    }

    public boolean isColorPresent(EnumDyeColor color) {
        return (this.getColorFlags() & 1 << color.func_176765_a()) > 0;
    }

    public void setColorPresent(EnumDyeColor color) {
        this.setColorFlags(this.getColorFlags() | 1 << color.func_176765_a());
    }

    public boolean getRewarded() {
        return (Boolean)this.field_70180_af.func_187225_a(DATA_REWARDED);
    }

    public void setRewarded(boolean rewarded) {
        this.field_70180_af.func_187227_b(DATA_REWARDED, (Object)rewarded);
    }

    public void animateAddColor(EnumDyeColor color, int iterations) {
        float[] colorVal = color.func_193349_f();
        int red = (int)(colorVal[0] * 255.0f);
        int green = (int)(colorVal[1] * 255.0f);
        int blue = (int)(colorVal[2] * 255.0f);
        for (int i = 0; i < iterations; ++i) {
            this.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_MOB, this.field_70165_t + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 1.5, this.field_70163_u + this.field_70146_Z.nextDouble() * (double)this.field_70131_O * 1.5, this.field_70161_v + (this.field_70146_Z.nextDouble() - 0.5) * (double)this.field_70130_N * 1.5, (double)red, (double)green, (double)blue, new int[0]);
        }
        this.func_70642_aH();
    }

    public int countColorsSet() {
        return Integer.bitCount(this.getColorFlags());
    }

    protected float func_70599_aP() {
        return 5.0f;
    }

    protected float func_70647_i() {
        return (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 0.7f;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187757_eG;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundEvents.field_187761_eI;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187759_eH;
    }

    protected void func_180429_a(BlockPos pos, Block block) {
        this.func_184185_a(SoundEvents.field_187765_eK, 0.15f, 1.0f);
    }
}

