/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.ai;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import twilightforest.entity.ai.EntityAITFHoverBase;
import twilightforest.entity.boss.EntityTFSnowQueen;

public class EntityAITFHoverBeam
extends EntityAITFHoverBase<EntityTFSnowQueen> {
    private int hoverTimer;
    private int beamTimer;
    private int seekTimer;
    private final int maxHoverTime;
    private final int maxBeamTime;
    private final int maxSeekTime;
    private double beamY;
    private boolean isInPosition;

    public EntityAITFHoverBeam(EntityTFSnowQueen snowQueen, int hoverTime, int dropTime) {
        super(snowQueen, 3.0f, 4.0f);
        this.func_75248_a(3);
        this.maxHoverTime = hoverTime;
        this.maxSeekTime = hoverTime;
        this.maxBeamTime = dropTime;
        this.hoverTimer = 0;
        this.isInPosition = false;
    }

    public boolean func_75250_a() {
        EntityLivingBase target = ((EntityTFSnowQueen)this.attacker).func_70638_az();
        if (target == null) {
            return false;
        }
        if (!target.func_70089_S()) {
            return false;
        }
        return ((EntityTFSnowQueen)this.attacker).getCurrentPhase() == EntityTFSnowQueen.Phase.BEAM;
    }

    public boolean func_75253_b() {
        EntityLivingBase target = ((EntityTFSnowQueen)this.attacker).func_70638_az();
        if (target == null || !target.func_70089_S()) {
            return false;
        }
        if (((EntityTFSnowQueen)this.attacker).getCurrentPhase() != EntityTFSnowQueen.Phase.BEAM) {
            return false;
        }
        if (this.seekTimer >= this.maxSeekTime) {
            return false;
        }
        return this.beamTimer < this.maxBeamTime;
    }

    public void func_75251_c() {
        this.seekTimer = 0;
        this.hoverTimer = 0;
        this.beamTimer = 0;
        this.isInPosition = false;
        ((EntityTFSnowQueen)this.attacker).setBreathing(false);
    }

    public void func_75246_d() {
        EntityLivingBase target;
        if (((EntityTFSnowQueen)this.attacker).func_70092_e(this.hoverPosX, this.hoverPosY, this.hoverPosZ) <= 1.0) {
            this.isInPosition = true;
        }
        if (this.isInPosition) {
            ++this.hoverTimer;
        } else {
            ++this.seekTimer;
        }
        if (this.hoverTimer >= this.maxHoverTime) {
            ++this.beamTimer;
            ((EntityTFSnowQueen)this.attacker).setBreathing(true);
            this.doRayAttack();
            this.hoverPosY -= (double)0.05f;
            if (this.hoverPosY < this.beamY) {
                this.hoverPosY = this.beamY;
            }
        }
        double offsetX = this.hoverPosX - ((EntityTFSnowQueen)this.attacker).field_70165_t;
        double offsetY = this.hoverPosY - ((EntityTFSnowQueen)this.attacker).field_70163_u;
        double offsetZ = this.hoverPosZ - ((EntityTFSnowQueen)this.attacker).field_70161_v;
        double distanceDesired = offsetX * offsetX + offsetY * offsetY + offsetZ * offsetZ;
        if ((distanceDesired = (double)MathHelper.func_76133_a((double)distanceDesired)) > 0.5) {
            double velX = offsetX / distanceDesired * 0.05;
            double velY = offsetY / distanceDesired * 0.1;
            double velZ = offsetZ / distanceDesired * 0.05;
            ((EntityTFSnowQueen)this.attacker).func_70024_g(velX, velY += (double)0.02f, velZ);
        }
        if ((target = ((EntityTFSnowQueen)this.attacker).func_70638_az()) != null) {
            float tracking = this.isInPosition ? 1.0f : 20.0f;
            ((EntityTFSnowQueen)this.attacker).func_70625_a((Entity)target, tracking, tracking);
            ((EntityTFSnowQueen)this.attacker).func_70671_ap().func_75651_a((Entity)target, tracking, tracking);
        }
    }

    private void doRayAttack() {
        double range = 20.0;
        double offset = 10.0;
        Vec3d srcVec = new Vec3d(((EntityTFSnowQueen)this.attacker).field_70165_t, ((EntityTFSnowQueen)this.attacker).field_70163_u + 0.25, ((EntityTFSnowQueen)this.attacker).field_70161_v);
        Vec3d lookVec = ((EntityTFSnowQueen)this.attacker).func_70676_i(1.0f);
        Vec3d destVec = srcVec.func_72441_c(lookVec.field_72450_a * range, lookVec.field_72448_b * range, lookVec.field_72449_c * range);
        List possibleList = ((EntityTFSnowQueen)this.attacker).field_70170_p.func_72839_b((Entity)this.attacker, ((EntityTFSnowQueen)this.attacker).func_174813_aQ().func_72317_d(lookVec.field_72450_a * offset, lookVec.field_72448_b * offset, lookVec.field_72449_c * offset).func_72314_b(range, range, range));
        double hitDist = 0.0;
        for (Entity possibleEntity : possibleList) {
            double possibleDist;
            if (!possibleEntity.func_70067_L() || possibleEntity == this.attacker) continue;
            float borderSize = possibleEntity.func_70111_Y();
            AxisAlignedBB collisionBB = possibleEntity.func_174813_aQ().func_72314_b((double)borderSize, (double)borderSize, (double)borderSize);
            RayTraceResult interceptPos = collisionBB.func_72327_a(srcVec, destVec);
            if (collisionBB.func_72318_a(srcVec)) {
                if (!(0.0 < hitDist) && hitDist != 0.0) continue;
                ((EntityTFSnowQueen)this.attacker).doBreathAttack(possibleEntity);
                hitDist = 0.0;
                continue;
            }
            if (interceptPos == null || !((possibleDist = srcVec.func_72438_d(interceptPos.field_72307_f)) < hitDist) && hitDist != 0.0) continue;
            ((EntityTFSnowQueen)this.attacker).doBreathAttack(possibleEntity);
            hitDist = possibleDist;
        }
    }

    @Override
    protected void makeNewHoverSpot(EntityLivingBase target) {
        super.makeNewHoverSpot(target);
        this.beamY = target.field_70163_u;
        this.seekTimer = 0;
    }
}

