/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.compat.forestry;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IAlleleBeeSpeciesBuilder;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesType;
import forestry.apiculture.genetics.Bee;
import forestry.apiculture.genetics.IBeeDefinition;
import forestry.core.genetics.IBranchDefinition;
import forestry.core.genetics.alleles.AlleleHelper;
import java.util.Locale;
import net.minecraft.item.ItemStack;
import twilightforest.compat.forestry.BeeBranchRegister;

public enum BeeRegister implements IBeeDefinition
{
    TWILIT(BeeBranchRegister.TWILIGHT, "Crepusculum"),
    ENSORCELIZED(BeeBranchRegister.TWILIGHT, "Carminibus"),
    MIRY(BeeBranchRegister.SWAMP, "Paluster"),
    OMINOUS(BeeBranchRegister.DARK_FOREST, "Minaces"),
    FRIGID(BeeBranchRegister.SNOWY_FOREST, "Frigidus"),
    DRAINED(BeeBranchRegister.HIGHLANDS, "Adficio"),
    CONFUSED(BeeBranchRegister.TWILIGHT, "Confusus"),
    ENLIGHTENED(BeeBranchRegister.TWILIGHT, "Cultus"),
    HERBAL(BeeBranchRegister.TWILIGHT, "Herba"),
    TREE(BeeBranchRegister.TWILIGHT, "Arboreal"),
    DRUIDIC(BeeBranchRegister.TWILIGHT, "Druidae"),
    RHYTHMIC(BeeBranchRegister.TWILIGHT, "Tempus"),
    TRANSFIGURATIVE(BeeBranchRegister.TWILIGHT, "Transformato"),
    EXCAVATOR(BeeBranchRegister.TWILIGHT, "Tergeo"),
    CATEGORICAL(BeeBranchRegister.TWILIGHT, "Catalogus"),
    ENTANGLED(BeeBranchRegister.SWAMP, "Capti"),
    LABYRINTHINE(BeeBranchRegister.SWAMP, "Labyrinthus"),
    MISTY(BeeBranchRegister.DARK_FOREST, "Caliginosus"),
    PIERCING(BeeBranchRegister.DARK_FOREST, "Penetralis"),
    FROZEN(BeeBranchRegister.SNOWY_FOREST, "Glacialis"),
    GELID(BeeBranchRegister.SNOWY_FOREST, "Gelida"),
    ANIMATED(BeeBranchRegister.HIGHLANDS, "Vividus"),
    SENTINEL(BeeBranchRegister.HIGHLANDS, "Excubitor"),
    MYTHOLOGICAL(BeeBranchRegister.TWILIGHT, "Fabulares"),
    ENTROPHIED(BeeBranchRegister.TWILIGHT, "Champion"),
    SHEEPISH(BeeBranchRegister.TWILIGHT, "Modestus"),
    SERPENTINE(BeeBranchRegister.TWILIGHT, "Anguis"),
    NECROMANTIC(BeeBranchRegister.TWILIGHT, "Necromantiae"),
    MINOTAUR(BeeBranchRegister.SWAMP, "Minotaurus"),
    DUPLICATIVE(BeeBranchRegister.SWAMP, "Capitibus"),
    PHANTASMAGORICAL(BeeBranchRegister.DARK_FOREST, "Inconcilio"),
    CARMINIATED(BeeBranchRegister.DARK_FOREST, "Vis"),
    CRYPTID(BeeBranchRegister.SNOWY_FOREST, "Creatura"),
    MONARCHICAL(BeeBranchRegister.SNOWY_FOREST, "Monarchica"),
    ONTOMANTIC(BeeBranchRegister.HIGHLANDS, "Rego");

    private final IBranchDefinition branch;
    private final IAlleleBeeSpecies species;
    private IAllele[] template;
    private IBeeGenome genome;

    private BeeRegister(IBranchDefinition branch, String species) {
        this.branch = branch;
        String lowerCase = this.toString().toLowerCase(Locale.ROOT);
        IAlleleBeeSpeciesBuilder speciesBuilder = BeeManager.beeFactory.createSpecies("twilightforest", "twilightforest:" + lowerCase, true, "Drullkus", "twilightforest.bee." + lowerCase, "twilightforest.bee." + lowerCase + ".desc", branch.getBranch(), species.toLowerCase(Locale.ROOT), 0xFFFFFF, 0xFFFFFF);
        this.setSpeciesProperties(speciesBuilder);
        this.species = speciesBuilder.build();
        this.template = this.branch.getTemplate();
        AlleleHelper.getInstance().set(this.template, (Enum)EnumBeeChromosome.SPECIES, (IAllele)this.species);
        this.setAlleles(this.template);
        this.genome = BeeManager.beeRoot.templateAsGenome(this.template);
        BeeManager.beeRoot.registerTemplate(this.template);
    }

    public IAllele[] getTemplate() {
        IAllele[] copiedAlleles = new IAllele[this.template.length];
        System.arraycopy(this.template, 0, copiedAlleles, 0, this.template.length);
        return copiedAlleles;
    }

    public final IBeeGenome getGenome() {
        return this.genome;
    }

    public final IBee getIndividual() {
        return new Bee(this.genome);
    }

    public ItemStack getMemberStack(EnumBeeType enumBeeType) {
        IBee bee = this.getIndividual();
        return BeeManager.beeRoot.getMemberStack((IIndividual)bee, (ISpeciesType)enumBeeType);
    }

    private void setSpeciesProperties(IAlleleBeeSpeciesBuilder speciesProperties) {
    }

    private void setAlleles(IAllele[] alleles) {
    }
}

