/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.EnumPlantType;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import twilightforest.block.TFBlocks;
import twilightforest.client.ModelRegisterCallback;
import twilightforest.client.particle.TFParticleFactory;
import twilightforest.client.particle.TFParticleType;
import twilightforest.enums.PlantVariant;
import twilightforest.item.TFItems;

public class BlockTFPlant
extends BlockBush
implements IShearable,
ModelRegisterCallback {
    public static final IProperty<PlantVariant> VARIANT = PropertyEnum.func_177709_a((String)"variant", PlantVariant.class);

    protected BlockTFPlant() {
        super(Material.field_151585_k);
        this.func_149675_a(true);
        this.func_149711_c(0.0f);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149647_a(TFItems.creativeTab);
    }

    public BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
    }

    @Deprecated
    public IBlockState func_176203_a(int meta) {
        PlantVariant variant = PlantVariant.values()[MathHelper.func_76125_a((int)meta, (int)0, (int)PlantVariant.values().length)];
        return this.func_176223_P().func_177226_a(VARIANT, (Comparable)((Object)variant));
    }

    public int func_176201_c(IBlockState state) {
        return ((PlantVariant)((Object)state.func_177229_b(VARIANT))).ordinal();
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        world.func_175684_a(pos, (Block)this, world.field_73012_v.nextInt(50) + 20);
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        return (state.func_177230_c().isAir(state, (IBlockAccess)world, pos) || state.func_185904_a().func_76222_j()) && this.func_180671_f(world, pos, state);
    }

    public boolean func_180671_f(World world, BlockPos pos, IBlockState state) {
        IBlockState soil = world.func_180495_p(pos.func_177977_b());
        if (state.func_177230_c() != this) {
            return BlockTFPlant.canPlaceRootAt(world, pos) || soil.func_177230_c().canSustainPlant(soil, (IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP, (IPlantable)this) || soil.isSideSolid((IBlockAccess)world, pos, EnumFacing.UP) || (world.func_175699_k(pos) >= 3 || world.func_175678_i(pos)) && soil.func_177230_c().canSustainPlant(soil, (IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP, (IPlantable)this);
        }
        switch ((PlantVariant)((Object)state.func_177229_b(VARIANT))) {
            case TORCHBERRY: 
            case ROOT_STRAND: {
                return BlockTFPlant.canPlaceRootAt(world, pos);
            }
            case FORESTGRASS: 
            case DEADBUSH: {
                return soil.func_177230_c().canSustainPlant(soil, (IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP, (IPlantable)this);
            }
            case FALLEN_LEAVES: 
            case MUSHGLOOM: 
            case MOSSPATCH: {
                return soil.isSideSolid((IBlockAccess)world, pos, EnumFacing.UP);
            }
        }
        return (world.func_175699_k(pos) >= 3 || world.func_175678_i(pos)) && soil.func_177230_c().canSustainPlant(soil, (IBlockAccess)world, pos.func_177977_b(), EnumFacing.UP, (IPlantable)this);
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess access, BlockPos pos) {
        PlantVariant variant = (PlantVariant)((Object)state.func_177229_b(VARIANT));
        long seed = (long)(pos.func_177958_n() * 3129871) ^ (long)pos.func_177956_o() * 116129781L ^ (long)pos.func_177952_p();
        seed = seed * seed * 42317861L + seed * 11L;
        if (variant == PlantVariant.MOSSPATCH) {
            int xOff0 = (int)(seed >> 12 & 3L);
            int xOff1 = (int)(seed >> 15 & 3L);
            int zOff0 = (int)(seed >> 18 & 3L);
            int zOff1 = (int)(seed >> 21 & 3L);
            boolean xConnect0 = access.func_180495_p(pos.func_177974_f()).func_177230_c() == this && access.func_180495_p(pos.func_177974_f()).func_177229_b(VARIANT) == PlantVariant.MOSSPATCH;
            boolean xConnect1 = access.func_180495_p(pos.func_177976_e()).func_177230_c() == this && access.func_180495_p(pos.func_177976_e()).func_177229_b(VARIANT) == PlantVariant.MOSSPATCH;
            boolean zConnect0 = access.func_180495_p(pos.func_177968_d()).func_177230_c() == this && access.func_180495_p(pos.func_177968_d()).func_177229_b(VARIANT) == PlantVariant.MOSSPATCH;
            boolean zConnect1 = access.func_180495_p(pos.func_177978_c()).func_177230_c() == this && access.func_180495_p(pos.func_177978_c()).func_177229_b(VARIANT) == PlantVariant.MOSSPATCH;
            return new AxisAlignedBB(xConnect1 ? 0.0 : (double)((1.0f + (float)xOff1) / 16.0f), 0.0, zConnect1 ? 0.0 : (double)((1.0f + (float)zOff1) / 16.0f), xConnect0 ? 1.0 : (double)((15.0f - (float)xOff0) / 16.0f), 0.0625, zConnect0 ? 1.0 : (double)((15.0f - (float)zOff0) / 16.0f));
        }
        if (variant == PlantVariant.CLOVERPATCH) {
            int xOff0 = (int)(seed >> 12 & 3L);
            int xOff1 = (int)(seed >> 15 & 3L);
            int zOff0 = (int)(seed >> 18 & 3L);
            int zOff1 = (int)(seed >> 21 & 3L);
            int yOff0 = (int)(seed >> 24 & 1L);
            int yOff1 = (int)(seed >> 27 & 1L);
            boolean xConnect0 = access.func_180495_p(pos.func_177974_f()).func_177230_c() == this && access.func_180495_p(pos.func_177974_f()).func_177229_b(VARIANT) == PlantVariant.CLOVERPATCH;
            boolean xConnect1 = access.func_180495_p(pos.func_177976_e()).func_177230_c() == this && access.func_180495_p(pos.func_177976_e()).func_177229_b(VARIANT) == PlantVariant.CLOVERPATCH;
            boolean zConnect0 = access.func_180495_p(pos.func_177968_d()).func_177230_c() == this && access.func_180495_p(pos.func_177968_d()).func_177229_b(VARIANT) == PlantVariant.CLOVERPATCH;
            boolean zConnect1 = access.func_180495_p(pos.func_177978_c()).func_177230_c() == this && access.func_180495_p(pos.func_177978_c()).func_177229_b(VARIANT) == PlantVariant.CLOVERPATCH;
            return new AxisAlignedBB(xConnect1 ? 0.0 : (double)((1.0f + (float)xOff1) / 16.0f), 0.0, zConnect1 ? 0.0 : (double)((1.0f + (float)zOff1) / 16.0f), xConnect0 ? 1.0 : (double)((15.0f - (float)xOff0) / 16.0f), (double)((1.0f + (float)yOff0 + (float)yOff1) / 16.0f), zConnect0 ? 1.0 : (double)((15.0f - (float)zOff0) / 16.0f));
        }
        if (variant == PlantVariant.MAYAPPLE) {
            return new AxisAlignedBB(0.25, 0.0, 0.25, 0.8125, 0.375, 0.8125);
        }
        if (variant == PlantVariant.FALLEN_LEAVES) {
            return new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.0625, 1.0);
        }
        return field_185505_j;
    }

    public AxisAlignedBB func_180646_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return field_185506_k;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public int func_149750_m(IBlockState state) {
        switch ((PlantVariant)((Object)state.func_177229_b(VARIANT))) {
            case MUSHGLOOM: {
                return 3;
            }
            case TORCHBERRY: {
                return 8;
            }
        }
        return 0;
    }

    public static boolean canPlaceRootAt(World world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos.func_177984_a());
        if (state.func_185904_a() == Material.field_151578_c || state.func_185904_a() == Material.field_151577_b) {
            return true;
        }
        return state.func_177230_c() == TFBlocks.twilight_plant && state.func_177229_b(VARIANT) == PlantVariant.ROOT_STRAND || state == TFBlocks.root.func_176223_P();
    }

    public Block.EnumOffsetType func_176218_Q() {
        return Block.EnumOffsetType.NONE;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        NonNullList ret = NonNullList.func_191196_a();
        switch ((PlantVariant)((Object)state.func_177229_b(VARIANT))) {
            case TORCHBERRY: {
                ret.add(new ItemStack(TFItems.torchberries));
                break;
            }
            case ROOT_STRAND: 
            case FORESTGRASS: 
            case DEADBUSH: 
            case FALLEN_LEAVES: 
            case MOSSPATCH: 
            case MAYAPPLE: 
            case CLOVERPATCH: 
            case FIDDLEHEAD: {
                break;
            }
            default: {
                ret.add(new ItemStack((Block)this, 1, this.func_180651_a(state)));
            }
        }
        return ret;
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, BlockPos pos) {
        return true;
    }

    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        NonNullList ret = NonNullList.func_191196_a();
        ret.add(new ItemStack((Block)this, 1, this.func_180651_a(world.func_180495_p(pos))));
        return ret;
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, ItemStack stack) {
        if (world.field_72995_K || stack.func_77973_b() != Items.field_151097_aZ) {
            super.func_180657_a(world, player, pos, state, te, stack);
        }
    }

    public void func_149666_a(CreativeTabs creativeTab, NonNullList<ItemStack> list) {
        int n = PlantVariant.values().length;
        for (int i = 0; i < n; ++i) {
            list.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    public EnumPlantType getPlantType(IBlockAccess world, BlockPos pos) {
        IBlockState blockState = world.func_180495_p(pos);
        if (blockState.func_177230_c() == this) {
            switch ((PlantVariant)((Object)blockState.func_177229_b(VARIANT))) {
                case MUSHGLOOM: 
                case MOSSPATCH: {
                    return EnumPlantType.Cave;
                }
            }
            return EnumPlantType.Plains;
        }
        return EnumPlantType.Plains;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random random) {
        super.func_180655_c(state, world, pos, random);
        if (state.func_177229_b(VARIANT) == PlantVariant.MOSSPATCH && random.nextInt(10) == 0) {
            world.func_175688_a(EnumParticleTypes.TOWN_AURA, (double)((float)pos.func_177958_n() + random.nextFloat()), (double)((float)pos.func_177956_o() + 0.1f), (double)((float)pos.func_177952_p() + random.nextFloat()), 0.0, 0.0, 0.0, new int[0]);
        } else if (state.func_177229_b(VARIANT) == PlantVariant.FALLEN_LEAVES && random.nextInt(50) == 0) {
            float dist = 10.0f;
            if (!world.func_175678_i(pos)) {
                int y = 0;
                while ((float)y <= dist) {
                    if (world.func_180495_p(pos.func_177981_b(y)).func_185904_a() == Material.field_151584_j) {
                        dist = y;
                        break;
                    }
                    ++y;
                }
                if (dist > 10.0f) {
                    return;
                }
            }
            Particle leaf = TFParticleFactory.createParticle(TFParticleType.FALLEN_LEAF, world, (float)pos.func_177958_n() + random.nextFloat(), (float)pos.func_177956_o() + dist - 0.25f, (float)pos.func_177952_p() + random.nextFloat(), 0.0, 0.0, 0.0);
            int color = Minecraft.func_71410_x().func_184125_al().func_186724_a(Blocks.field_150362_t.func_176223_P(), (IBlockAccess)world, pos, 0);
            leaf.func_70538_b((float)MathHelper.func_76125_a((int)((color >> 16 & 0xFF) + RANDOM.nextInt(34) - 17), (int)0, (int)255) / 255.0f, (float)MathHelper.func_76125_a((int)((color >> 8 & 0xFF) + RANDOM.nextInt(34) - 17), (int)0, (int)255) / 255.0f, (float)MathHelper.func_76125_a((int)((color & 0xFF) + RANDOM.nextInt(34) - 17), (int)0, (int)255) / 255.0f);
            Minecraft.func_71410_x().field_71452_i.func_78873_a(leaf);
        }
    }

    public void func_180634_a(World world, BlockPos pos, IBlockState state, Entity entityIn) {
        super.func_180634_a(world, pos, state, entityIn);
        if (world.field_72995_K && state.func_177229_b(VARIANT) == PlantVariant.FALLEN_LEAVES && entityIn instanceof EntityLivingBase && (entityIn.field_70159_w != 0.0 || entityIn.field_70179_y != 0.0) && RANDOM.nextBoolean()) {
            int color = Minecraft.func_71410_x().func_184125_al().func_186724_a(Blocks.field_150362_t.func_176223_P(), (IBlockAccess)world, pos, 0);
            Particle leaf = TFParticleFactory.createParticle(TFParticleType.FALLEN_LEAF, world, (float)pos.func_177958_n() + world.field_73012_v.nextFloat(), pos.func_177956_o(), (float)pos.func_177952_p() + world.field_73012_v.nextFloat(), (double)(world.field_73012_v.nextFloat() * -0.5f) * entityIn.field_70159_w, world.field_73012_v.nextFloat() * 0.5f + 0.25f, (double)(world.field_73012_v.nextFloat() * -0.5f) * entityIn.field_70179_y);
            leaf.func_70538_b((float)MathHelper.func_76125_a((int)((color >> 16 & 0xFF) + RANDOM.nextInt(34) - 17), (int)0, (int)255) / 255.0f, (float)MathHelper.func_76125_a((int)((color >> 8 & 0xFF) + RANDOM.nextInt(34) - 17), (int)0, (int)255) / 255.0f, (float)MathHelper.func_76125_a((int)((color & 0xFF) + RANDOM.nextInt(34) - 17), (int)0, (int)255) / 255.0f);
            Minecraft.func_71410_x().field_71452_i.func_78873_a(leaf);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel() {
        for (int i = 0; i < PlantVariant.values().length; ++i) {
            String variant = "inventory_" + PlantVariant.values()[i].func_176610_l();
            ModelResourceLocation mrl = new ModelResourceLocation(this.getRegistryName(), variant);
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)i, (ModelResourceLocation)mrl);
        }
    }

    public IBlockState getExtendedState(IBlockState state, IBlockAccess world, BlockPos pos) {
        return super.getExtendedState(state, world, pos);
    }
}

