/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.init.Items;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import twilightforest.block.BlockTFConnectableRotatedPillar;
import twilightforest.client.ModelRegisterCallback;
import twilightforest.item.TFItems;

public class BlockTFForceField
extends BlockTFConnectableRotatedPillar
implements ModelRegisterCallback {
    public static final List<EnumDyeColor> VALID_COLORS = ImmutableList.of((Object)EnumDyeColor.PURPLE, (Object)EnumDyeColor.PINK, (Object)EnumDyeColor.ORANGE, (Object)EnumDyeColor.GREEN, (Object)EnumDyeColor.BLUE);
    public static final IProperty<EnumDyeColor> COLOR = PropertyEnum.func_177707_a((String)"color", EnumDyeColor.class, VALID_COLORS);

    BlockTFForceField() {
        super(Material.field_175972_I, 2.0);
        this.func_149722_s();
        this.func_149752_b(Float.MAX_VALUE);
        this.func_149715_a(0.13333334f);
        this.func_149647_a(TFItems.creativeTab);
        this.func_180632_j(this.func_176223_P().func_177226_a(COLOR, (Comparable)EnumDyeColor.PURPLE));
    }

    public int func_176201_c(IBlockState state) {
        return VALID_COLORS.indexOf(state.func_177229_b(COLOR)) + (((EnumFacing.Axis)state.func_177229_b((IProperty)field_176298_M)).ordinal() + 1) % 3 * 5;
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(COLOR, (Comparable)VALID_COLORS.get(meta % 5)).func_177226_a((IProperty)field_176298_M, (Comparable)EnumFacing.Axis.values()[(meta / 5 + 1) % 3]);
    }

    @Override
    protected IProperty[] getAdditionalProperties() {
        return new IProperty[]{COLOR};
    }

    @Override
    protected AxisAlignedBB getSidedAABBStraight(EnumFacing facing, EnumFacing.Axis axis) {
        return this.makeQuickAABB(facing == EnumFacing.EAST || axis == EnumFacing.Axis.X ? 16.0 : this.boundingBoxWidthLower, facing == EnumFacing.UP || axis == EnumFacing.Axis.Y ? 16.0 : this.boundingBoxWidthLower, facing == EnumFacing.SOUTH || axis == EnumFacing.Axis.Z ? 16.0 : this.boundingBoxWidthLower, facing == EnumFacing.WEST || axis == EnumFacing.Axis.X ? 0.0 : this.boundingBoxWidthUpper, facing == EnumFacing.DOWN || axis == EnumFacing.Axis.Y ? 0.0 : this.boundingBoxWidthUpper, facing == EnumFacing.NORTH || axis == EnumFacing.Axis.Z ? 0.0 : this.boundingBoxWidthUpper);
    }

    @Override
    protected boolean canConnectTo(IBlockState state, IBlockState otherState, IBlockAccess world, BlockPos pos, EnumFacing connectTo) {
        BlockFaceShape blockFaceShape = otherState.func_193401_d(world, pos, connectTo);
        return blockFaceShape == BlockFaceShape.SOLID || blockFaceShape == BlockFaceShape.MIDDLE_POLE_THIN || super.canConnectTo(state, otherState, world, pos, connectTo);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Items.field_190931_a;
    }

    public void func_149666_a(CreativeTabs creativeTab, NonNullList<ItemStack> list) {
        for (int i = 0; i < COLOR.func_177700_c().size(); ++i) {
            list.add((Object)new ItemStack((Block)this, 1, i));
        }
    }

    @Override
    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    @Override
    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess world, IBlockState state, BlockPos pos, EnumFacing face) {
        return face.func_176740_k() != state.func_177229_b((IProperty)field_176298_M) ? BlockFaceShape.MIDDLE_POLE_THIN : BlockFaceShape.CENTER_SMALL;
    }

    public int func_180651_a(IBlockState state) {
        return VALID_COLORS.indexOf(state.func_177229_b(COLOR));
    }

    public boolean canEntityDestroy(IBlockState state, IBlockAccess world, BlockPos pos, Entity entity) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.TRANSLUCENT;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return blockAccess.func_180495_p(pos.func_177972_a(side)).func_177230_c() != this && super.func_176225_a(blockState, blockAccess, pos, side);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel() {
        ModelResourceLocation mrl = new ModelResourceLocation(this.getRegistryName(), "inventory");
        for (int i = 0; i < VALID_COLORS.size(); ++i) {
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)i, (ModelResourceLocation)mrl);
        }
    }
}

