/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.modules.workers;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.World;
import vswe.stevescarts.containers.slots.SlotBase;
import vswe.stevescarts.containers.slots.SlotTorch;
import vswe.stevescarts.entitys.EntityMinecartModular;
import vswe.stevescarts.guis.GuiMinecart;
import vswe.stevescarts.helpers.ResourceHelper;
import vswe.stevescarts.modules.ISuppliesModule;
import vswe.stevescarts.modules.workers.ModuleWorker;

public class ModuleTorch
extends ModuleWorker
implements ISuppliesModule {
    private int light;
    private int lightLimit = 8;
    private int[] boxRect = new int[]{12, this.guiHeight() - 10, 46, 9};
    boolean markerMoving = false;
    private DataParameter<Integer> TORCHES;

    public ModuleTorch(EntityMinecartModular cart) {
        super(cart);
    }

    @Override
    public boolean hasGui() {
        return true;
    }

    @Override
    public int guiWidth() {
        return 80;
    }

    @Override
    protected SlotBase getSlot(int slotId, int x, int y) {
        return new SlotTorch(this.getCart(), slotId, 8 + x * 18, 23 + y * 18);
    }

    @Override
    public void drawForeground(GuiMinecart gui) {
        this.drawString(gui, this.getModuleName(), 8, 6, 0x404040);
    }

    @Override
    public byte getWorkPriority() {
        return 95;
    }

    @Override
    public boolean work() {
        BlockPos next = this.getLastblock();
        EntityMinecartModular cart = this.getCart();
        World world = cart.field_70170_p;
        int x = next.func_177958_n();
        int y = next.func_177956_o();
        int z = next.func_177952_p();
        int cartX = cart.x();
        int cartZ = cart.z();
        if (this.light <= this.lightLimit) {
            block0: for (int side = -1; side <= 1; side += 2) {
                int xTorch = x + (cartZ != z ? side : 0);
                int zTorch = z + (cartX != x ? side : 0);
                for (int level = 2; level >= -2; --level) {
                    BlockPos pos = new BlockPos(xTorch, y + level, zTorch);
                    if (world.func_175623_d(pos) && Blocks.field_150478_aa.func_176196_c(world, pos)) {
                        for (int i = 0; i < this.getInventorySize(); ++i) {
                            if (this.getStack(i).func_190926_b() || Block.func_149634_a((Item)this.getStack(i).func_77973_b()) != Blocks.field_150478_aa) continue;
                            if (this.doPreWork()) {
                                this.startWorking(3);
                                return true;
                            }
                            IBlockState state = Blocks.field_150478_aa.getStateForPlacement(world, pos, EnumFacing.DOWN, 0.0f, 0.0f, 0.0f, 0, (EntityLivingBase)this.getFakePlayer(), EnumHand.MAIN_HAND);
                            world.func_175656_a(new BlockPos(xTorch, y + level, zTorch), state);
                            if (cart.hasCreativeSupplies()) continue block0;
                            ItemStack stack = this.getStack(i);
                            stack.func_190918_g(1);
                            if (this.getStack(i).func_190916_E() == 0) {
                                this.setStack(i, ItemStack.field_190927_a);
                            }
                            this.onInventoryChanged();
                            continue block0;
                        }
                        continue block0;
                    }
                    if (world.func_180495_p(pos).func_177230_c() == Blocks.field_150478_aa) continue block0;
                }
            }
        }
        this.stopWorking();
        return false;
    }

    @Override
    public void drawBackground(GuiMinecart gui, int x, int y) {
        ResourceHelper.bindResource("/gui/torch.png");
        int barLength = 3 * this.light;
        if (this.light == 15) {
            --barLength;
        }
        int srcX = 0;
        if (this.inRect(x, y, this.boxRect)) {
            srcX += this.boxRect[2];
        }
        this.drawImage(gui, this.boxRect, srcX, 0);
        this.drawImage(gui, 13, this.guiHeight() - 10 + 1, 0, 9, barLength, 7);
        this.drawImage(gui, 12 + 3 * this.lightLimit, this.guiHeight() - 10, 0, 16, 1, 9);
    }

    @Override
    public void drawMouseOver(GuiMinecart gui, int x, int y) {
        this.drawStringOnMouseOver(gui, "Threshold: " + this.lightLimit + " Current: " + this.light, x, y, this.boxRect);
    }

    @Override
    public int guiHeight() {
        return super.guiHeight() + 10;
    }

    @Override
    public int numberOfGuiData() {
        return 2;
    }

    @Override
    protected void checkGuiData(Object[] info) {
        short data = (short)(this.light & 0xF);
        data = (short)(data | (short)((this.lightLimit & 0xF) << 4));
        this.updateGuiData(info, 0, data);
    }

    @Override
    public void receiveGuiData(int id, short data) {
        if (id == 0) {
            this.light = data & 0xF;
            this.lightLimit = (data & 0xF0) >> 4;
        }
    }

    @Override
    public int numberOfPackets() {
        return 1;
    }

    @Override
    protected void receivePacket(int id, byte[] data, EntityPlayer player) {
        if (id == 0) {
            this.lightLimit = data[0];
            if (this.lightLimit < 0) {
                this.lightLimit = 0;
            } else if (this.lightLimit > 15) {
                this.lightLimit = 15;
            }
        }
    }

    @Override
    public void mouseClicked(GuiMinecart gui, int x, int y, int button) {
        if (button == 0 && this.inRect(x, y, this.boxRect)) {
            this.generatePacket(x, y);
            this.markerMoving = true;
        }
    }

    @Override
    public void mouseMovedOrUp(GuiMinecart gui, int x, int y, int button) {
        if (this.markerMoving) {
            this.generatePacket(x, y);
        }
        if (button != -1) {
            this.markerMoving = false;
        }
    }

    private void generatePacket(int x, int y) {
        int xInBox = x - this.boxRect[0];
        int val = xInBox / 3;
        if (val < 0) {
            val = 0;
        } else if (val > 15) {
            val = 15;
        }
        this.sendPacket(0, (byte)val);
    }

    public void setThreshold(byte val) {
        this.lightLimit = val;
    }

    public int getThreshold() {
        return this.lightLimit;
    }

    public int getLightLevel() {
        return this.light;
    }

    @Override
    public void update() {
        super.update();
        this.light = this.getCart().field_70170_p.func_175642_b(EnumSkyBlock.BLOCK, new BlockPos(this.getCart().x(), this.getCart().y() + 1, this.getCart().z()));
    }

    @Override
    public void initDw() {
        this.TORCHES = this.createDw(DataSerializers.field_187192_b);
        this.registerDw(this.TORCHES, 0);
    }

    @Override
    public int numberOfDataWatchers() {
        return 1;
    }

    @Override
    public void onInventoryChanged() {
        super.onInventoryChanged();
        this.calculateTorches();
    }

    private void calculateTorches() {
        if (this.getCart().field_70170_p.field_72995_K) {
            return;
        }
        int val = 0;
        for (int i = 0; i < 3; ++i) {
            val |= (!this.getStack(i).func_190926_b() ? 1 : 0) << i;
        }
        this.updateDw(this.TORCHES, val);
    }

    public int getTorches() {
        if (this.isPlaceholder()) {
            return this.getSimInfo().getTorchInfo();
        }
        return this.getDw(this.TORCHES);
    }

    @Override
    protected void Save(NBTTagCompound tagCompound, int id) {
        tagCompound.func_74774_a(this.generateNBTName("lightLimit", id), (byte)this.lightLimit);
    }

    @Override
    protected void Load(NBTTagCompound tagCompound, int id) {
        this.lightLimit = tagCompound.func_74771_c(this.generateNBTName("lightLimit", id));
        this.calculateTorches();
    }

    @Override
    public boolean haveSupplies() {
        for (int i = 0; i < this.getInventorySize(); ++i) {
            ItemStack item = this.getStack(i);
            if (item == null || Block.func_149634_a((Item)item.func_77973_b()) != Blocks.field_150478_aa) continue;
            return true;
        }
        return false;
    }
}

