/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.models;

import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.renderer.entity.Render;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vswe.stevescarts.helpers.ResourceHelper;
import vswe.stevescarts.models.ModelCartbase;
import vswe.stevescarts.modules.ModuleBase;
import vswe.stevescarts.modules.addons.ModuleShield;

@SideOnly(value=Side.CLIENT)
public class ModelShield
extends ModelCartbase {
    private static ResourceLocation texture = ResourceHelper.getResource("/models/shieldModel.png");
    private ModelRenderer[][] shieldAnchors;
    private ModelRenderer[][] shields = new ModelRenderer[4][5];

    @Override
    public ResourceLocation getResource(ModuleBase module) {
        return texture;
    }

    @Override
    protected int getTextureWidth() {
        return 8;
    }

    @Override
    protected int getTextureHeight() {
        return 4;
    }

    public ModelShield() {
        this.shieldAnchors = new ModelRenderer[this.shields.length][this.shields[0].length];
        for (int i = 0; i < this.shields.length; ++i) {
            for (int j = 0; j < this.shields[i].length; ++j) {
                ModelRenderer modelRenderer = new ModelRenderer((ModelBase)this);
                this.shieldAnchors[i][j] = modelRenderer;
                this.AddRenderer(modelRenderer);
                ModelRenderer modelRenderer2 = new ModelRenderer((ModelBase)this, 0, 0);
                this.shields[i][j] = modelRenderer2;
                this.fixSize(modelRenderer2);
                this.shieldAnchors[i][j].func_78792_a(this.shields[i][j]);
                this.shields[i][j].func_78790_a(-1.0f, -1.0f, -1.0f, 2, 2, 2, 0.0f);
                this.shields[i][j].func_78793_a(0.0f, 0.0f, 0.0f);
            }
        }
    }

    @Override
    public void render(Render render, ModuleBase module, float yaw, float pitch, float roll, float mult, float partialtime) {
        if (render == null || module == null || ((ModuleShield)module).hasShield()) {
            super.render(render, module, yaw, pitch, roll, mult, partialtime);
        }
    }

    @Override
    public void applyEffects(ModuleBase module, float yaw, float pitch, float roll) {
        float shieldAngle = module == null ? 0.0f : ((ModuleShield)module).getShieldAngle();
        float shieldDistance = module == null ? 18.0f : ((ModuleShield)module).getShieldDistance();
        for (int i = 0; i < this.shields.length; ++i) {
            for (int j = 0; j < this.shields[i].length; ++j) {
                float a = shieldAngle + (float)Math.PI * 2 * ((float)j / (float)this.shields[i].length + (float)i / (float)this.shields.length);
                this.shieldAnchors[i][j].field_78796_g = a = (float)((double)a % 314.1592653589793);
                this.shields[i][j].field_78797_d = ((float)Math.sin(a / 5.0f) * 3.0f + ((float)i - (float)(this.shields.length - 1) / 2.0f) * 5.0f - 5.0f) * shieldDistance / 18.0f;
                this.shields[i][j].field_78798_e = shieldDistance;
            }
        }
    }
}

