/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.helpers;

import net.minecraft.util.EnumFacing;
import vswe.stevescarts.blocks.tileentities.TileEntityDistributor;
import vswe.stevescarts.helpers.DistributorSetting;
import vswe.stevescarts.helpers.Localization;

public class DistributorSide {
    private int id;
    private Localization.GUI.DISTRIBUTOR name;
    private EnumFacing side;
    private int data;

    public DistributorSide(int id, Localization.GUI.DISTRIBUTOR name, EnumFacing side) {
        this.name = name;
        this.id = id;
        this.side = side;
        this.data = 0;
    }

    public void setData(int data) {
        this.data = data;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name.translate(new String[0]);
    }

    public EnumFacing getSide() {
        return this.side;
    }

    public EnumFacing getFacing() {
        return this.side;
    }

    public int getData() {
        return this.data;
    }

    public boolean isEnabled(TileEntityDistributor distributor) {
        if (distributor.getInventories().length == 0) {
            return false;
        }
        if (this.getSide() == EnumFacing.DOWN) {
            return !distributor.hasBot;
        }
        return this.getSide() != EnumFacing.UP || !distributor.hasTop;
    }

    public boolean isSet(int id) {
        return (this.data & 1 << id) != 0;
    }

    public void set(int id) {
        int count = 0;
        for (DistributorSetting setting : DistributorSetting.settings) {
            if (!this.isSet(setting.getId())) continue;
            ++count;
        }
        if (count < 11) {
            this.data |= 1 << id;
        }
    }

    public void reset(int id) {
        this.data &= ~(1 << id);
    }

    public short getLowShortData() {
        return (short)(this.getData() & 0xFFFF);
    }

    public short getHighShortData() {
        return (short)(this.getData() >> 16 & 0xFFFF);
    }

    public void setLowShortData(short data) {
        this.data = this.fixSignedIssue(this.getHighShortData()) << 16 | this.fixSignedIssue(data);
    }

    public void setHighShortData(short data) {
        this.data = this.fixSignedIssue(this.getLowShortData()) | this.fixSignedIssue(data) << 16;
    }

    private int fixSignedIssue(short val) {
        if (val < 0) {
            return val + 65536;
        }
        return val;
    }

    public String getInfo() {
        return Localization.GUI.DISTRIBUTOR.SIDE_TOOL_TIP.translate(this.getName());
    }
}

