/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.guis.buttons;

import net.minecraft.entity.player.EntityPlayer;
import vswe.stevescarts.computer.ComputerTask;
import vswe.stevescarts.guis.buttons.ButtonBase;
import vswe.stevescarts.guis.buttons.ButtonFlowCondition;
import vswe.stevescarts.modules.workers.ModuleComputer;

public class ButtonFlowConditionVar
extends ButtonFlowCondition {
    protected boolean increase;

    public ButtonFlowConditionVar(ModuleComputer module, ButtonBase.LOCATION loc, boolean increase) {
        super(module, loc);
        this.increase = increase;
    }

    @Override
    public String toString() {
        if (this.increase) {
            return "Next variable";
        }
        return "Previous variable";
    }

    @Override
    public int texture() {
        return this.increase ? 30 : 31;
    }

    @Override
    public boolean isEnabled() {
        for (ComputerTask task : ((ModuleComputer)this.module).getSelectedTasks()) {
            if (this.increase && this.getIndex(task) < task.getProgram().getVars().size() - 1) {
                return true;
            }
            if (this.increase || this.getIndex(task) <= -1) continue;
            return true;
        }
        return false;
    }

    @Override
    public void onServerClick(EntityPlayer player, int mousebutton, boolean ctrlKey, boolean shiftKey) {
        for (ComputerTask task : ((ModuleComputer)this.module).getSelectedTasks()) {
            this.setIndex(task, this.getIndex(task) + (this.increase ? 1 : -1));
        }
    }

    protected int getIndex(ComputerTask task) {
        return task.getFlowConditionVarIndex();
    }

    protected void setIndex(ComputerTask task, int val) {
        task.setFlowConditionVar(val);
    }
}

