/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.blocks.tileentities;

import java.util.ArrayList;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockRailBase;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vswe.stevescarts.Constants;
import vswe.stevescarts.SCConfig;
import vswe.stevescarts.blocks.BlockCartAssembler;
import vswe.stevescarts.blocks.ModBlocks;
import vswe.stevescarts.blocks.tileentities.TileEntityBase;
import vswe.stevescarts.blocks.tileentities.TileEntityManager;
import vswe.stevescarts.blocks.tileentities.TileEntityUpgrade;
import vswe.stevescarts.containers.ContainerBase;
import vswe.stevescarts.containers.ContainerCartAssembler;
import vswe.stevescarts.containers.ContainerUpgrade;
import vswe.stevescarts.containers.slots.SlotAssembler;
import vswe.stevescarts.containers.slots.SlotAssemblerFuel;
import vswe.stevescarts.containers.slots.SlotHull;
import vswe.stevescarts.containers.slots.SlotOutput;
import vswe.stevescarts.entitys.EntityMinecartModular;
import vswe.stevescarts.guis.GuiBase;
import vswe.stevescarts.guis.GuiCartAssembler;
import vswe.stevescarts.helpers.DropDownMenuItem;
import vswe.stevescarts.helpers.Localization;
import vswe.stevescarts.helpers.NBTHelper;
import vswe.stevescarts.helpers.SimulationInfo;
import vswe.stevescarts.helpers.TitleBox;
import vswe.stevescarts.helpers.storages.TransferHandler;
import vswe.stevescarts.helpers.storages.TransferManager;
import vswe.stevescarts.items.ItemCarts;
import vswe.stevescarts.items.ModItems;
import vswe.stevescarts.modules.data.ModuleData;
import vswe.stevescarts.modules.data.ModuleDataHull;
import vswe.stevescarts.upgrades.AssemblerUpgrade;
import vswe.stevescarts.upgrades.BaseEffect;
import vswe.stevescarts.upgrades.CombustionFuel;
import vswe.stevescarts.upgrades.Deployer;
import vswe.stevescarts.upgrades.Disassemble;
import vswe.stevescarts.upgrades.FuelCapacity;
import vswe.stevescarts.upgrades.FuelCost;
import vswe.stevescarts.upgrades.Manager;
import vswe.stevescarts.upgrades.TimeFlat;
import vswe.stevescarts.upgrades.TimeFlatCart;
import vswe.stevescarts.upgrades.TimeFlatRemoved;
import vswe.stevescarts.upgrades.WorkEfficiency;

public class TileEntityCartAssembler
extends TileEntityBase
implements IInventory,
ISidedInventory {
    private int maxAssemblingTime;
    private float currentAssemblingTime = -1.0f;
    private int fuelCheckTimer;
    @Nonnull
    protected ItemStack outputItem = ItemStack.field_190927_a;
    protected NonNullList<ItemStack> spareModules;
    private boolean isAssembling;
    public boolean isErrorListOutdated;
    private ArrayList<TitleBox> titleBoxes;
    private ArrayList<DropDownMenuItem> dropDownItems;
    private SimulationInfo info;
    private boolean shouldSpin = true;
    private EntityMinecartModular placeholder;
    private float yaw = 0.0f;
    private float roll = 0.0f;
    private boolean rolldown = false;
    private ArrayList<SlotAssembler> slots;
    private ArrayList<SlotAssembler> engineSlots;
    private ArrayList<SlotAssembler> addonSlots;
    private ArrayList<SlotAssembler> chestSlots;
    private ArrayList<SlotAssembler> funcSlots;
    private SlotHull hullSlot;
    private SlotAssembler toolSlot;
    private SlotOutput outputSlot;
    private SlotAssemblerFuel fuelSlot;
    private final int[] topbotSlots;
    private final int[] sideSlots;
    @Nonnull
    private ItemStack lastHull = ItemStack.field_190927_a;
    private float fuelLevel;
    private ArrayList<TileEntityUpgrade> upgrades = new ArrayList();
    public boolean isDead;
    private boolean loaded;
    NonNullList<ItemStack> inventoryStacks;
    public static final String MODIFY_STATUS = "ModifyStatus";

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiBase getGui(InventoryPlayer inv) {
        return new GuiCartAssembler(inv, this);
    }

    @Override
    public ContainerBase getContainer(InventoryPlayer inv) {
        return new ContainerCartAssembler((IInventory)inv, this);
    }

    public TileEntityCartAssembler() {
        SlotAssembler slot;
        int i;
        this.spareModules = NonNullList.func_191196_a();
        this.dropDownItems = new ArrayList();
        this.slots = new ArrayList();
        this.engineSlots = new ArrayList();
        this.addonSlots = new ArrayList();
        this.chestSlots = new ArrayList();
        this.funcSlots = new ArrayList();
        this.titleBoxes = new ArrayList();
        int slotID = 0;
        this.hullSlot = new SlotHull(this, slotID++, 18, 25);
        this.slots.add(this.hullSlot);
        TitleBox engineBox = new TitleBox(0, 65, 16225309);
        TitleBox toolBox = new TitleBox(1, 100, 6696337);
        TitleBox attachBox = new TitleBox(2, 135, 23423);
        TitleBox storageBox = new TitleBox(3, 170, 10357518);
        TitleBox addonBox = new TitleBox(4, 205, 22566);
        TitleBox infoBox = new TitleBox(5, 375, 30, 13417984);
        this.titleBoxes.add(engineBox);
        this.titleBoxes.add(toolBox);
        this.titleBoxes.add(attachBox);
        this.titleBoxes.add(storageBox);
        this.titleBoxes.add(addonBox);
        this.titleBoxes.add(infoBox);
        for (i = 0; i < 5; ++i) {
            slot = new SlotAssembler(this, slotID++, engineBox.getX() + 2 + 18 * i, engineBox.getY(), 1, false, i);
            slot.invalidate();
            this.slots.add(slot);
            this.engineSlots.add(slot);
        }
        this.toolSlot = new SlotAssembler(this, slotID++, toolBox.getX() + 2, toolBox.getY(), 2, false, 0);
        this.slots.add(this.toolSlot);
        this.toolSlot.invalidate();
        for (i = 0; i < 6; ++i) {
            slot = new SlotAssembler(this, slotID++, attachBox.getX() + 2 + 18 * i, attachBox.getY(), -1, false, i);
            slot.invalidate();
            this.slots.add(slot);
            this.funcSlots.add(slot);
        }
        for (i = 0; i < 4; ++i) {
            slot = new SlotAssembler(this, slotID++, storageBox.getX() + 2 + 18 * i, storageBox.getY(), 3, false, i);
            slot.invalidate();
            this.slots.add(slot);
            this.chestSlots.add(slot);
        }
        for (i = 0; i < 12; ++i) {
            slot = new SlotAssembler(this, slotID++, addonBox.getX() + 2 + 18 * (i % 6), addonBox.getY() + 18 * (i / 6), 4, false, i);
            slot.invalidate();
            this.slots.add(slot);
            this.addonSlots.add(slot);
        }
        this.fuelSlot = new SlotAssemblerFuel(this, slotID++, 395, 220);
        this.slots.add(this.fuelSlot);
        this.outputSlot = new SlotOutput(this, slotID++, 450, 220);
        this.slots.add(this.outputSlot);
        this.info = new SimulationInfo();
        this.inventoryStacks = NonNullList.func_191197_a((int)this.slots.size(), (Object)ItemStack.field_190927_a);
        this.topbotSlots = new int[]{this.func_70302_i_() - this.nonModularSlots()};
        this.sideSlots = new int[]{this.func_70302_i_() - this.nonModularSlots() + 1};
    }

    public void clearUpgrades() {
        this.upgrades.clear();
    }

    public void addUpgrade(TileEntityUpgrade upgrade) {
        this.upgrades.add(upgrade);
    }

    public void removeUpgrade(TileEntityUpgrade upgrade) {
        this.upgrades.remove(upgrade);
    }

    public ArrayList<TileEntityUpgrade> getUpgradeTiles() {
        return this.upgrades;
    }

    public ArrayList<AssemblerUpgrade> getUpgrades() {
        ArrayList<AssemblerUpgrade> lst = new ArrayList<AssemblerUpgrade>();
        for (TileEntityUpgrade tile : this.upgrades) {
            lst.add(tile.getUpgrade());
        }
        return lst;
    }

    public ArrayList<BaseEffect> getEffects() {
        ArrayList<BaseEffect> lst = new ArrayList<BaseEffect>();
        for (TileEntityUpgrade tile : this.upgrades) {
            AssemblerUpgrade upgrade = tile.getUpgrade();
            if (upgrade == null) continue;
            for (BaseEffect effect : upgrade.getEffects()) {
                lst.add(effect);
            }
        }
        return lst;
    }

    public SimulationInfo getSimulationInfo() {
        return this.info;
    }

    public ArrayList<DropDownMenuItem> getDropDown() {
        return this.dropDownItems;
    }

    public ArrayList<TitleBox> getTitleBoxes() {
        return this.titleBoxes;
    }

    public static int getRemovedSize() {
        return -1;
    }

    public static int getKeepSize() {
        return 0;
    }

    public ArrayList<SlotAssembler> getSlots() {
        return this.slots;
    }

    public ArrayList<SlotAssembler> getEngines() {
        return this.engineSlots;
    }

    public ArrayList<SlotAssembler> getChests() {
        return this.chestSlots;
    }

    public ArrayList<SlotAssembler> getAddons() {
        return this.addonSlots;
    }

    public ArrayList<SlotAssembler> getFuncs() {
        return this.funcSlots;
    }

    public SlotAssembler getToolSlot() {
        return this.toolSlot;
    }

    public int getMaxAssemblingTime() {
        return this.maxAssemblingTime;
    }

    public int getAssemblingTime() {
        return (int)this.currentAssemblingTime;
    }

    private void setAssemblingTime(int val) {
        this.currentAssemblingTime = val;
    }

    public boolean getIsAssembling() {
        return this.isAssembling;
    }

    public void doAssemble() {
        if (!this.hasErrors()) {
            this.maxAssemblingTime = this.generateAssemblingTime();
            this.createCartFromModules();
            this.isAssembling = true;
            for (TileEntityUpgrade tile : this.getUpgradeTiles()) {
                if (tile.getUpgrade() == null) continue;
                for (BaseEffect effect : tile.getUpgrade().getEffects()) {
                    if (!(effect instanceof Disassemble)) continue;
                    ItemStack oldcart = tile.func_70301_a(0);
                    if (!oldcart.func_190926_b() && !this.outputItem.func_190926_b() && oldcart.func_77973_b() instanceof ItemCarts && this.outputItem.func_77973_b() instanceof ItemCarts && oldcart.func_82837_s()) {
                        this.outputItem.func_151001_c(oldcart.func_82833_r());
                    }
                    tile.func_70299_a(0, ItemStack.field_190927_a);
                }
            }
        }
    }

    @Override
    public void receivePacket(int id, byte[] data, EntityPlayer player) {
        SlotAssembler slot;
        byte slotId;
        if (id == 0) {
            this.doAssemble();
        } else if (id == 1 && (slotId = data[0]) >= 1 && slotId < this.getSlots().size() && !(slot = this.getSlots().get(slotId)).func_75211_c().func_190926_b()) {
            NBTTagCompound comp = TileEntityCartAssembler.getOrCreateCompound(slot.func_75211_c());
            if (comp.func_74762_e(MODIFY_STATUS) == TileEntityCartAssembler.getKeepSize()) {
                comp.func_74768_a(MODIFY_STATUS, TileEntityCartAssembler.getRemovedSize());
            } else {
                comp.func_74768_a(MODIFY_STATUS, TileEntityCartAssembler.getKeepSize());
            }
        }
    }

    public static NBTTagCompound getOrCreateCompound(ItemStack stack) {
        if (!stack.func_77942_o() && stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return stack.func_77978_p();
    }

    public static int getSlotStatus(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_150297_b(MODIFY_STATUS, NBTHelper.INT.getId())) {
            return stack.func_77978_p().func_74762_e(MODIFY_STATUS);
        }
        return 1;
    }

    public static ItemStack removeModify(ItemStack stack) {
        if (stack.func_77942_o() && stack.func_77978_p().func_150297_b(MODIFY_STATUS, NBTHelper.INT.getId())) {
            stack.func_77978_p().func_82580_o(MODIFY_STATUS);
            if (stack.func_77978_p().func_186856_d() <= 0) {
                stack.func_77982_d(null);
            }
        }
        return stack;
    }

    public void onUpgradeUpdate() {
    }

    public int generateAssemblingTime() {
        if (SCConfig.disableTimedCrafting) {
            return 1;
        }
        return this.generateAssemblingTime(this.getModules(true, new int[]{TileEntityCartAssembler.getKeepSize(), TileEntityCartAssembler.getRemovedSize()}), this.getModules(true, new int[]{TileEntityCartAssembler.getKeepSize(), 1}));
    }

    private int generateAssemblingTime(ArrayList<ModuleData> modules, ArrayList<ModuleData> removed) {
        int timeRequired = 100;
        for (ModuleData module : modules) {
            timeRequired += this.getAssemblingTime(module, false);
        }
        for (ModuleData module : removed) {
            timeRequired += this.getAssemblingTime(module, true);
        }
        for (BaseEffect effect : this.getEffects()) {
            if (!(effect instanceof TimeFlatCart)) continue;
            timeRequired += ((TimeFlatCart)effect).getTicks();
        }
        return Math.max(0, timeRequired);
    }

    private int getAssemblingTime(ModuleData module, boolean isRemoved) {
        int time = (int)(5.0 * Math.pow(module.getCost(), 2.2));
        return Math.max(0, time += this.getTimeDecreased(isRemoved));
    }

    @Nonnull
    public ItemStack getCartFromModules(boolean isSimulated) {
        NonNullList items = NonNullList.func_191196_a();
        for (int i = 0; i < this.func_70302_i_() - this.nonModularSlots(); ++i) {
            ItemStack item = this.func_70301_a(i);
            if (item.func_190926_b()) continue;
            if (TileEntityCartAssembler.getSlotStatus(item) != TileEntityCartAssembler.getRemovedSize()) {
                items.add((Object)item);
                continue;
            }
            if (isSimulated) continue;
            ItemStack spare = item.func_77946_l();
            spare.func_190920_e(1);
            this.spareModules.add((Object)spare);
        }
        if (items.size() == 1) {
            return TileEntityCartAssembler.removeModify((ItemStack)items.get(0));
        }
        return ModuleData.createModularCartFromItems((NonNullList<ItemStack>)items);
    }

    private void createCartFromModules() {
        this.spareModules.clear();
        this.outputItem = this.getCartFromModules(false);
        if (!this.outputItem.func_190926_b()) {
            for (int i = 0; i < this.func_70302_i_() - this.nonModularSlots(); ++i) {
                this.func_70299_a(i, ItemStack.field_190927_a);
            }
        } else {
            this.spareModules.clear();
        }
    }

    public ArrayList<ModuleData> getNonHullModules() {
        return this.getModules(false);
    }

    public ArrayList<ModuleData> getModules(boolean includeHull) {
        return this.getModules(includeHull, new int[]{TileEntityCartAssembler.getRemovedSize()});
    }

    public ArrayList<ModuleData> getModules(boolean includeHull, int[] invalid) {
        int i;
        ArrayList<ModuleData> modules = new ArrayList<ModuleData>();
        int n = i = includeHull ? 0 : 1;
        while (i < this.func_70302_i_() - this.nonModularSlots()) {
            ItemStack item = this.func_70301_a(i);
            if (!item.func_190926_b()) {
                ModuleData module;
                boolean validSize = true;
                for (int j = 0; j < invalid.length; ++j) {
                    if (invalid[j] != TileEntityCartAssembler.getSlotStatus(item) && (invalid[j] <= 0 || TileEntityCartAssembler.getSlotStatus(item) <= 0)) continue;
                    validSize = false;
                    break;
                }
                if (validSize && (module = ModItems.MODULES.getModuleData(item, true)) != null) {
                    modules.add(module);
                }
            }
            ++i;
        }
        return modules;
    }

    public ModuleDataHull getHullModule() {
        ModuleData hulldata;
        if (!this.func_70301_a(0).func_190926_b() && (hulldata = ModItems.MODULES.getModuleData(this.func_70301_a(0))) instanceof ModuleDataHull) {
            return (ModuleDataHull)hulldata;
        }
        return null;
    }

    private boolean hasErrors() {
        return this.getErrors().size() > 0;
    }

    public ArrayList<String> getErrors() {
        ArrayList<String> errors = new ArrayList<String>();
        if (this.hullSlot.func_75211_c().func_190926_b()) {
            errors.add(Localization.GUI.ASSEMBLER.HULL_ERROR.translate(new String[0]));
        } else {
            ModuleData hulldata = ModItems.MODULES.getModuleData(this.func_70301_a(0));
            if (hulldata == null || !(hulldata instanceof ModuleDataHull)) {
                errors.add(Localization.GUI.ASSEMBLER.INVALID_HULL_SHORT.translate(new String[0]));
            } else {
                if (this.isAssembling) {
                    errors.add(Localization.GUI.ASSEMBLER.BUSY.translate(new String[0]));
                } else if (this.outputSlot != null && !this.outputSlot.func_75211_c().func_190926_b()) {
                    errors.add(Localization.GUI.ASSEMBLER.DEPARTURE_BAY.translate(new String[0]));
                }
                ArrayList<ModuleData> modules = new ArrayList<ModuleData>();
                for (int i = 0; i < this.func_70302_i_() - this.nonModularSlots(); ++i) {
                    ModuleData data;
                    if (this.func_70301_a(i).func_190926_b() || (data = ModItems.MODULES.getModuleData(this.func_70301_a(i))) == null) continue;
                    modules.add(data);
                }
                String error = ModuleData.checkForErrors((ModuleDataHull)hulldata, modules);
                if (error != null) {
                    errors.add(error);
                }
            }
        }
        return errors;
    }

    public int getTotalCost() {
        ArrayList<ModuleData> modules = new ArrayList<ModuleData>();
        for (int i = 0; i < this.func_70302_i_() - this.nonModularSlots(); ++i) {
            ModuleData data;
            if (this.func_70301_a(i).func_190926_b() || (data = ModItems.MODULES.getModuleData(this.func_70301_a(i))) == null) continue;
            modules.add(data);
        }
        return ModuleData.getTotalCost(modules);
    }

    @Override
    public void initGuiData(Container con, IContainerListener crafting) {
        this.updateGuiData(con, crafting, 0, this.getShortFromInt(true, this.maxAssemblingTime));
        this.updateGuiData(con, crafting, 1, this.getShortFromInt(false, this.maxAssemblingTime));
        this.updateGuiData(con, crafting, 2, this.getShortFromInt(true, this.getAssemblingTime()));
        this.updateGuiData(con, crafting, 3, this.getShortFromInt(false, this.getAssemblingTime()));
        this.updateGuiData(con, crafting, 4, (short)(this.isAssembling ? 1 : 0));
        this.updateGuiData(con, crafting, 5, this.getShortFromInt(true, this.getFuelLevel()));
        this.updateGuiData(con, crafting, 6, this.getShortFromInt(false, this.getFuelLevel()));
    }

    @Override
    public void checkGuiData(Container container, IContainerListener crafting) {
        ContainerCartAssembler con = (ContainerCartAssembler)container;
        if (con.lastMaxAssemblingTime != this.maxAssemblingTime) {
            this.updateGuiData(con, crafting, 0, this.getShortFromInt(true, this.maxAssemblingTime));
            this.updateGuiData(con, crafting, 1, this.getShortFromInt(false, this.maxAssemblingTime));
            con.lastMaxAssemblingTime = this.maxAssemblingTime;
        }
        if (con.lastIsAssembling != this.isAssembling) {
            this.updateGuiData(con, crafting, 4, (short)(this.isAssembling ? 1 : 0));
            con.lastIsAssembling = this.isAssembling;
        }
        if (con.lastFuelLevel != this.getFuelLevel()) {
            this.updateGuiData(con, crafting, 5, this.getShortFromInt(true, this.getFuelLevel()));
            this.updateGuiData(con, crafting, 6, this.getShortFromInt(false, this.getFuelLevel()));
            con.lastFuelLevel = this.getFuelLevel();
        }
    }

    @Override
    public void receiveGuiData(int id, short data) {
        if (id == 0) {
            this.maxAssemblingTime = this.getIntFromShort(true, this.maxAssemblingTime, data);
        } else if (id == 1) {
            this.maxAssemblingTime = this.getIntFromShort(false, this.maxAssemblingTime, data);
        } else if (id == 2) {
            this.setAssemblingTime(this.getIntFromShort(true, this.getAssemblingTime(), data));
        } else if (id == 3) {
            this.setAssemblingTime(this.getIntFromShort(false, this.getAssemblingTime(), data));
        } else if (id == 4) {
            this.isAssembling = data != 0;
            if (!this.isAssembling) {
                this.setAssemblingTime(0);
            }
        } else if (id == 5) {
            this.setFuelLevel(this.getIntFromShort(true, this.getFuelLevel(), data));
        } else if (id == 6) {
            this.setFuelLevel(this.getIntFromShort(false, this.getFuelLevel(), data));
        }
    }

    private void invalidateAll() {
        int i;
        for (i = 0; i < this.getEngines().size(); ++i) {
            this.getEngines().get(i).invalidate();
        }
        for (i = 0; i < this.getAddons().size(); ++i) {
            this.getAddons().get(i).invalidate();
        }
        for (i = 0; i < this.getChests().size(); ++i) {
            this.getChests().get(i).invalidate();
        }
        for (i = 0; i < this.getFuncs().size(); ++i) {
            this.getFuncs().get(i).invalidate();
        }
        this.getToolSlot().invalidate();
    }

    private void validateAll() {
        if (this.hullSlot == null) {
            return;
        }
        ArrayList<SlotAssembler> slots = this.getValidSlotFromHullItem(this.hullSlot.func_75211_c());
        if (slots != null) {
            for (SlotAssembler slot : slots) {
                slot.validate();
            }
        }
    }

    public ArrayList<SlotAssembler> getValidSlotFromHullItem(@Nonnull ItemStack hullitem) {
        ModuleData data;
        if (!hullitem.func_190926_b() && (data = ModItems.MODULES.getModuleData(hullitem)) != null && data instanceof ModuleDataHull) {
            ModuleDataHull hull = (ModuleDataHull)data;
            return this.getValidSlotFromHull(hull);
        }
        return null;
    }

    private ArrayList<SlotAssembler> getValidSlotFromHull(ModuleDataHull hull) {
        int i;
        ArrayList<SlotAssembler> slots = new ArrayList<SlotAssembler>();
        for (i = 0; i < hull.getEngineMax(); ++i) {
            slots.add(this.getEngines().get(i));
        }
        for (i = 0; i < hull.getAddonMax(); ++i) {
            slots.add(this.getAddons().get(i));
        }
        for (i = 0; i < this.getChests().size(); ++i) {
            slots.add(this.getChests().get(i));
        }
        for (i = 0; i < this.getFuncs().size(); ++i) {
            slots.add(this.getFuncs().get(i));
        }
        slots.add(this.getToolSlot());
        return slots;
    }

    public int getMaxFuelLevel() {
        int capacity = 4000;
        for (BaseEffect effect : this.getEffects()) {
            if (!(effect instanceof FuelCapacity)) continue;
            capacity += ((FuelCapacity)effect).getFuelCapacity();
        }
        if (capacity > 200000) {
            capacity = 200000;
        } else if (capacity < 1) {
            capacity = 1;
        }
        return capacity;
    }

    public boolean isCombustionFuelValid() {
        for (BaseEffect effect : this.getEffects()) {
            if (!(effect instanceof CombustionFuel)) continue;
            return true;
        }
        return false;
    }

    public int getFuelLevel() {
        return (int)this.fuelLevel;
    }

    public void setFuelLevel(int val) {
        this.fuelLevel = val;
    }

    private int getTimeDecreased(boolean isRemoved) {
        int timeDecr = 0;
        for (BaseEffect effect : this.getEffects()) {
            if (!(effect instanceof TimeFlat) || effect instanceof TimeFlatRemoved) continue;
            timeDecr += ((TimeFlat)effect).getTicks();
        }
        if (isRemoved) {
            for (BaseEffect effect : this.getEffects()) {
                if (!(effect instanceof TimeFlatRemoved)) continue;
                timeDecr += ((TimeFlat)effect).getTicks();
            }
        }
        return timeDecr;
    }

    private float getFuelCost() {
        float cost = 1.0f;
        for (BaseEffect effect : this.getEffects()) {
            if (!(effect instanceof FuelCost)) continue;
            cost += ((FuelCost)effect).getCost();
        }
        if (cost < 0.05f) {
            // empty if block
        }
        return cost;
    }

    public float getEfficiency() {
        float efficiency = 1.0f;
        for (BaseEffect effect : this.getEffects()) {
            if (!(effect instanceof WorkEfficiency)) continue;
            efficiency += ((WorkEfficiency)effect).getEfficiency();
        }
        return efficiency;
    }

    private void deployCart() {
        if (!this.outputItem.func_190926_b() && this.outputItem.func_77973_b() instanceof ItemCarts) {
            for (TileEntityUpgrade tile : this.getUpgradeTiles()) {
                for (BaseEffect effect : tile.getUpgrade().getEffects()) {
                    if (!(effect instanceof Deployer)) continue;
                    BlockPos tilePos = tile.func_174877_v();
                    int xPos = 2 * tilePos.func_177958_n() - this.field_174879_c.func_177958_n();
                    int yPos = 2 * tilePos.func_177956_o() - this.field_174879_c.func_177956_o();
                    int zPos = 2 * tilePos.func_177952_p() - this.field_174879_c.func_177952_p();
                    if (tilePos.func_177956_o() > this.field_174879_c.func_177956_o()) {
                        ++yPos;
                    }
                    if (!BlockRailBase.func_176562_d((World)this.field_145850_b, (BlockPos)new BlockPos(xPos, yPos, zPos))) continue;
                    try {
                        NBTTagCompound info = this.outputItem.func_77978_p();
                        if (info == null) continue;
                        EntityMinecartModular cart = new EntityMinecartModular(this.field_145850_b, (float)xPos + 0.5f, (float)yPos + 0.5f, (float)zPos + 0.5f, info, this.outputItem.func_82833_r());
                        this.field_145850_b.func_72838_d((Entity)cart);
                        cart.temppushX = tilePos.func_177958_n() - this.field_174879_c.func_177958_n();
                        cart.temppushZ = tilePos.func_177952_p() - this.field_174879_c.func_177952_p();
                        this.managerInteract(cart, true);
                        return;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        this.outputSlot.func_75215_d(this.outputItem);
    }

    public void managerInteract(EntityMinecartModular cart, boolean toCart) {
        for (TileEntityUpgrade tile : this.getUpgradeTiles()) {
            for (BaseEffect effect : tile.getUpgrade().getEffects()) {
                TileEntity managerentity;
                if (!(effect instanceof Manager)) continue;
                BlockPos tilePos = tile.func_174877_v();
                int xPos = 2 * tilePos.func_177958_n() - this.field_174879_c.func_177958_n();
                int yPos = 2 * tilePos.func_177956_o() - this.field_174879_c.func_177956_o();
                int zPos = 2 * tilePos.func_177952_p() - this.field_174879_c.func_177952_p();
                if (tilePos.func_177956_o() > this.field_174879_c.func_177956_o()) {
                    ++yPos;
                }
                if ((managerentity = this.field_145850_b.func_175625_s(new BlockPos(xPos, yPos, zPos))) == null || !(managerentity instanceof TileEntityManager)) continue;
                TransferManager transfer = new TransferManager();
                transfer.setCart(cart);
                if (tilePos.func_177956_o() != this.field_174879_c.func_177956_o()) {
                    transfer.setSide(-1);
                } else if (tilePos.func_177958_n() < this.field_174879_c.func_177958_n()) {
                    transfer.setSide(0);
                } else if (tilePos.func_177958_n() > this.field_174879_c.func_177958_n()) {
                    transfer.setSide(3);
                } else if (tilePos.func_177952_p() < this.field_174879_c.func_177952_p()) {
                    transfer.setSide(1);
                } else if (tilePos.func_177952_p() > this.field_174879_c.func_177952_p()) {
                    transfer.setSide(2);
                }
                if (toCart) {
                    transfer.setFromCartEnabled(false);
                } else {
                    transfer.setToCartEnabled(false);
                }
                TileEntityManager manager = (TileEntityManager)managerentity;
                while (manager.exchangeItems(transfer)) {
                }
            }
        }
    }

    private void deploySpares() {
        for (TileEntityUpgrade tile : this.getUpgradeTiles()) {
            if (tile.getUpgrade() == null) continue;
            for (BaseEffect effect : tile.getUpgrade().getEffects()) {
                if (!(effect instanceof Disassemble)) continue;
                for (ItemStack item : this.spareModules) {
                    item = TileEntityCartAssembler.removeModify(item);
                    TransferHandler.TransferItem(item, tile, new ContainerUpgrade(null, tile), 1);
                    if (item.func_190916_E() <= 0) continue;
                    this.puke(item);
                }
            }
        }
    }

    public void puke(@Nonnull ItemStack item) {
        EntityItem entityitem = new EntityItem(this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o() + 0.25, (double)this.field_174879_c.func_177952_p(), item);
        entityitem.field_70159_w = (0.5f - this.field_145850_b.field_73012_v.nextFloat()) / 10.0f;
        entityitem.field_70181_x = 0.15f;
        entityitem.field_70179_y = (0.5f - this.field_145850_b.field_73012_v.nextFloat()) / 10.0f;
        this.field_145850_b.func_72838_d((Entity)entityitem);
    }

    @Override
    public void updateEntity() {
        NBTTagCompound info;
        ItemStack itemInSlot;
        if (!this.loaded) {
            ((BlockCartAssembler)ModBlocks.CART_ASSEMBLER.getBlock()).updateMultiBlock(this.field_145850_b, this.field_174879_c);
            this.loaded = true;
        }
        if (!this.isAssembling && this.outputSlot != null && !this.outputSlot.func_75211_c().func_190926_b() && (itemInSlot = this.outputSlot.func_75211_c()).func_77973_b() == ModItems.CARTS && (info = itemInSlot.func_77978_p()) != null && info.func_74764_b("maxTime")) {
            ItemStack newItem = new ItemStack((Item)ModItems.CARTS);
            NBTTagCompound save = new NBTTagCompound();
            save.func_74773_a("Modules", info.func_74770_j("Modules"));
            newItem.func_77982_d(save);
            int modulecount = info.func_74770_j("Modules").length;
            this.maxAssemblingTime = info.func_74762_e("maxTime");
            this.setAssemblingTime(info.func_74762_e("currentTime"));
            this.spareModules.clear();
            if (info.func_74764_b("Spares")) {
                byte[] moduleIDs = info.func_74770_j("Spares");
                for (int i = 0; i < moduleIDs.length; ++i) {
                    byte id = moduleIDs[i];
                    ItemStack module = new ItemStack((Item)ModItems.MODULES, 1, (int)id);
                    ModItems.MODULES.addExtraDataToModule(module, info, i + modulecount);
                    this.spareModules.add((Object)module);
                }
            }
            if (itemInSlot.func_82837_s()) {
                newItem.func_151001_c(itemInSlot.func_82833_r());
            }
            this.isAssembling = true;
            this.outputItem = newItem;
            this.outputSlot.func_75215_d(ItemStack.field_190927_a);
        }
        if (this.getFuelLevel() > this.getMaxFuelLevel()) {
            this.setFuelLevel(this.getMaxFuelLevel());
        }
        if (this.isAssembling && this.outputSlot != null && (float)this.getFuelLevel() >= this.getFuelCost()) {
            this.currentAssemblingTime += this.getEfficiency();
            this.fuelLevel -= this.getFuelCost();
            if (this.getFuelLevel() <= 0) {
                this.setFuelLevel(0);
            }
            if (this.getAssemblingTime() >= this.maxAssemblingTime) {
                this.isAssembling = false;
                this.setAssemblingTime(0);
                if (!this.field_145850_b.field_72995_K) {
                    this.deployCart();
                    this.outputItem = ItemStack.field_190927_a;
                    this.deploySpares();
                    this.spareModules.clear();
                }
            }
        }
        if (!this.field_145850_b.field_72995_K && this.fuelCheckTimer-- <= 0 && this.fuelSlot != null && !this.fuelSlot.func_75211_c().func_190926_b() && this.getFuelLevel() < this.getMaxFuelLevel()) {
            int fuel = this.fuelSlot.getFuelLevel(this.fuelSlot.func_75211_c());
            if (fuel > 0 && this.getFuelLevel() + fuel <= this.getMaxFuelLevel()) {
                this.setFuelLevel(this.getFuelLevel() + fuel);
                if (this.fuelSlot.func_75211_c().func_77973_b().hasContainerItem(this.fuelSlot.func_75211_c())) {
                    this.fuelSlot.func_75215_d(new ItemStack(this.fuelSlot.func_75211_c().func_77973_b().func_77668_q()));
                } else {
                    ItemStack stack = this.fuelSlot.func_75211_c();
                    stack.func_190918_g(1);
                }
                if (this.fuelSlot.func_75211_c().func_190916_E() <= 0) {
                    this.fuelSlot.func_75215_d(ItemStack.field_190927_a);
                }
            } else {
                this.fuelCheckTimer = 20;
            }
        }
        this.updateSlots();
        this.handlePlaceholder();
    }

    public void updateSlots() {
        if (this.hullSlot != null) {
            if (!this.lastHull.func_190926_b() && this.hullSlot.func_75211_c().func_190926_b()) {
                this.invalidateAll();
            } else if (this.lastHull.func_190926_b() && !this.hullSlot.func_75211_c().func_190926_b()) {
                this.validateAll();
            } else if (this.lastHull != this.hullSlot.func_75211_c()) {
                this.invalidateAll();
                this.validateAll();
            }
            this.lastHull = this.hullSlot.func_75211_c();
        }
        for (SlotAssembler slot : this.slots) {
            slot.update();
        }
    }

    public void resetPlaceholder() {
        this.placeholder = null;
    }

    public EntityMinecartModular getPlaceholder() {
        return this.placeholder;
    }

    public float getYaw() {
        return this.yaw;
    }

    public float getRoll() {
        return this.roll;
    }

    public void setYaw(float val) {
        this.yaw = val;
    }

    public void setRoll(float val) {
        this.roll = val;
    }

    public void setSpinning(boolean val) {
        this.shouldSpin = val;
    }

    public int nonModularSlots() {
        return 2;
    }

    private void handlePlaceholder() {
        if (this.field_145850_b.field_72995_K) {
            if (this.placeholder == null) {
                return;
            }
            if (!Constants.freezeCartSimulation) {
                int minRoll = -5;
                int maxRoll = 25;
                if (this.shouldSpin) {
                    this.yaw += 2.0f;
                    this.roll %= 360.0f;
                    if (!this.rolldown) {
                        this.roll = this.roll < -8.0f ? (this.roll += 5.0f) : (this.roll += 0.2f);
                        if (this.roll > 25.0f) {
                            this.rolldown = true;
                        }
                    } else {
                        this.roll = this.roll > 28.0f ? (this.roll -= 5.0f) : (this.roll -= 0.2f);
                        if (this.roll < -5.0f) {
                            this.rolldown = false;
                        }
                    }
                }
            }
            this.placeholder.onCartUpdate();
            if (this.placeholder == null) {
                return;
            }
            this.placeholder.updateFuel();
        }
    }

    public void createPlaceholder() {
        if (this.placeholder == null) {
            this.placeholder = new EntityMinecartModular(this.field_145850_b, this, this.getModularInfoBytes());
            this.updateRenderMenu();
            this.isErrorListOutdated = true;
        }
    }

    public void updatePlaceholder() {
        if (this.placeholder != null) {
            this.placeholder.updateSimulationModules(this.getModularInfoBytes());
            this.updateRenderMenu();
            this.isErrorListOutdated = true;
        }
    }

    private void updateRenderMenu() {
        ArrayList<DropDownMenuItem> list = this.info.getList();
        this.dropDownItems.clear();
        block0: for (DropDownMenuItem item : list) {
            if (item.getModuleClass() == null) {
                this.dropDownItems.add(item);
                continue;
            }
            for (int i = 0; i < this.func_70302_i_() - this.nonModularSlots(); ++i) {
                if (this.func_70301_a(i).func_190926_b() || !ModuleData.isItemOfModularType(this.func_70301_a(i), item.getModuleClass()) || item.getExcludedClass() != null && ModuleData.isItemOfModularType(this.func_70301_a(i), item.getExcludedClass())) continue;
                this.dropDownItems.add(item);
                continue block0;
            }
        }
    }

    private byte[] getModularInfoBytes() {
        ArrayList<Byte> datalist = new ArrayList<Byte>();
        for (int i = 0; i < this.func_70302_i_() - this.nonModularSlots(); ++i) {
            ModuleData data;
            if (this.func_70301_a(i).func_190926_b() || (data = ModItems.MODULES.getModuleData(this.func_70301_a(i))) == null) continue;
            datalist.add((byte)this.func_70301_a(i).func_77952_i());
        }
        byte[] bytes = new byte[datalist.size()];
        for (int j = 0; j < datalist.size(); ++j) {
            bytes[j] = (Byte)datalist.get(j);
        }
        return bytes;
    }

    public boolean getIsDisassembling() {
        for (int i = 0; i < this.func_70302_i_() - this.nonModularSlots(); ++i) {
            if (this.func_70301_a(i).func_190926_b() || TileEntityCartAssembler.getSlotStatus(this.func_70301_a(i)) > 0) continue;
            return true;
        }
        return false;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return this.field_145850_b.func_175625_s(this.field_174879_c) == this && entityplayer.func_174831_c(this.field_174879_c) <= 64.0;
    }

    @Nonnull
    public ItemStack func_70304_b(int index) {
        ItemStack item = this.func_70301_a(index);
        if (item.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        this.func_70299_a(index, ItemStack.field_190927_a);
        if (item.func_190916_E() == 0) {
            return ItemStack.field_190927_a;
        }
        return item;
    }

    public int func_70302_i_() {
        return this.inventoryStacks.size();
    }

    public boolean func_191420_l() {
        for (ItemStack stack : this.inventoryStacks) {
            if (stack.func_190926_b()) continue;
            return false;
        }
        return this.getOutputInfo() == null;
    }

    @Nonnull
    public ItemStack func_70301_a(int i) {
        return (ItemStack)this.inventoryStacks.get(i);
    }

    @Nonnull
    public ItemStack func_70298_a(int i, int j) {
        if (((ItemStack)this.inventoryStacks.get(i)).func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (((ItemStack)this.inventoryStacks.get(i)).func_190916_E() <= j) {
            ItemStack itemstack = (ItemStack)this.inventoryStacks.get(i);
            this.inventoryStacks.set(i, (Object)ItemStack.field_190927_a);
            this.func_70296_d();
            return itemstack;
        }
        ItemStack itemstack2 = ((ItemStack)this.inventoryStacks.get(i)).func_77979_a(j);
        if (((ItemStack)this.inventoryStacks.get(i)).func_190916_E() == 0) {
            this.inventoryStacks.set(i, (Object)ItemStack.field_190927_a);
        }
        this.func_70296_d();
        return itemstack2;
    }

    public void func_70299_a(int i, @Nonnull ItemStack itemstack) {
        this.inventoryStacks.set(i, (Object)itemstack);
        if (!itemstack.func_190926_b() && itemstack.func_190916_E() > this.func_70297_j_()) {
            itemstack.func_190920_e(this.func_70297_j_());
        }
        this.func_70296_d();
    }

    public String func_70005_c_() {
        return "container.cartassembler";
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentString(this.func_70005_c_());
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_145839_a(NBTTagCompound tagCompound) {
        ItemStack iStack;
        super.func_145839_a(tagCompound);
        NBTTagList items = tagCompound.func_150295_c("Items", NBTHelper.COMPOUND.getId());
        for (int i = 0; i < items.func_74745_c(); ++i) {
            NBTTagCompound item = items.func_150305_b(i);
            int slot = item.func_74771_c("Slot") & 0xFF;
            iStack = new ItemStack(item);
            if (slot < 0 || slot >= this.func_70302_i_()) continue;
            this.func_70299_a(slot, iStack);
        }
        NBTTagList spares = tagCompound.func_150295_c("Spares", NBTHelper.COMPOUND.getId());
        this.spareModules.clear();
        for (int j = 0; j < spares.func_74745_c(); ++j) {
            NBTTagCompound item2 = spares.func_150305_b(j);
            iStack = new ItemStack(item2);
            this.spareModules.add((Object)iStack);
        }
        NBTTagCompound outputTag = (NBTTagCompound)tagCompound.func_74781_a("Output");
        if (outputTag != null) {
            this.outputItem = new ItemStack(outputTag);
        }
        if (tagCompound.func_74764_b("Fuel")) {
            this.setFuelLevel(tagCompound.func_74765_d("Fuel"));
        } else {
            this.setFuelLevel(tagCompound.func_74762_e("IntFuel"));
        }
        this.maxAssemblingTime = tagCompound.func_74762_e("maxTime");
        this.setAssemblingTime(tagCompound.func_74762_e("currentTime"));
        this.isAssembling = tagCompound.func_74767_n("isAssembling");
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tagCompound) {
        super.func_189515_b(tagCompound);
        NBTTagList items = new NBTTagList();
        for (int i = 0; i < this.func_70302_i_(); ++i) {
            ItemStack iStack = this.func_70301_a(i);
            if (iStack.func_190926_b()) continue;
            NBTTagCompound item = new NBTTagCompound();
            item.func_74774_a("Slot", (byte)i);
            iStack.func_77955_b(item);
            items.func_74742_a((NBTBase)item);
        }
        tagCompound.func_74782_a("Items", (NBTBase)items);
        NBTTagList spares = new NBTTagList();
        for (int j = 0; j < this.spareModules.size(); ++j) {
            ItemStack iStack2 = (ItemStack)this.spareModules.get(j);
            if (iStack2.func_190926_b()) continue;
            NBTTagCompound item2 = new NBTTagCompound();
            iStack2.func_77955_b(item2);
            spares.func_74742_a((NBTBase)item2);
        }
        tagCompound.func_74782_a("Spares", (NBTBase)spares);
        if (!this.outputItem.func_190926_b()) {
            NBTTagCompound outputTag = new NBTTagCompound();
            this.outputItem.func_77955_b(outputTag);
            tagCompound.func_74782_a("Output", (NBTBase)outputTag);
        }
        tagCompound.func_74768_a("IntFuel", this.getFuelLevel());
        tagCompound.func_74768_a("maxTime", this.maxAssemblingTime);
        tagCompound.func_74768_a("currentTime", this.getAssemblingTime());
        tagCompound.func_74757_a("isAssembling", this.isAssembling);
        return tagCompound;
    }

    public NBTTagCompound getOutputInfo() {
        if (this.outputItem.func_190926_b()) {
            return null;
        }
        if (!this.outputItem.func_77942_o()) {
            return null;
        }
        return this.outputItem.func_77978_p();
    }

    @Nonnull
    public ItemStack getOutputOnInterupt() {
        NBTTagCompound info = this.getOutputInfo();
        if (info == null) {
            return ItemStack.field_190927_a;
        }
        info.func_74768_a("currentTime", this.getAssemblingTime());
        info.func_74768_a("maxTime", this.maxAssemblingTime);
        int modulecount = info.func_74770_j("Modules").length;
        NBTTagCompound spares = new NBTTagCompound();
        byte[] moduleIDs = new byte[this.spareModules.size()];
        for (int i = 0; i < this.spareModules.size(); ++i) {
            ItemStack item = (ItemStack)this.spareModules.get(i);
            ModuleData data = ModItems.MODULES.getModuleData(item);
            if (data == null) continue;
            moduleIDs[i] = data.getID();
            ModItems.MODULES.addExtraDataToCart(info, item, i + modulecount);
        }
        info.func_74773_a("Spares", moduleIDs);
        return this.outputItem;
    }

    public boolean func_94041_b(int slotId, @Nonnull ItemStack item) {
        return slotId >= 0 && slotId < this.slots.size() && this.slots.get(slotId).func_75214_a(item);
    }

    public int[] func_180463_a(EnumFacing side) {
        return side == EnumFacing.DOWN || side == EnumFacing.UP ? this.topbotSlots : this.sideSlots;
    }

    public boolean func_180462_a(int slot, @Nonnull ItemStack item, EnumFacing side) {
        return (side == EnumFacing.DOWN || side == EnumFacing.UP) && this.func_94041_b(slot, item);
    }

    public boolean func_180461_b(int slot, @Nonnull ItemStack item, EnumFacing side) {
        return true;
    }

    public void increaseFuel(int val) {
        this.fuelLevel += (float)val;
        if (this.fuelLevel > (float)this.getMaxFuelLevel()) {
            this.fuelLevel = this.getMaxFuelLevel();
        }
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
    }
}

