/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.blocks;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import vswe.stevescarts.StevesCarts;
import vswe.stevescarts.blocks.BlockActivator;
import vswe.stevescarts.blocks.BlockCargoManager;
import vswe.stevescarts.blocks.BlockCartAssembler;
import vswe.stevescarts.blocks.BlockDetector;
import vswe.stevescarts.blocks.BlockDistributor;
import vswe.stevescarts.blocks.BlockLiquidManager;
import vswe.stevescarts.blocks.BlockMetalStorage;
import vswe.stevescarts.blocks.BlockRailAdvDetector;
import vswe.stevescarts.blocks.BlockRailJunction;
import vswe.stevescarts.blocks.BlockUpgrade;
import vswe.stevescarts.blocks.tileentities.TileEntityActivator;
import vswe.stevescarts.blocks.tileentities.TileEntityCargo;
import vswe.stevescarts.blocks.tileentities.TileEntityCartAssembler;
import vswe.stevescarts.blocks.tileentities.TileEntityDetector;
import vswe.stevescarts.blocks.tileentities.TileEntityDistributor;
import vswe.stevescarts.blocks.tileentities.TileEntityLiquid;
import vswe.stevescarts.blocks.tileentities.TileEntityUpgrade;

@Mod.EventBusSubscriber(modid="stevescarts")
public enum ModBlocks {
    CART_ASSEMBLER("BlockCartAssembler", BlockCartAssembler.class, TileEntityCartAssembler.class, "assembler"),
    CARGO_MANAGER("BlockCargoManager", BlockCargoManager.class, TileEntityCargo.class, "cargo"),
    LIQUID_MANAGER("BlockLiquidManager", BlockLiquidManager.class, TileEntityLiquid.class, "liquid"),
    EXTERNAL_DISTRIBUTOR("BlockDistributor", BlockDistributor.class, TileEntityDistributor.class, "distributor"),
    MODULE_TOGGLER("BlockActivator", BlockActivator.class, TileEntityActivator.class, "activator"),
    DETECTOR_UNIT("BlockDetector", BlockDetector.class, TileEntityDetector.class, "detector"),
    UPGRADE("upgrade", BlockUpgrade.class, TileEntityUpgrade.class, "upgrade"),
    JUNCTION("BlockJunction", BlockRailJunction.class),
    ADVANCED_DETECTOR("BlockAdvDetector", BlockRailAdvDetector.class),
    STORAGE("BlockMetalStorage", BlockMetalStorage.class);

    public static final List<ItemBlock> ITEM_BLOCKS;
    private final String name;
    private final Class<? extends Block> clazz;
    private final Class<? extends TileEntity> tileEntityClazz;
    private final String tileEntityName;
    private Block block;

    private ModBlocks(String name, Class<? extends Block> clazz) {
        this(name, clazz, null, null);
    }

    private ModBlocks(String name, Class<? extends Block> clazz, Class<? extends TileEntity> tileEntityClazz, String tileEntityName) {
        this.name = name;
        this.clazz = clazz;
        this.tileEntityClazz = tileEntityClazz;
        this.tileEntityName = tileEntityName;
    }

    public static void preInit() {
        for (ModBlocks info : ModBlocks.values()) {
            try {
                if (Block.class.isAssignableFrom(info.clazz)) {
                    Block block = info.clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                    block.func_149711_c(2.0f);
                    ((Block)block.setRegistryName("stevescarts", info.name.toLowerCase())).func_149663_c("SC2:" + info.name);
                    info.block = block;
                    ItemBlock item = block instanceof ICustomItemBlock ? ((ICustomItemBlock)block).getItemBlock() : new ItemBlock(block);
                    ITEM_BLOCKS.add(item);
                    ((Item)item.setRegistryName("stevescarts:" + info.name)).func_77655_b("stevescarts:" + info.name);
                    if (info.tileEntityClazz == null) continue;
                    GameRegistry.registerTileEntity(info.tileEntityClazz, (String)info.tileEntityName);
                    continue;
                }
                StevesCarts.logger.error("This is not a block (" + info.name + ")");
            }
            catch (Exception e) {
                StevesCarts.logger.error("Failed to create block (" + info.name + ")");
                StevesCarts.logger.throwing((Throwable)e);
            }
        }
    }

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        for (ModBlocks info : ModBlocks.values()) {
            registry.register((IForgeRegistryEntry)info.block);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void registerBlockRenderers(ModelRegistryEvent event) {
        for (ModBlocks info : ModBlocks.values()) {
            ICustomItemBlock customItemBlock;
            ItemStack renderedItem;
            Block block = info.block;
            if (block instanceof IStateMappedBlock) {
                StateMap.Builder builder = new StateMap.Builder();
                ((IStateMappedBlock)block).setStateMapper(builder);
                ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)builder.func_178441_a());
            }
            if (block instanceof ICustomItemBlock && !(renderedItem = (customItemBlock = (ICustomItemBlock)block).getRenderedItem()).func_190926_b()) {
                Map<Integer, ResourceLocation> map = StevesCarts.proxy.getItemModelMap(renderedItem.func_77973_b());
                ModelResourceLocation model = (ModelResourceLocation)map.get(renderedItem.func_77960_j());
                ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)block), (int)0, (ModelResourceLocation)model);
                continue;
            }
            ResourceLocation name = block.getRegistryName();
            if (block instanceof ISubtypeItemBlockModelDefinition) {
                ISubtypeItemBlockModelDefinition subtypeBlock = (ISubtypeItemBlockModelDefinition)block;
                for (int i = 0; i < subtypeBlock.getSubtypeNumber(); ++i) {
                    int meta = subtypeBlock.getSubtypeMeta(i);
                    ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)block), (int)meta, (ModelResourceLocation)new ModelResourceLocation(name.func_110624_b() + ":" + String.format(subtypeBlock.getSubtypeName(meta), name.func_110623_a()), "inventory"));
                }
                continue;
            }
            ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)block), (int)0, (ModelResourceLocation)new ModelResourceLocation(name, "inventory"));
        }
    }

    public Block getBlock() {
        return this.block;
    }

    static {
        ITEM_BLOCKS = new ArrayList<ItemBlock>();
    }

    public static interface ICustomItemBlock {
        public ItemBlock getItemBlock();

        @SideOnly(value=Side.CLIENT)
        default public ItemStack getRenderedItem() {
            return ItemStack.field_190927_a;
        }
    }

    public static interface IStateMappedBlock {
        @SideOnly(value=Side.CLIENT)
        public void setStateMapper(StateMap.Builder var1);
    }

    public static interface ISubtypeItemBlockModelDefinition {
        public int getSubtypeNumber();

        public String getSubtypeName(int var1);

        default public int getSubtypeMeta(int subtype) {
            return subtype;
        }
    }
}

