/*
 * Decompiled with CFR 0.152.
 */
package vswe.stevescarts.arcade.monopoly;

import java.util.EnumSet;
import net.minecraft.client.renderer.GlStateManager;
import vswe.stevescarts.arcade.monopoly.ArcadeMonopoly;
import vswe.stevescarts.arcade.monopoly.Piece;
import vswe.stevescarts.guis.GuiMinecart;

public class Place {
    protected ArcadeMonopoly game;

    public Place(ArcadeMonopoly game) {
        this.game = game;
    }

    protected int getTextureId() {
        return -1;
    }

    public void draw(GuiMinecart gui, EnumSet<PLACE_STATE> states) {
        int v;
        int u;
        int t;
        if (this.getTextureId() == -1) {
            t = 1;
            u = 0;
            v = 0;
        } else {
            t = 3 + this.getTextureId() / 6;
            u = this.getTextureId() % 3;
            v = this.getTextureId() % 6 / 3;
        }
        this.game.loadTexture(gui, t);
        this.applyColorFilter(gui, states);
        this.game.getModule().drawImage(gui, 0, 0, 76 * u, 122 * v, 76, 122);
    }

    public void applyColorFilter(GuiMinecart gui, EnumSet<PLACE_STATE> states) {
        if (states.contains((Object)PLACE_STATE.SELECTED)) {
            if (states.contains((Object)PLACE_STATE.HOVER)) {
                GlStateManager.func_179131_c((float)1.0f, (float)0.8f, (float)0.5f, (float)1.0f);
            } else {
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)0.75f, (float)1.0f);
            }
        } else if (states.contains((Object)PLACE_STATE.MARKED)) {
            if (states.contains((Object)PLACE_STATE.HOVER)) {
                GlStateManager.func_179131_c((float)1.0f, (float)0.75f, (float)1.0f, (float)1.0f);
            } else {
                GlStateManager.func_179131_c((float)1.0f, (float)0.85f, (float)0.85f, (float)1.0f);
            }
        } else if (states.contains((Object)PLACE_STATE.HOVER)) {
            GlStateManager.func_179131_c((float)0.9f, (float)0.9f, (float)1.0f, (float)1.0f);
        }
    }

    public void drawText(GuiMinecart gui, EnumSet<PLACE_STATE> states) {
    }

    public void drawPiece(GuiMinecart gui, Piece piece, int total, int pos, int area, EnumSet<PLACE_STATE> states) {
        int offSet;
        int startX;
        int fullWidth;
        int SIZE = 24;
        int PADDING = 5;
        int MARGIN = 2;
        int allowedWidth = this.getAllowedWidth(area) - 10;
        if (allowedWidth < (fullWidth = total * 26 - 2) && total > 1) {
            startX = 5;
            offSet = (allowedWidth - 24) / (total - 1);
        } else {
            startX = 5 + (allowedWidth - fullWidth) / 2;
            offSet = 26;
        }
        this.game.getModule().drawImage(gui, startX + offSet * pos, this.getPieceYPosition(area), 232, piece.getV() * 24, 24, 24);
    }

    protected int getPieceYPosition(int area) {
        return 70;
    }

    protected int getAllowedWidth(int area) {
        return 76;
    }

    public void onPiecePass(Piece piece) {
    }

    public boolean onPieceStop(Piece piece) {
        return true;
    }

    public void onClick() {
    }

    public int getPieceAreaCount() {
        return 1;
    }

    public int getPieceAreaForPiece(Piece piece) {
        return 0;
    }

    public static enum PLACE_STATE {
        HOVER,
        SELECTED,
        MARKED,
        ZOOMED;

    }
}

