/*
 * Decompiled with CFR 0.152.
 */
package org.magicwerk.brownies.collections.primitive;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.magicwerk.brownies.collections.helper.primitive.CharBinarySearch;
import org.magicwerk.brownies.collections.helper.primitive.CharMergeSort;
import org.magicwerk.brownies.collections.primitive.CharGapList;
import org.magicwerk.brownies.collections.primitive.ICharList;

public class CharBigList
extends ICharList {
    private static final long serialVersionUID = 3715838828540564836L;
    private static final int DEFAULT_BLOCK_SIZE = 1000;
    private static final float MERGE_THRESHOLD = 0.35f;
    private static final float FILL_THRESHOLD = 0.95f;
    private static final boolean CHECK = false;
    private static final CharBigList EMPTY = CharBigList.create().unmodifiableList();
    private int blockSize;
    private int size;
    private CharBlockNode rootNode;
    private CharBlockNode currNode;
    private int currCharBlockStart;
    private int currCharBlockEnd;
    private int currModify;

    public static ICharList of(char[] values2) {
        return new ImmutableCharListArrayPrimitive(values2);
    }

    public static ICharList of(Character[] values2) {
        return new ImmutableCharListArrayWrapper(values2);
    }

    public static ICharList of(List<Character> values2) {
        return new ImmutableCharListList(values2);
    }

    public static CharBigList EMPTY() {
        return EMPTY;
    }

    protected CharBigList(boolean copy2, CharBigList that) {
        if (copy2) {
            this.blockSize = that.blockSize;
            this.currCharBlockStart = that.currCharBlockStart;
            this.currCharBlockEnd = that.currCharBlockEnd;
            this.currNode = that.currNode;
            this.rootNode = that.rootNode;
            this.size = that.size;
        }
    }

    public static CharBigList create() {
        return new CharBigList();
    }

    public static CharBigList create(Collection<Character> coll) {
        return new CharBigList(coll);
    }

    public static CharBigList create(char ... elems) {
        CharBigList list2 = new CharBigList();
        for (char elem : elems) {
            list2.add(elem);
        }
        return list2;
    }

    public CharBigList() {
        this(1000);
    }

    public CharBigList(int blockSize) {
        if (blockSize < 2) {
            throw new IndexOutOfBoundsException("Invalid blockSize: " + blockSize);
        }
        this.doInit(blockSize, -1);
    }

    public CharBigList(Collection<Character> coll) {
        if (coll instanceof CharBigList) {
            this.doAssign((CharBigList)((Object)coll));
            this.doClone((CharBigList)((Object)coll));
        } else {
            this.blockSize = 1000;
            this.addCharBlock(0, new CharBlock());
            for (Object obj : coll.toArray()) {
                this.add(((Character)obj).charValue());
            }
            assert (this.size() == coll.size());
        }
    }

    public int blockSize() {
        return this.blockSize;
    }

    private CharBigList(int blockSize, int firstCharBlockSize) {
        this.doInit(blockSize, firstCharBlockSize);
    }

    private void doInit(int blockSize, int firstCharBlockSize) {
        this.blockSize = blockSize;
        CharBlock block = firstCharBlockSize <= 1 ? new CharBlock() : new CharBlock(firstCharBlockSize);
        this.addCharBlock(0, block);
    }

    @Override
    public CharBigList copy() {
        return (CharBigList)super.copy();
    }

    @Override
    public Object clone() {
        return super.clone();
    }

    @Override
    protected void doAssign(ICharList that) {
        CharBigList list2 = (CharBigList)that;
        this.blockSize = list2.blockSize;
        this.currCharBlockEnd = list2.currCharBlockEnd;
        this.currCharBlockStart = list2.currCharBlockStart;
        this.currNode = list2.currNode;
        this.rootNode = list2.rootNode;
        this.size = list2.size;
    }

    @Override
    protected void doClone(ICharList that) {
        CharBigList bigList = (CharBigList)that;
        bigList.releaseCharBlock();
        this.rootNode = this.copy(bigList.rootNode);
        this.currNode = null;
        this.currModify = 0;
    }

    private CharBlockNode copy(CharBlockNode node) {
        CharBlockNode newNode = node.min();
        int index = newNode.block.size();
        CharBlockNode newRoot = new CharBlockNode(null, index, newNode.block.ref(), null, null);
        while ((newNode = newNode.next()) != null) {
            newRoot = newRoot.insert(index += newNode.block.size(), newNode.block.ref());
            newRoot.parent = null;
        }
        return newRoot;
    }

    @Override
    public char getDefaultElem() {
        return '\u0000';
    }

    protected void finalize() {
        CharBlockNode node = this.rootNode.min();
        while (node != null) {
            node.block.unref();
            node = node.next();
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int capacity() {
        return -1;
    }

    @Override
    protected char doGet(int index) {
        int pos2 = this.getCharBlockIndex(index, false, 0);
        return this.currNode.block.doGet(pos2);
    }

    @Override
    protected char doSet(int index, char elem) {
        int pos2 = this.getCharBlockIndex(index, true, 0);
        char oldElem = this.currNode.block.doGet(pos2);
        this.currNode.block.doSet(pos2, elem);
        return oldElem;
    }

    @Override
    protected char doReSet(int index, char elem) {
        int pos2 = this.getCharBlockIndex(index, true, 0);
        char oldElem = this.currNode.block.doGet(pos2);
        this.currNode.block.doSet(pos2, elem);
        return oldElem;
    }

    private void releaseCharBlock() {
        if (this.currModify != 0) {
            int modify = this.currModify;
            this.currModify = 0;
            this.modify(this.currNode, modify);
        }
        this.currNode = null;
    }

    private int getCharBlockIndex(int index, boolean write, int modify) {
        if (this.currNode != null) {
            if (index >= this.currCharBlockStart && (index < this.currCharBlockEnd || index == this.currCharBlockEnd && this.size == index)) {
                if (write && this.currNode.block.isShared()) {
                    this.currNode.block.unref();
                    this.currNode.setCharBlock(new CharBlock(this.currNode.block));
                }
                this.currModify += modify;
                return index - this.currCharBlockStart;
            }
            this.releaseCharBlock();
        }
        if (index == this.size) {
            if (this.currNode == null || this.currCharBlockEnd != this.size) {
                this.currNode = this.rootNode.max();
                this.currCharBlockEnd = this.size;
                this.currCharBlockStart = this.size - this.currNode.block.size();
            }
            if (modify != 0) {
                this.currNode.relPos += modify;
                CharBlockNode leftNode = this.currNode.getLeftSubTree();
                if (leftNode != null) {
                    leftNode.relPos -= modify;
                }
            }
        } else if (index == 0) {
            if (this.currNode == null || this.currCharBlockStart != 0) {
                this.currNode = this.rootNode.min();
                this.currCharBlockEnd = this.currNode.block.size();
                this.currCharBlockStart = 0;
            }
            if (modify != 0) {
                this.rootNode.relPos += modify;
            }
        }
        if (this.currNode == null) {
            this.doGetCharBlock(index, modify);
        }
        assert (index >= this.currCharBlockStart && index <= this.currCharBlockEnd);
        if (write && this.currNode.block.isShared()) {
            this.currNode.block.unref();
            this.currNode.setCharBlock(new CharBlock(this.currNode.block));
        }
        return index - this.currCharBlockStart;
    }

    private boolean isOnlyRootCharBlock() {
        return this.rootNode.left == null && this.rootNode.right == null;
    }

    private void doGetCharBlock(int index, int modify) {
        this.currNode = this.rootNode;
        this.currCharBlockEnd = this.rootNode.relPos;
        if (this.currNode.relPos == 0) {
            if (modify != 0) {
                this.currNode.relPos += modify;
            }
        } else {
            boolean wasLeft = false;
            while (true) {
                CharBlockNode nextNode;
                assert (index >= 0);
                int leftIndex = this.currCharBlockEnd - this.currNode.block.size();
                assert (leftIndex >= 0);
                if (index >= leftIndex && index < this.currCharBlockEnd) {
                    if (modify == 0) break;
                    CharBlockNode leftNode = this.currNode.getLeftSubTree();
                    if (this.currNode.relPos > 0) {
                        this.currNode.relPos += modify;
                        if (leftNode == null) break;
                        leftNode.relPos -= modify;
                        break;
                    }
                    if (leftNode == null) break;
                    leftNode.relPos -= modify;
                    break;
                }
                if (index < this.currCharBlockEnd) {
                    nextNode = this.currNode.getLeftSubTree();
                    if (!(modify == 0 || nextNode != null && wasLeft)) {
                        this.currNode.relPos = this.currNode.relPos > 0 ? (this.currNode.relPos += modify) : (this.currNode.relPos -= modify);
                        wasLeft = true;
                    }
                    if (nextNode == null) {
                        break;
                    }
                } else {
                    nextNode = this.currNode.getRightSubTree();
                    if (modify != 0 && (nextNode == null || wasLeft)) {
                        if (this.currNode.relPos > 0) {
                            this.currNode.relPos += modify;
                            CharBlockNode left = this.currNode.getLeftSubTree();
                            if (left != null) {
                                left.relPos -= modify;
                            }
                        } else {
                            this.currNode.relPos -= modify;
                        }
                        wasLeft = false;
                    }
                    if (nextNode == null) break;
                }
                this.currCharBlockEnd += nextNode.relPos;
                this.currNode = nextNode;
            }
        }
        this.currCharBlockStart = this.currCharBlockEnd - this.currNode.block.size();
    }

    private void addCharBlock(int index, CharBlock obj) {
        if (this.rootNode == null) {
            this.rootNode = new CharBlockNode(null, index, obj, null, null);
        } else {
            this.rootNode = this.rootNode.insert(index, obj);
            this.rootNode.parent = null;
        }
    }

    @Override
    protected boolean doAdd(int index, char element) {
        int maxSize;
        if (index == -1) {
            index = this.size;
        }
        int pos2 = this.getCharBlockIndex(index, true, 1);
        int n = maxSize = index == this.size || index == 0 ? (int)((float)this.blockSize * 0.95f) : this.blockSize;
        if (this.currNode.block.size() < maxSize || this.currNode.block.size() == 1 && this.currNode.block.size() < this.blockSize) {
            this.currNode.block.doAdd(pos2, element);
            ++this.currCharBlockEnd;
        } else {
            CharBlock newCharBlock = new CharBlock(this.blockSize);
            if (index == this.size) {
                CharBlockNode lastNode;
                newCharBlock.doAdd(0, element);
                this.modify(this.currNode, -1);
                this.addCharBlock(this.size + 1, newCharBlock);
                this.currNode = lastNode = this.currNode.next();
                this.currCharBlockStart = this.currCharBlockEnd++;
            } else if (index == 0) {
                CharBlockNode firstNode;
                newCharBlock.doAdd(0, element);
                this.modify(this.currNode, -1);
                this.addCharBlock(1, newCharBlock);
                this.currNode = firstNode = this.currNode.previous();
                this.currCharBlockStart = 0;
                this.currCharBlockEnd = 1;
            } else {
                int nextCharBlockLen = this.blockSize / 2;
                int blockLen = this.blockSize - nextCharBlockLen;
                CharGapList.transferRemove(this.currNode.block, blockLen, nextCharBlockLen, newCharBlock, 0, 0);
                this.modify(this.currNode, -nextCharBlockLen - 1);
                this.addCharBlock(this.currCharBlockEnd - nextCharBlockLen, newCharBlock);
                if (pos2 < blockLen) {
                    this.currNode.block.doAdd(pos2, element);
                    this.currCharBlockEnd = this.currCharBlockStart + blockLen + 1;
                    this.modify(this.currNode, 1);
                } else {
                    this.currNode = this.currNode.next();
                    this.modify(this.currNode, 1);
                    this.currNode.block.doAdd(pos2 - blockLen, element);
                    this.currCharBlockStart += blockLen;
                    ++this.currCharBlockEnd;
                }
            }
        }
        ++this.size;
        return true;
    }

    private void modify(CharBlockNode node, int modify) {
        if (node == this.currNode) {
            modify += this.currModify;
            this.currModify = 0;
        } else {
            this.releaseCharBlock();
        }
        if (modify == 0) {
            return;
        }
        if (node.relPos < 0) {
            CharBlockNode p;
            CharBlockNode leftNode = node.getLeftSubTree();
            if (leftNode != null) {
                leftNode.relPos -= modify;
            }
            CharBlockNode pp = node.parent;
            assert (pp.getLeftSubTree() == node);
            boolean parentRight = true;
            while ((p = pp.parent) != null) {
                boolean pRight;
                boolean bl = pRight = p.getLeftSubTree() == pp;
                if (parentRight != pRight) {
                    pp.relPos = pp.relPos > 0 ? (pp.relPos += modify) : (pp.relPos -= modify);
                }
                pp = p;
                parentRight = pRight;
            }
            if (parentRight) {
                this.rootNode.relPos += modify;
            }
        } else {
            CharBlockNode parent2;
            node.relPos += modify;
            CharBlockNode leftNode = node.getLeftSubTree();
            if (leftNode != null) {
                leftNode.relPos -= modify;
            }
            if ((parent2 = node.parent) != null) {
                CharBlockNode p;
                assert (parent2.getRightSubTree() == node);
                boolean parentLeft = true;
                while ((p = parent2.parent) != null) {
                    boolean pLeft;
                    boolean bl = pLeft = p.getRightSubTree() == parent2;
                    if (parentLeft != pLeft) {
                        parent2.relPos = parent2.relPos > 0 ? (parent2.relPos += modify) : (parent2.relPos -= modify);
                    }
                    parent2 = p;
                    parentLeft = pLeft;
                }
                if (!parentLeft) {
                    this.rootNode.relPos += modify;
                }
            }
        }
    }

    private CharBlockNode doRemove(CharBlockNode node) {
        CharBlockNode newNode;
        CharBlockNode p = node.parent;
        CharBlockNode n = newNode = node.removeSelf();
        while (p != null) {
            assert (p.left == node || p.right == node);
            if (p.left == node) {
                p.left = newNode;
            } else {
                p.right = newNode;
            }
            node = p;
            node.recalcHeight();
            newNode = node.balance();
            p = newNode.parent;
        }
        this.rootNode = newNode;
        return n;
    }

    @Override
    protected boolean doAddAll(int index, ICharList list2) {
        if (list2.size() == 0) {
            return false;
        }
        if (index == -1) {
            index = this.size;
        }
        int oldSize = this.size;
        if (list2.size() == 1) {
            return this.doAdd(index, list2.get(0));
        }
        int addPos = this.getCharBlockIndex(index, true, 0);
        CharBlock addCharBlock = this.currNode.block;
        int space = this.blockSize - addCharBlock.size();
        int addLen = list2.size();
        if (addLen <= space) {
            this.currNode.block.addAll(addPos, list2);
            this.modify(this.currNode, addLen);
            this.size += addLen;
            this.currCharBlockEnd += addLen;
        } else if (index == this.size) {
            int add;
            for (int i = 0; i < space; ++i) {
                this.currNode.block.add(addPos + i, list2.get(i));
            }
            this.modify(this.currNode, space);
            int done = space;
            for (int todo = addLen - space; todo > 0; todo -= add) {
                CharBlock nextCharBlock = new CharBlock(this.blockSize);
                add = Math.min(todo, this.blockSize);
                for (int i = 0; i < add; ++i) {
                    nextCharBlock.add(i, list2.get(done + i));
                }
                this.addCharBlock(this.size + (done += add), nextCharBlock);
                this.currNode = this.currNode.next();
            }
            this.size += addLen;
            this.currCharBlockEnd = this.size;
            this.currCharBlockStart = this.currCharBlockEnd - this.currNode.block.size();
        } else if (index == 0) {
            int add;
            assert (addPos == 0);
            for (int i = 0; i < space; ++i) {
                this.currNode.block.add(addPos + i, list2.get(addLen - space + i));
            }
            this.modify(this.currNode, space);
            int done = space;
            for (int todo = addLen - space; todo > 0; todo -= add) {
                CharBlock nextCharBlock = new CharBlock(this.blockSize);
                add = Math.min(todo, this.blockSize);
                for (int i = 0; i < add; ++i) {
                    nextCharBlock.add(i, list2.get(addLen - done - add + i));
                }
                done += add;
                this.addCharBlock(0, nextCharBlock);
                this.currNode = this.currNode.previous();
            }
            this.size += addLen;
            this.currCharBlockStart = 0;
            this.currCharBlockEnd = this.currNode.block.size();
        } else {
            CharGapList sublist;
            int add;
            CharGapList list22 = CharGapList.create();
            list22.addAll(list2);
            int remove = this.currNode.block.size() - addPos;
            if (remove > 0) {
                list22.addAll(this.currNode.block.getAll(addPos, remove));
                this.currNode.block.remove(addPos, remove);
                this.modify(this.currNode, -remove);
                this.size -= remove;
                this.currCharBlockEnd -= remove;
            }
            int numElems = this.currNode.block.size() + list22.size();
            int numCharBlocks = (numElems - 1) / this.blockSize + 1;
            assert (numCharBlocks > 1);
            int has = this.currNode.block.size();
            int should = numElems / numCharBlocks;
            int listPos = 0;
            if (has < should) {
                add = should - has;
                sublist = list22.getAll(0, add);
                listPos += add;
                this.currNode.block.addAll(addPos, sublist);
                this.modify(this.currNode, add);
                assert (this.currNode.block.size() == should);
                numElems -= should;
                --numCharBlocks;
                this.size += add;
                this.currCharBlockEnd += add;
            } else if (has > should) {
                CharBlock nextCharBlock = new CharBlock(this.blockSize);
                int move = has - should;
                nextCharBlock.addAll(this.currNode.block.getAll(this.currNode.block.size() - move, move));
                this.currNode.block.remove(this.currNode.block.size() - move, move);
                this.modify(this.currNode, -move);
                assert (this.currNode.block.size() == should);
                numElems -= should;
                this.currCharBlockEnd -= move;
                should = numElems / --numCharBlocks;
                int add2 = should - move;
                assert (add2 >= 0);
                CharGapList sublist2 = list22.getAll(0, add2);
                nextCharBlock.addAll(move, sublist2);
                listPos += add2;
                assert (nextCharBlock.size() == should);
                numElems -= should;
                --numCharBlocks;
                this.size += add2;
                this.addCharBlock(this.currCharBlockEnd, nextCharBlock);
                this.currNode = this.currNode.next();
                assert (this.currNode.block == nextCharBlock);
                assert (this.currNode.block.size() == add2 + move);
                this.currCharBlockStart = this.currCharBlockEnd;
                this.currCharBlockEnd += add2 + move;
            } else {
                numElems -= should;
                --numCharBlocks;
            }
            while (numCharBlocks > 0) {
                add = numElems / numCharBlocks;
                assert (add > 0);
                sublist = list22.getAll(listPos, add);
                listPos += add;
                CharBlock nextCharBlock = new CharBlock();
                nextCharBlock.addAll(sublist);
                assert (nextCharBlock.size() == add);
                numElems -= add;
                this.addCharBlock(this.currCharBlockEnd, nextCharBlock);
                this.currNode = this.currNode.next();
                assert (this.currNode.block == nextCharBlock);
                assert (this.currNode.block.size() == add);
                this.currCharBlockStart = this.currCharBlockEnd;
                this.currCharBlockEnd += add;
                this.size += add;
                --numCharBlocks;
            }
        }
        assert (oldSize + addLen == this.size);
        return true;
    }

    @Override
    protected void doClear() {
        this.finalize();
        this.rootNode = null;
        this.currCharBlockStart = 0;
        this.currCharBlockEnd = 0;
        this.currModify = 0;
        this.currNode = null;
        this.size = 0;
        this.doInit(this.blockSize, 0);
    }

    @Override
    protected void doRemoveAll(int index, int len) {
        if (len == 0) {
            return;
        }
        if (index == 0 && len == this.size) {
            this.doClear();
            return;
        }
        if (len == 1) {
            this.doRemove(index);
            return;
        }
        int startPos = this.getCharBlockIndex(index, true, 0);
        CharBlockNode startNode = this.currNode;
        int endPos = this.getCharBlockIndex(index + len - 1, true, 0);
        CharBlockNode endNode = this.currNode;
        if (startNode == endNode) {
            this.getCharBlockIndex(index, true, -len);
            this.currNode.block.remove(startPos, len);
            if (this.currNode.block.isEmpty()) {
                CharBlockNode oldCurrNode = this.currNode;
                this.releaseCharBlock();
                CharBlockNode node = this.doRemove(oldCurrNode);
                this.merge(node);
            } else {
                this.currCharBlockEnd -= len;
                this.merge(this.currNode);
            }
            this.size -= len;
        } else {
            int startLen = startNode.block.size() - startPos;
            this.getCharBlockIndex(index, true, -startLen);
            startNode.block.remove(startPos, startLen);
            assert (startNode == this.currNode);
            if (this.currNode.block.isEmpty()) {
                this.releaseCharBlock();
                this.doRemove(startNode);
                startNode = null;
            }
            len -= startLen;
            this.size -= startLen;
            while (len > 0) {
                this.currNode = null;
                this.getCharBlockIndex(index, true, 0);
                int s = this.currNode.block.size();
                if (s <= len) {
                    this.modify(this.currNode, -s);
                    CharBlockNode oldCurrNode = this.currNode;
                    this.releaseCharBlock();
                    this.doRemove(oldCurrNode);
                    if (oldCurrNode == endNode) {
                        endNode = null;
                    }
                    len -= s;
                    this.size -= s;
                    continue;
                }
                this.modify(this.currNode, -len);
                this.currNode.block.remove(0, len);
                this.size -= len;
                break;
            }
            this.releaseCharBlock();
            this.getCharBlockIndex(index, false, 0);
            this.merge(this.currNode);
        }
    }

    private void merge(CharBlockNode node) {
        if (node == null) {
            return;
        }
        int minCharBlockSize = Math.max((int)((float)this.blockSize * 0.35f), 1);
        if (node.block.size() >= minCharBlockSize) {
            return;
        }
        CharBlockNode oldCurrNode = node;
        CharBlockNode leftNode = node.previous();
        if (leftNode != null && leftNode.block.size() < minCharBlockSize) {
            int len = node.block.size();
            int dstSize = leftNode.getCharBlock().size();
            for (int i = 0; i < len; ++i) {
                leftNode.block.add('\u0000');
            }
            CharGapList.transferCopy(node.block, 0, len, leftNode.block, dstSize, len);
            assert (leftNode.block.size() <= this.blockSize);
            this.modify(leftNode, len);
            this.modify(oldCurrNode, -len);
            this.releaseCharBlock();
            this.doRemove(oldCurrNode);
        } else {
            CharBlockNode rightNode = node.next();
            if (rightNode != null && rightNode.block.size() < minCharBlockSize) {
                int len = node.block.size();
                for (int i = 0; i < len; ++i) {
                    rightNode.block.add(0, '\u0000');
                }
                CharGapList.transferCopy(node.block, 0, len, rightNode.block, 0, len);
                assert (rightNode.block.size() <= this.blockSize);
                this.modify(rightNode, len);
                this.modify(oldCurrNode, -len);
                this.releaseCharBlock();
                this.doRemove(oldCurrNode);
            }
        }
    }

    @Override
    protected char doRemove(int index) {
        int pos2 = this.getCharBlockIndex(index, true, -1);
        char oldElem = this.currNode.block.doRemove(pos2);
        --this.currCharBlockEnd;
        int minCharBlockSize = Math.max(this.blockSize / 3, 1);
        if (this.currNode.block.size() < minCharBlockSize) {
            if (this.currNode.block.size() == 0) {
                if (!this.isOnlyRootCharBlock()) {
                    CharBlockNode oldCurrNode = this.currNode;
                    this.releaseCharBlock();
                    this.doRemove(oldCurrNode);
                }
            } else if (index != 0 && index != this.size - 1) {
                this.merge(this.currNode);
            }
        }
        --this.size;
        return oldElem;
    }

    @Override
    public CharBigList unmodifiableList() {
        return new ImmutableCharBigList(this);
    }

    @Override
    protected void doEnsureCapacity(int minCapacity) {
        if (this.isOnlyRootCharBlock()) {
            if (minCapacity > this.blockSize) {
                minCapacity = this.blockSize;
            }
            this.rootNode.block.doEnsureCapacity(minCapacity);
        }
    }

    @Override
    public void trimToSize() {
        this.doModify();
        if (this.isOnlyRootCharBlock()) {
            this.rootNode.block.trimToSize();
        } else {
            CharBigList newList = new CharBigList(this.blockSize);
            CharBlockNode node = this.rootNode.min();
            while (node != null) {
                newList.addAll(node.block);
                this.remove(0, node.block.size());
                node = node.next();
            }
            this.doAssign(newList);
        }
    }

    @Override
    protected ICharList doCreate(int capacity) {
        if (capacity <= this.blockSize) {
            return new CharBigList(this.blockSize);
        }
        return new CharBigList(this.blockSize, capacity);
    }

    @Override
    public void sort(int index, int len) {
        this.checkRange(index, len);
        if (this.isOnlyRootCharBlock()) {
            this.rootNode.block.sort(index, len);
        } else {
            CharMergeSort.sort(this, index, index + len);
        }
    }

    @Override
    public int binarySearch(int index, int len, char key) {
        this.checkRange(index, len);
        if (this.isOnlyRootCharBlock()) {
            return this.rootNode.block.binarySearch(key);
        }
        return CharBinarySearch.binarySearch(this, key, 0, this.size());
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.writeInt(this.blockSize);
        int size2 = this.size();
        oos.writeInt(size2);
        for (int i = 0; i < size2; ++i) {
            oos.writeChar(this.doGet(i));
        }
    }

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        int blockSize = ois.readInt();
        int size2 = ois.readInt();
        int firstCharBlockSize = size2 <= blockSize ? size2 : -1;
        this.doInit(blockSize, firstCharBlockSize);
        for (int i = 0; i < size2; ++i) {
            this.add(ois.readChar());
        }
    }

    private void checkNode(CharBlockNode node) {
        assert ((node.block.size() > 0 || node == this.rootNode) && node.block.size() <= this.blockSize);
        CharBlockNode child = node.getLeftSubTree();
        assert (child == null || child.parent == node);
        child = node.getRightSubTree();
        assert (child == null || child.parent == node);
    }

    private void checkHeight(CharBlockNode node) {
        CharBlockNode left = node.getLeftSubTree();
        CharBlockNode right = node.getRightSubTree();
        if (left == null) {
            if (right == null) {
                assert (node.height == 0);
            } else {
                assert (right.height == node.height - 1);
                this.checkHeight(right);
            }
        } else {
            if (right == null) {
                assert (left.height == node.height - 1);
            } else {
                assert (left.height == node.height - 1 || left.height == node.height - 2);
                assert (right.height == node.height - 1 || right.height == node.height - 2);
                assert (right.height == node.height - 1 || left.height == node.height - 1);
            }
            this.checkHeight(left);
        }
    }

    private void check() {
        if (this.currNode != null) {
            assert (this.currCharBlockStart >= 0 && this.currCharBlockEnd <= this.size && this.currCharBlockStart <= this.currCharBlockEnd);
            assert (this.currCharBlockStart + this.currNode.block.size() == this.currCharBlockEnd);
        }
        if (this.rootNode == null) {
            assert (this.size == 0);
            return;
        }
        this.checkHeight(this.rootNode);
        CharBlockNode oldCurrNode = this.currNode;
        int oldCurrModify = this.currModify;
        if (this.currModify != 0) {
            this.currNode = null;
            this.currModify = 0;
            this.modify(oldCurrNode, oldCurrModify);
        }
        CharBlockNode node = this.rootNode;
        this.checkNode(node);
        int index = node.relPos;
        while (node.left != null) {
            node = node.left;
            this.checkNode(node);
            assert (node.relPos < 0);
            index += node.relPos;
        }
        CharBlock block = node.getCharBlock();
        assert (block.size() == index);
        int lastIndex = index;
        while (lastIndex < this.size()) {
            node = this.rootNode;
            index = node.relPos;
            int searchIndex = lastIndex + 1;
            while (true) {
                this.checkNode(node);
                block = node.getCharBlock();
                assert (block.size() > 0);
                if (searchIndex > index - block.size() && searchIndex <= index) break;
                if (searchIndex < index) {
                    if (node.left == null || node.left.height >= node.height) break;
                    node = node.left;
                } else {
                    if (node.right == null || node.right.height >= node.height) break;
                    node = node.right;
                }
                index += node.relPos;
            }
            block = node.getCharBlock();
            assert (block.size() == index - lastIndex);
            lastIndex = index;
        }
        assert (index == this.size());
        if (oldCurrModify != 0) {
            this.modify(oldCurrNode, -oldCurrModify);
        }
        this.currNode = oldCurrNode;
        this.currModify = oldCurrModify;
    }

    public static CharBigList create(String str) {
        return new CharBigList(str);
    }

    public CharBigList(String str) {
        this.init(str);
    }

    public void init(String str) {
        char[] array = str.toCharArray();
        this.initArray(array);
    }

    protected static class ImmutableCharBigList
    extends CharBigList {
        private static final long serialVersionUID = -1352274047348922584L;

        protected ImmutableCharBigList(CharBigList that) {
            super(true, that);
        }

        @Override
        protected boolean doAdd(int index, char elem) {
            this.error();
            return false;
        }

        @Override
        protected char doSet(int index, char elem) {
            this.error();
            return '\u0000';
        }

        @Override
        protected char doReSet(int index, char elem) {
            this.error();
            return '\u0000';
        }

        @Override
        protected char doRemove(int index) {
            this.error();
            return '\u0000';
        }

        @Override
        protected void doRemoveAll(int index, int len) {
            this.error();
        }

        @Override
        protected void doClear() {
            this.error();
        }

        @Override
        protected void doModify() {
            this.error();
        }

        private void error() {
            throw new UnsupportedOperationException("list is immutable");
        }
    }

    static class CharBlockNode {
        CharBlockNode parent;
        CharBlockNode left;
        boolean leftIsPrevious;
        CharBlockNode right;
        boolean rightIsNext;
        int height;
        int relPos;
        CharBlock block;

        private CharBlockNode(CharBlockNode parent2, int relPos, CharBlock block, CharBlockNode rightFollower, CharBlockNode leftFollower) {
            this.parent = parent2;
            this.relPos = relPos;
            this.block = block;
            this.rightIsNext = true;
            this.leftIsPrevious = true;
            this.right = rightFollower;
            this.left = leftFollower;
        }

        private CharBlock getCharBlock() {
            return this.block;
        }

        private void setCharBlock(CharBlock block) {
            this.block = block;
        }

        private CharBlockNode next() {
            if (this.rightIsNext || this.right == null) {
                return this.right;
            }
            return this.right.min();
        }

        private CharBlockNode previous() {
            if (this.leftIsPrevious || this.left == null) {
                return this.left;
            }
            return this.left.max();
        }

        private CharBlockNode insert(int index, CharBlock obj) {
            assert (this.relPos != 0);
            int relIndex = index - this.relPos;
            if (relIndex < 0) {
                return this.insertOnLeft(relIndex, obj);
            }
            return this.insertOnRight(relIndex, obj);
        }

        private CharBlockNode insertOnLeft(int relIndex, CharBlock obj) {
            if (this.getLeftSubTree() == null) {
                int pos2 = this.relPos >= 0 ? -this.relPos : -this.block.size();
                this.setLeft(new CharBlockNode(this, pos2, obj, this, this.left), null);
            } else {
                this.setLeft(this.left.insert(relIndex, obj), null);
            }
            if (this.relPos >= 0) {
                this.relPos += obj.size();
            }
            CharBlockNode ret = this.balance();
            this.recalcHeight();
            return ret;
        }

        private CharBlockNode insertOnRight(int relIndex, CharBlock obj) {
            if (this.getRightSubTree() == null) {
                this.setRight(new CharBlockNode(this, obj.size(), obj, this.right, this), null);
            } else {
                this.setRight(this.right.insert(relIndex, obj), null);
            }
            if (this.relPos < 0) {
                this.relPos -= obj.size();
            }
            CharBlockNode ret = this.balance();
            this.recalcHeight();
            return ret;
        }

        private CharBlockNode getLeftSubTree() {
            return this.leftIsPrevious ? null : this.left;
        }

        private CharBlockNode getRightSubTree() {
            return this.rightIsNext ? null : this.right;
        }

        private CharBlockNode max() {
            return this.getRightSubTree() == null ? this : this.right.max();
        }

        private CharBlockNode min() {
            return this.getLeftSubTree() == null ? this : this.left.min();
        }

        private CharBlockNode removeMax() {
            if (this.getRightSubTree() == null) {
                return this.removeSelf();
            }
            this.setRight(this.right.removeMax(), this.right.right);
            this.recalcHeight();
            return this.balance();
        }

        private CharBlockNode removeMin(int size2) {
            if (this.getLeftSubTree() == null) {
                return this.removeSelf();
            }
            this.setLeft(this.left.removeMin(size2), this.left.left);
            if (this.relPos > 0) {
                this.relPos -= size2;
            }
            this.recalcHeight();
            return this.balance();
        }

        private CharBlockNode removeSelf() {
            CharBlockNode p = this.parent;
            CharBlockNode n = this.doRemoveSelf();
            if (n != null) {
                assert (p != n);
                n.parent = p;
            }
            return n;
        }

        private CharBlockNode doRemoveSelf() {
            if (this.getRightSubTree() == null && this.getLeftSubTree() == null) {
                return null;
            }
            if (this.getRightSubTree() == null) {
                this.left.relPos = this.relPos > 0 ? this.left.relPos + (this.relPos + (this.relPos > 0 ? 0 : 1)) : (this.left.relPos += this.relPos);
                this.left.max().setRight(null, this.right);
                return this.left;
            }
            if (this.getLeftSubTree() == null) {
                if (this.relPos < 0) {
                    this.right.relPos = this.right.relPos + (this.relPos - (this.relPos < 0 ? 0 : 1));
                }
                this.right.min().setLeft(null, this.left);
                return this.right;
            }
            if (this.heightRightMinusLeft() > 0) {
                CharBlockNode rightMin = this.right.min();
                this.block = rightMin.block;
                int bs = this.block.size();
                if (this.leftIsPrevious) {
                    this.left = rightMin.left;
                }
                this.right = this.right.removeMin(bs);
                this.relPos += bs;
                this.left.relPos -= bs;
            } else {
                CharBlockNode leftMax = this.left.max();
                this.block = leftMax.block;
                if (this.rightIsNext) {
                    this.right = leftMax.right;
                }
                CharBlockNode leftPrevious = this.left.left;
                this.left = this.left.removeMax();
                if (this.left == null) {
                    this.left = leftPrevious;
                    this.leftIsPrevious = true;
                } else if (this.left.relPos == 0) {
                    this.left.relPos = -1;
                }
            }
            this.recalcHeight();
            return this;
        }

        private CharBlockNode balance() {
            switch (this.heightRightMinusLeft()) {
                case -1: 
                case 0: 
                case 1: {
                    return this;
                }
                case -2: {
                    if (this.left.heightRightMinusLeft() > 0) {
                        this.setLeft(this.left.rotateLeft(), null);
                    }
                    return this.rotateRight();
                }
                case 2: {
                    if (this.right.heightRightMinusLeft() < 0) {
                        this.setRight(this.right.rotateRight(), null);
                    }
                    return this.rotateLeft();
                }
            }
            throw new RuntimeException("tree inconsistent!");
        }

        private int getOffset(CharBlockNode node) {
            if (node == null) {
                return 0;
            }
            return node.relPos;
        }

        private int setOffset(CharBlockNode node, int newOffest) {
            if (node == null) {
                return 0;
            }
            int oldOffset = this.getOffset(node);
            node.relPos = newOffest;
            return oldOffset;
        }

        private void recalcHeight() {
            this.height = Math.max(this.getLeftSubTree() == null ? -1 : this.getLeftSubTree().height, this.getRightSubTree() == null ? -1 : this.getRightSubTree().height) + 1;
        }

        private int getHeight(CharBlockNode node) {
            return node == null ? -1 : node.height;
        }

        private int heightRightMinusLeft() {
            return this.getHeight(this.getRightSubTree()) - this.getHeight(this.getLeftSubTree());
        }

        private CharBlockNode rotateLeft() {
            assert (!this.rightIsNext);
            CharBlockNode newTop = this.right;
            CharBlockNode movedNode = this.getRightSubTree().getLeftSubTree();
            int newTopPosition = this.relPos + this.getOffset(newTop);
            int myNewPosition = -newTop.relPos;
            int movedPosition = this.getOffset(newTop) + this.getOffset(movedNode);
            CharBlockNode p = this.parent;
            this.setRight(movedNode, newTop);
            newTop.setLeft(this, null);
            newTop.parent = p;
            this.parent = newTop;
            this.setOffset(newTop, newTopPosition);
            this.setOffset(this, myNewPosition);
            this.setOffset(movedNode, movedPosition);
            assert (newTop.getLeftSubTree() == null || newTop.getLeftSubTree().relPos < 0);
            assert (newTop.getRightSubTree() == null || newTop.getRightSubTree().relPos > 0);
            return newTop;
        }

        private CharBlockNode rotateRight() {
            assert (!this.leftIsPrevious);
            CharBlockNode newTop = this.left;
            CharBlockNode movedNode = this.getLeftSubTree().getRightSubTree();
            int newTopPosition = this.relPos + this.getOffset(newTop);
            int myNewPosition = -newTop.relPos;
            int movedPosition = this.getOffset(newTop) + this.getOffset(movedNode);
            CharBlockNode p = this.parent;
            this.setLeft(movedNode, newTop);
            newTop.setRight(this, null);
            newTop.parent = p;
            this.parent = newTop;
            this.setOffset(newTop, newTopPosition);
            this.setOffset(this, myNewPosition);
            this.setOffset(movedNode, movedPosition);
            assert (newTop.getLeftSubTree() == null || newTop.getLeftSubTree().relPos < 0);
            assert (newTop.getRightSubTree() == null || newTop.getRightSubTree().relPos > 0);
            return newTop;
        }

        private void setLeft(CharBlockNode node, CharBlockNode previous) {
            assert (node != this && previous != this);
            boolean bl = this.leftIsPrevious = node == null;
            if (this.leftIsPrevious) {
                this.left = previous;
            } else {
                this.left = node;
                this.left.parent = this;
            }
            this.recalcHeight();
        }

        private void setRight(CharBlockNode node, CharBlockNode next) {
            assert (node != this && next != this);
            boolean bl = this.rightIsNext = node == null;
            if (this.rightIsNext) {
                this.right = next;
            } else {
                this.right = node;
                this.right.parent = this;
            }
            this.recalcHeight();
        }

        public String toString() {
            return "CharBlockNode(" + this.relPos + ',' + (this.getRightSubTree() != null) + ',' + this.block + ',' + (this.getRightSubTree() != null) + ", height " + this.height + " )";
        }
    }

    static class CharBlock
    extends CharGapList {
        private AtomicInteger refCount = new AtomicInteger(1);

        public CharBlock() {
        }

        public CharBlock(int capacity) {
            super(capacity);
        }

        public CharBlock(CharBlock that) {
            super(that.capacity());
            this.addAll(that);
        }

        public boolean isShared() {
            return this.refCount.get() > 1;
        }

        public CharBlock ref() {
            this.refCount.incrementAndGet();
            return this;
        }

        public void unref() {
            this.refCount.decrementAndGet();
        }
    }

    protected static abstract class ImmutableCharList
    extends ICharList {
        protected ImmutableCharList() {
        }

        @Override
        public int capacity() {
            return this.size();
        }

        @Override
        public int binarySearch(int index, int len, char key) {
            return CharBinarySearch.binarySearch(this, key, index, index + len);
        }

        @Override
        public ICharList unmodifiableList() {
            return this;
        }

        @Override
        protected char getDefaultElem() {
            return '\u0000';
        }

        private void error() {
            throw new UnsupportedOperationException("list is immutable");
        }

        @Override
        protected void doRemoveAll(int index, int len) {
            this.error();
        }

        @Override
        protected void doClear() {
            this.error();
        }

        @Override
        protected void doModify() {
            this.error();
        }

        @Override
        protected void doClone(ICharList that) {
            this.error();
        }

        @Override
        protected char doSet(int index, char elem) {
            this.error();
            return '\u0000';
        }

        @Override
        protected char doReSet(int index, char elem) {
            this.error();
            return '\u0000';
        }

        @Override
        protected boolean doAdd(int index, char elem) {
            this.error();
            return false;
        }

        @Override
        protected void doEnsureCapacity(int minCapacity) {
            this.error();
        }

        @Override
        public void trimToSize() {
            this.error();
        }

        @Override
        protected ICharList doCreate(int capacity) {
            this.error();
            return null;
        }

        @Override
        protected void doAssign(ICharList that) {
            this.error();
        }

        @Override
        protected char doRemove(int index) {
            this.error();
            return '\u0000';
        }

        @Override
        public void sort(int index, int len) {
            this.error();
        }
    }

    static class ImmutableCharListList
    extends ImmutableCharList {
        List<Character> values;

        public ImmutableCharListList(List<Character> values2) {
            this.values = values2;
        }

        @Override
        public int size() {
            return this.values.size();
        }

        @Override
        protected char doGet(int index) {
            return this.values.get(index).charValue();
        }
    }

    static class ImmutableCharListArrayWrapper
    extends ImmutableCharList {
        Character[] values;

        public ImmutableCharListArrayWrapper(Character[] values2) {
            this.values = values2;
        }

        @Override
        public int size() {
            return this.values.length;
        }

        @Override
        protected char doGet(int index) {
            return this.values[index].charValue();
        }
    }

    static class ImmutableCharListArrayPrimitive
    extends ImmutableCharList {
        char[] values;

        public ImmutableCharListArrayPrimitive(char[] values2) {
            this.values = values2;
        }

        @Override
        public int size() {
            return this.values.length;
        }

        @Override
        protected char doGet(int index) {
            return this.values[index];
        }
    }
}

