/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.shade.icu.text;

import com.teamwizardry.librarianlib.shade.icu.impl.CharacterIteratorWrapper;
import com.teamwizardry.librarianlib.shade.icu.impl.ReplaceableUCharacterIterator;
import com.teamwizardry.librarianlib.shade.icu.impl.UCharArrayIterator;
import com.teamwizardry.librarianlib.shade.icu.impl.UCharacterIteratorWrapper;
import com.teamwizardry.librarianlib.shade.icu.text.Replaceable;
import com.teamwizardry.librarianlib.shade.icu.text.UForwardCharacterIterator;
import com.teamwizardry.librarianlib.shade.icu.text.UTF16;
import java.text.CharacterIterator;

public abstract class UCharacterIterator
implements Cloneable,
UForwardCharacterIterator {
    protected UCharacterIterator() {
    }

    public static final UCharacterIterator getInstance(Replaceable source) {
        return new ReplaceableUCharacterIterator(source);
    }

    public static final UCharacterIterator getInstance(String source) {
        return new ReplaceableUCharacterIterator(source);
    }

    public static final UCharacterIterator getInstance(char[] source) {
        return UCharacterIterator.getInstance(source, 0, source.length);
    }

    public static final UCharacterIterator getInstance(char[] source, int start, int limit) {
        return new UCharArrayIterator(source, start, limit);
    }

    public static final UCharacterIterator getInstance(StringBuffer source) {
        return new ReplaceableUCharacterIterator(source);
    }

    public static final UCharacterIterator getInstance(CharacterIterator source) {
        return new CharacterIteratorWrapper(source);
    }

    public CharacterIterator getCharacterIterator() {
        return new UCharacterIteratorWrapper(this);
    }

    public abstract int current();

    public int currentCodePoint() {
        int ch = this.current();
        if (UTF16.isLeadSurrogate((char)ch)) {
            this.next();
            int ch2 = this.current();
            this.previous();
            if (UTF16.isTrailSurrogate((char)ch2)) {
                return Character.toCodePoint((char)ch, (char)ch2);
            }
        }
        return ch;
    }

    public abstract int getLength();

    public abstract int getIndex();

    @Override
    public abstract int next();

    @Override
    public int nextCodePoint() {
        int ch1 = this.next();
        if (UTF16.isLeadSurrogate((char)ch1)) {
            int ch2 = this.next();
            if (UTF16.isTrailSurrogate((char)ch2)) {
                return Character.toCodePoint((char)ch1, (char)ch2);
            }
            if (ch2 != -1) {
                this.previous();
            }
        }
        return ch1;
    }

    public abstract int previous();

    public int previousCodePoint() {
        int ch1 = this.previous();
        if (UTF16.isTrailSurrogate((char)ch1)) {
            int ch2 = this.previous();
            if (UTF16.isLeadSurrogate((char)ch2)) {
                return Character.toCodePoint((char)ch2, (char)ch1);
            }
            if (ch2 != -1) {
                this.next();
            }
        }
        return ch1;
    }

    public abstract void setIndex(int var1);

    public void setToLimit() {
        this.setIndex(this.getLength());
    }

    public void setToStart() {
        this.setIndex(0);
    }

    public abstract int getText(char[] var1, int var2);

    public final int getText(char[] fillIn) {
        return this.getText(fillIn, 0);
    }

    public String getText() {
        char[] text = new char[this.getLength()];
        this.getText(text);
        return new String(text);
    }

    public int moveIndex(int delta) {
        int x2 = Math.max(0, Math.min(this.getIndex() + delta, this.getLength()));
        this.setIndex(x2);
        return x2;
    }

    public int moveCodePointIndex(int delta) {
        if (delta > 0) {
            while (delta > 0 && this.nextCodePoint() != -1) {
                --delta;
            }
        } else {
            while (delta < 0 && this.previousCodePoint() != -1) {
                ++delta;
            }
        }
        if (delta != 0) {
            throw new IndexOutOfBoundsException();
        }
        return this.getIndex();
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

