/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.shade.icu.text;

import com.teamwizardry.librarianlib.shade.icu.text.Replaceable;
import com.teamwizardry.librarianlib.shade.icu.text.TransliterationRule;
import com.teamwizardry.librarianlib.shade.icu.text.Transliterator;
import com.teamwizardry.librarianlib.shade.icu.text.UTF16;
import com.teamwizardry.librarianlib.shade.icu.text.UnicodeSet;
import java.util.ArrayList;
import java.util.List;

class TransliterationRuleSet {
    private List<TransliterationRule> ruleVector = new ArrayList<TransliterationRule>();
    private int maxContextLength = 0;
    private TransliterationRule[] rules;
    private int[] index;

    public int getMaximumContextLength() {
        return this.maxContextLength;
    }

    public void addRule(TransliterationRule rule) {
        this.ruleVector.add(rule);
        int len = rule.getAnteContextLength();
        if (len > this.maxContextLength) {
            this.maxContextLength = len;
        }
        this.rules = null;
    }

    public void freeze() {
        int n = this.ruleVector.size();
        this.index = new int[257];
        ArrayList<TransliterationRule> v = new ArrayList<TransliterationRule>(2 * n);
        int[] indexValue = new int[n];
        for (int j = 0; j < n; ++j) {
            TransliterationRule r = this.ruleVector.get(j);
            indexValue[j] = r.getIndexValue();
        }
        for (int x2 = 0; x2 < 256; ++x2) {
            this.index[x2] = v.size();
            for (int j = 0; j < n; ++j) {
                if (indexValue[j] >= 0) {
                    if (indexValue[j] != x2) continue;
                    v.add(this.ruleVector.get(j));
                    continue;
                }
                TransliterationRule r = this.ruleVector.get(j);
                if (!r.matchesIndexValue(x2)) continue;
                v.add(r);
            }
        }
        this.index[256] = v.size();
        this.rules = new TransliterationRule[v.size()];
        v.toArray(this.rules);
        StringBuilder errors2 = null;
        for (int x3 = 0; x3 < 256; ++x3) {
            for (int j = this.index[x3]; j < this.index[x3 + 1] - 1; ++j) {
                TransliterationRule r1 = this.rules[j];
                for (int k = j + 1; k < this.index[x3 + 1]; ++k) {
                    TransliterationRule r2 = this.rules[k];
                    if (!r1.masks(r2)) continue;
                    if (errors2 == null) {
                        errors2 = new StringBuilder();
                    } else {
                        errors2.append("\n");
                    }
                    errors2.append("Rule " + r1 + " masks " + r2);
                }
            }
        }
        if (errors2 != null) {
            throw new IllegalArgumentException(errors2.toString());
        }
    }

    public boolean transliterate(Replaceable text, Transliterator.Position pos2, boolean incremental) {
        int indexByte = text.char32At(pos2.start) & 0xFF;
        for (int i = this.index[indexByte]; i < this.index[indexByte + 1]; ++i) {
            int m = this.rules[i].matchAndReplace(text, pos2, incremental);
            switch (m) {
                case 2: {
                    return true;
                }
                case 1: {
                    return false;
                }
            }
        }
        pos2.start += UTF16.getCharCount(text.char32At(pos2.start));
        return true;
    }

    String toRules(boolean escapeUnprintable) {
        int count = this.ruleVector.size();
        StringBuilder ruleSource = new StringBuilder();
        for (int i = 0; i < count; ++i) {
            if (i != 0) {
                ruleSource.append('\n');
            }
            TransliterationRule r = this.ruleVector.get(i);
            ruleSource.append(r.toRule(escapeUnprintable));
        }
        return ruleSource.toString();
    }

    void addSourceTargetSet(UnicodeSet filter2, UnicodeSet sourceSet, UnicodeSet targetSet) {
        UnicodeSet currentFilter = new UnicodeSet(filter2);
        UnicodeSet revisiting = new UnicodeSet();
        int count = this.ruleVector.size();
        for (int i = 0; i < count; ++i) {
            TransliterationRule r = this.ruleVector.get(i);
            r.addSourceTargetSet(currentFilter, sourceSet, targetSet, revisiting.clear());
            currentFilter.addAll(revisiting);
        }
    }
}

