/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.math;

import com.teamwizardry.librarianlib.features.math.Vec2d;
import java.util.Arrays;
import javax.vecmath.Matrix3d;
import javax.vecmath.Point3d;
import javax.vecmath.Tuple3d;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 $2\u00020\u0001:\u0001$B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B\u0017\b\u0002\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000eJ\b\u0010\u000f\u001a\u00020\u0010H\u0002J\u0006\u0010\u0011\u001a\u00020\u0000J\u0013\u0010\u0012\u001a\u00020\u00062\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u0006\u0010\u0005\u001a\u00020\u0000J\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0006\u0010\u0016\u001a\u00020\u0000J\u000e\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0003\u001a\u00020\u0000J\u000e\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001aJ\u000e\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u000eJ\u0016\u0010\u001b\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001aJ\u0011\u0010\u001f\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000eH\u0086\u0002J\u0011\u0010 \u001a\u00020\u00102\u0006\u0010\u0003\u001a\u00020\u0000H\u0086\u0002J\b\u0010!\u001a\u00020\"H\u0016J\u000e\u0010#\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u000eJ\u0016\u0010#\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001aR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/teamwizardry/librarianlib/features/math/Matrix3;", "", "()V", "matrix", "Ljavax/vecmath/Matrix3d;", "frozen", "", "(Ljavax/vecmath/Matrix3d;Z)V", "getFrozen", "()Z", "point", "Ljavax/vecmath/Point3d;", "transform", "apply", "Lcom/teamwizardry/librarianlib/features/math/Vec2d;", "checkFrozen", "", "copy", "equals", "other", "hashCode", "", "invert", "mul", "rotate", "angle", "", "scale", "vec", "x", "y", "times", "timesAssign", "toString", "", "translate", "Companion", "librarianlib-1.12.2"})
public final class Matrix3 {
    private final Matrix3d transform;
    private final Point3d point;
    private final Matrix3d matrix;
    private final boolean frozen;
    @JvmField
    @NotNull
    public static final Matrix3 identity;
    public static final Companion Companion;

    @NotNull
    public final Matrix3 invert() {
        Matrix3 inverseMatrix = this.copy();
        inverseMatrix.matrix.invert();
        return inverseMatrix;
    }

    public final void translate(double x2, double y) {
        this.checkFrozen();
        this.transform.setIdentity();
        this.transform.m02 = x2;
        this.transform.m12 = y;
        this.matrix.mul(this.transform);
    }

    public final void scale(double x2, double y) {
        this.checkFrozen();
        this.transform.setIdentity();
        this.transform.m00 = x2;
        this.transform.m11 = y;
        this.matrix.mul(this.transform);
    }

    public final void rotate(double angle) {
        double cos;
        this.checkFrozen();
        this.transform.setIdentity();
        double sin = Math.sin(-angle);
        this.transform.m00 = cos = Math.cos(-angle);
        this.transform.m01 = sin;
        this.transform.m10 = -sin;
        this.transform.m11 = cos;
        this.matrix.mul(this.transform);
    }

    public final void translate(@NotNull Vec2d vec) {
        Intrinsics.checkParameterIsNotNull(vec, "vec");
        this.translate(vec.getX(), vec.getY());
    }

    public final void scale(@NotNull Vec2d vec) {
        Intrinsics.checkParameterIsNotNull(vec, "vec");
        this.scale(vec.getX(), vec.getY());
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Vec2d apply(@NotNull Vec2d point) {
        void x$iv;
        Intrinsics.checkParameterIsNotNull(point, "point");
        this.point.x = point.getX();
        this.point.y = point.getY();
        this.point.z = 1.0;
        this.matrix.transform((Tuple3d)this.point);
        double d = this.point.x;
        double y$iv = this.point.y;
        return Vec2d.Companion.getPooled((double)x$iv, y$iv);
    }

    public final void mul(@NotNull Matrix3 matrix) {
        Intrinsics.checkParameterIsNotNull(matrix, "matrix");
        this.checkFrozen();
        this.matrix.mul(matrix.matrix);
    }

    @NotNull
    public final Matrix3 copy() {
        Object object = this.matrix.clone();
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type javax.vecmath.Matrix3d");
        }
        return new Matrix3((Matrix3d)object, false);
    }

    @NotNull
    public final Matrix3 frozen() {
        Object object = this.matrix.clone();
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type javax.vecmath.Matrix3d");
        }
        return new Matrix3((Matrix3d)object, true);
    }

    @NotNull
    public final Vec2d times(@NotNull Vec2d point) {
        Intrinsics.checkParameterIsNotNull(point, "point");
        return this.apply(point);
    }

    public final void timesAssign(@NotNull Matrix3 matrix) {
        Intrinsics.checkParameterIsNotNull(matrix, "matrix");
        this.mul(matrix);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Matrix3)) {
            return false;
        }
        return !(Intrinsics.areEqual(this.matrix, ((Matrix3)other).matrix) ^ true);
    }

    public int hashCode() {
        return this.matrix.hashCode();
    }

    @NotNull
    public String toString() {
        double d = this.matrix.m00;
        double d2 = this.matrix.m10;
        double d3 = this.matrix.m20;
        d2 = Math.max(d2, d3);
        d = Math.max(d, d2);
        int w0 = String.valueOf(Math.floor(d)).length() + 1;
        double d4 = this.matrix.m01;
        double d5 = this.matrix.m11;
        double d6 = this.matrix.m21;
        d5 = Math.max(d5, d6);
        d4 = Math.max(d4, d5);
        int w1 = String.valueOf(Math.floor(d4)).length() + 1;
        d2 = this.matrix.m02;
        d3 = this.matrix.m12;
        double d7 = this.matrix.m22;
        d3 = Math.max(d3, d7);
        d2 = Math.max(d2, d3);
        int w2 = String.valueOf(Math.floor(d2)).length() + 1;
        String string = StringsKt.trimIndent("\n            \u23a1%" + w0 + ".2f %" + w1 + ".2f %" + w2 + ".2f\u23a4\n            \u23a2%" + w0 + ".2f %" + w1 + ".2f %" + w2 + ".2f\u23a5\n            \u23a3%" + w0 + ".2f %" + w1 + ".2f %" + w2 + ".2f\u23a6\n        ");
        Object[] objectArray = new Object[]{this.matrix.m00, this.matrix.m01, this.matrix.m02, this.matrix.m10, this.matrix.m11, this.matrix.m12, this.matrix.m20, this.matrix.m21, this.matrix.m22};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkExpressionValueIsNotNull(string2, "java.lang.String.format(this, *args)");
        return string2;
    }

    private final void checkFrozen() {
        if (this.frozen) {
            throw (Throwable)new IllegalArgumentException("This matrix is frozen. Use `copy` to create a mutable copy");
        }
    }

    public final boolean getFrozen() {
        return this.frozen;
    }

    private Matrix3(Matrix3d matrix, boolean frozen) {
        this.matrix = matrix;
        this.frozen = frozen;
        this.transform = new Matrix3d();
        this.point = new Point3d();
    }

    public Matrix3() {
        Matrix3d matrix3d = new Matrix3d();
        Matrix3 matrix3 = this;
        Matrix3d $receiver = matrix3d;
        $receiver.setIdentity();
        Matrix3d matrix3d2 = matrix3d;
        matrix3(matrix3d2, false);
    }

    static {
        Companion = new Companion(null);
        identity = new Matrix3().frozen();
    }

    @Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0010\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/teamwizardry/librarianlib/features/math/Matrix3$Companion;", "", "()V", "identity", "Lcom/teamwizardry/librarianlib/features/math/Matrix3;", "librarianlib-1.12.2"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

