/*
 * Decompiled with CFR 0.152.
 */
package com.teamwizardry.librarianlib.features.math;

import com.teamwizardry.librarianlib.core.client.ClientTickHandler;
import com.teamwizardry.librarianlib.features.math.AllocationTracker;
import com.teamwizardry.librarianlib.features.math.AllocationWindow;
import com.teamwizardry.librarianlib.features.math.Rect2d;
import com.teamwizardry.librarianlib.features.math.Vec2d;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0002\b\u0012\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0007J\u0006\u0010'\u001a\u00020$JI\u0010(\u001a\u00020$2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00110*2\u0006\u0010+\u001a\u00020\u00112\u0006\u0010,\u001a\u00020-2\b\u0010.\u001a\u0004\u0018\u00010-2\u0006\u0010/\u001a\u00020\u00042\f\u00100\u001a\b\u0012\u0002\b\u0003\u0018\u000101\u00a2\u0006\u0002\u00102J\u001f\u00103\u001a\u00020$2\b\u00104\u001a\u0004\u0018\u00010\u00042\b\b\u0002\u00105\u001a\u00020\u0011\u00a2\u0006\u0002\u00106J\u0010\u00107\u001a\u00020$2\u0006\u0010%\u001a\u000208H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u001e\u0010\n\u001a\u0004\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u000f\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u0010\u001a\u00020\u0011X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0016\u001a\u00020\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\tR\u0011\u0010\u001d\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\tR\u0011\u0010\u001f\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\tR\u0011\u0010!\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\t\u00a8\u00069"}, d2={"Lcom/teamwizardry/librarianlib/features/math/AllocationDisplay;", "", "()V", "B_PER_KB", "", "B_PER_MB", "rect2dAllocations", "Lcom/teamwizardry/librarianlib/features/math/AllocationWindow;", "getRect2dAllocations", "()Lcom/teamwizardry/librarianlib/features/math/AllocationWindow;", "statsEndTime", "getStatsEndTime", "()Ljava/lang/Integer;", "setStatsEndTime", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "statsOutputDir", "", "getStatsOutputDir", "()Ljava/lang/String;", "setStatsOutputDir", "(Ljava/lang/String;)V", "statsStartTime", "getStatsStartTime", "()I", "setStatsStartTime", "(I)V", "vec2dAllocations", "getVec2dAllocations", "vec2dPooledAllocations", "getVec2dPooledAllocations", "vec3dAllocations", "getVec3dAllocations", "vec3dPooledAllocations", "getVec3dPooledAllocations", "debug", "", "event", "Lnet/minecraftforge/client/event/RenderGameOverlayEvent$Text;", "endStats", "line", "list", "", "name", "allocations", "", "pooled", "size", "stats", "Lit/unimi/dsi/fastutil/objects/Object2IntMap;", "(Ljava/util/List;Ljava/lang/String;DLjava/lang/Double;ILit/unimi/dsi/fastutil/objects/Object2IntMap;)V", "startStats", "duration", "outputDir", "(Ljava/lang/Integer;Ljava/lang/String;)V", "tick", "Lnet/minecraftforge/fml/common/gameevent/TickEvent$ClientTickEvent;", "librarianlib-1.12.2"})
public final class AllocationDisplay {
    @NotNull
    private static final AllocationWindow vec2dAllocations;
    @NotNull
    private static final AllocationWindow vec2dPooledAllocations;
    @NotNull
    private static final AllocationWindow rect2dAllocations;
    @NotNull
    private static final AllocationWindow vec3dAllocations;
    @NotNull
    private static final AllocationWindow vec3dPooledAllocations;
    private static int statsStartTime;
    @Nullable
    private static Integer statsEndTime;
    @NotNull
    private static String statsOutputDir;
    private static final int B_PER_KB = 1024;
    private static final int B_PER_MB = 0x100000;
    public static final AllocationDisplay INSTANCE;

    @NotNull
    public final AllocationWindow getVec2dAllocations() {
        return vec2dAllocations;
    }

    @NotNull
    public final AllocationWindow getVec2dPooledAllocations() {
        return vec2dPooledAllocations;
    }

    @NotNull
    public final AllocationWindow getRect2dAllocations() {
        return rect2dAllocations;
    }

    @NotNull
    public final AllocationWindow getVec3dAllocations() {
        return vec3dAllocations;
    }

    @NotNull
    public final AllocationWindow getVec3dPooledAllocations() {
        return vec3dPooledAllocations;
    }

    public final int getStatsStartTime() {
        return statsStartTime;
    }

    public final void setStatsStartTime(int n) {
        statsStartTime = n;
    }

    @Nullable
    public final Integer getStatsEndTime() {
        return statsEndTime;
    }

    public final void setStatsEndTime(@Nullable Integer n) {
        statsEndTime = n;
    }

    @NotNull
    public final String getStatsOutputDir() {
        return statsOutputDir;
    }

    public final void setStatsOutputDir(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull(string, "<set-?>");
        statsOutputDir = string;
    }

    @SubscribeEvent
    public final void tick(@NotNull TickEvent.ClientTickEvent event) {
        Intrinsics.checkParameterIsNotNull(event, "event");
        vec2dAllocations.sample(AllocationTracker.INSTANCE.getVec2dAllocations());
        vec2dPooledAllocations.sample(AllocationTracker.INSTANCE.getVec2dPooledAllocations());
        rect2dAllocations.sample(AllocationTracker.INSTANCE.getRect2dAllocations());
        vec3dAllocations.sample(AllocationTracker.INSTANCE.getVec3dAllocations());
        vec3dPooledAllocations.sample(AllocationTracker.INSTANCE.getVec3dPooledAllocations());
        Integer n = statsEndTime;
        if (n != null) {
            Integer n2 = n;
            int it = ((Number)n2).intValue();
            if (ClientTickHandler.getTicks() >= it) {
                this.endStats();
                statsEndTime = null;
            }
        }
    }

    public final void startStats(@Nullable Integer duration, @NotNull String outputDir) {
        Integer n;
        Intrinsics.checkParameterIsNotNull(outputDir, "outputDir");
        AllocationTracker.INSTANCE.setVec2dAllocationStats(new Object2IntOpenHashMap());
        AllocationTracker.INSTANCE.setRect2dAllocationStats(new Object2IntOpenHashMap());
        AllocationTracker.INSTANCE.setVec3dAllocationStats(new Object2IntOpenHashMap());
        statsOutputDir = outputDir;
        Integer n2 = duration;
        if (n2 != null) {
            Integer n3 = n2;
            int it = ((Number)n3).intValue();
            n = ClientTickHandler.getTicks() + it;
        } else {
            n = null;
        }
        statsEndTime = n;
    }

    public static /* synthetic */ void startStats$default(AllocationDisplay allocationDisplay, Integer n, String string, int n2, Object object) {
        if ((n2 & 2) != 0) {
            string = "~";
        }
        allocationDisplay.startStats(n, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void endStats() {
        block24: {
            try {
                Object2IntMap.Entry it;
                Object element$iv2;
                Iterable $receiver$iv;
                Object file2;
                Object object;
                Object object2;
                Object object3;
                Object2IntMap<Object> object2IntMap;
                new File(String.valueOf(statsOutputDir)).mkdirs();
                double duration = (double)(ClientTickHandler.getTicks() - statsStartTime) / 20.0;
                Object2IntMap<Vec2d> object2IntMap2 = AllocationTracker.INSTANCE.getVec2dAllocationStats();
                if (object2IntMap2 != null) {
                    object2IntMap = object2IntMap2;
                    Object2IntMap<Vec2d> vec2dStats = object2IntMap;
                    object3 = new File(statsOutputDir + "/vec2d-" + (int)duration + "s.csv");
                    object2 = Charsets.UTF_8;
                    int n = 8192;
                    object = object3;
                    Object object4 = object;
                    object = new OutputStreamWriter((OutputStream)(object4 = (OutputStream)new FileOutputStream((File)object4)), (Charset)object2);
                    object3 = object instanceof BufferedWriter ? (BufferedWriter)object : new BufferedWriter((Writer)object, n);
                    object2 = null;
                    try {
                        file2 = (BufferedWriter)object3;
                        ((Writer)file2).write("X,Y,Count\n");
                        ObjectSet<Object2IntMap.Entry<Vec2d>> objectSet = vec2dStats.object2IntEntrySet();
                        Intrinsics.checkExpressionValueIsNotNull(objectSet, "vec2dStats.object2IntEntrySet()");
                        $receiver$iv = objectSet;
                        for (Object element$iv2 : $receiver$iv) {
                            it = (Object2IntMap.Entry)element$iv2;
                            StringBuilder stringBuilder = new StringBuilder().append(((Vec2d)it.getKey()).getX()).append(',').append(((Vec2d)it.getKey()).getY()).append(',');
                            Object2IntMap.Entry entry = it;
                            Intrinsics.checkExpressionValueIsNotNull(entry, "it");
                            ((Writer)file2).write(stringBuilder.append(entry.getIntValue()).append('\n').toString());
                        }
                        file2 = Unit.INSTANCE;
                    }
                    catch (Throwable file2) {
                        object2 = file2;
                        throw file2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)object3, (Throwable)object2);
                    }
                }
                Object2IntMap<Rect2d> object2IntMap3 = AllocationTracker.INSTANCE.getRect2dAllocationStats();
                if (object2IntMap3 != null) {
                    Object2IntMap<Object> rect2dStats = object2IntMap = object2IntMap3;
                    object3 = new File(statsOutputDir + "/rect2d-" + (int)duration + "s.csv");
                    object2 = Charsets.UTF_8;
                    int file2 = 8192;
                    object = object3;
                    element$iv2 = object;
                    object = new OutputStreamWriter((OutputStream)(element$iv2 = (OutputStream)new FileOutputStream((File)element$iv2)), (Charset)object2);
                    object3 = object instanceof BufferedWriter ? (BufferedWriter)object : new BufferedWriter((Writer)object, file2);
                    object2 = null;
                    try {
                        file2 = (BufferedWriter)object3;
                        ((Writer)file2).write("X,Y,Width,Height,Count\n");
                        ObjectSet<Object2IntMap.Entry<Object>> objectSet = rect2dStats.object2IntEntrySet();
                        Intrinsics.checkExpressionValueIsNotNull(objectSet, "rect2dStats.object2IntEntrySet()");
                        $receiver$iv = objectSet;
                        for (Object element$iv2 : $receiver$iv) {
                            it = (Object2IntMap.Entry)element$iv2;
                            StringBuilder stringBuilder = new StringBuilder().append(((Rect2d)it.getKey()).getX()).append(',').append(((Rect2d)it.getKey()).getY()).append(',').append(((Rect2d)it.getKey()).getWidth()).append(',').append(((Rect2d)it.getKey()).getHeight()).append(',');
                            Object2IntMap.Entry entry = it;
                            Intrinsics.checkExpressionValueIsNotNull(entry, "it");
                            ((Writer)file2).write(stringBuilder.append(entry.getIntValue()).append('\n').toString());
                        }
                        file2 = Unit.INSTANCE;
                    }
                    catch (Throwable file3) {
                        object2 = file3;
                        throw file3;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)object3, (Throwable)object2);
                    }
                }
                Object2IntMap<Vec3d> object2IntMap4 = AllocationTracker.INSTANCE.getVec3dAllocationStats();
                if (object2IntMap4 == null) break block24;
                Object2IntMap<Object> vec3dStats = object2IntMap = object2IntMap4;
                object3 = new File(statsOutputDir + "/vec3d-" + (int)duration + "s.csv");
                object2 = Charsets.UTF_8;
                int file3 = 8192;
                object = object3;
                element$iv2 = object;
                object = new OutputStreamWriter((OutputStream)(element$iv2 = (OutputStream)new FileOutputStream((File)element$iv2)), (Charset)object2);
                object3 = object instanceof BufferedWriter ? (BufferedWriter)object : new BufferedWriter((Writer)object, file3);
                object2 = null;
                try {
                    BufferedWriter file4 = (BufferedWriter)object3;
                    file4.write("X,Y,Z,Count\n");
                    ObjectSet<Object2IntMap.Entry<Object>> objectSet = vec3dStats.object2IntEntrySet();
                    Intrinsics.checkExpressionValueIsNotNull(objectSet, "vec3dStats.object2IntEntrySet()");
                    $receiver$iv = objectSet;
                    for (Object element$iv2 : $receiver$iv) {
                        it = (Object2IntMap.Entry)element$iv2;
                        StringBuilder stringBuilder = new StringBuilder().append(((Vec3d)it.getKey()).field_72450_a).append(',').append(((Vec3d)it.getKey()).field_72448_b).append(',').append(((Vec3d)it.getKey()).field_72449_c).append(',');
                        Object2IntMap.Entry entry = it;
                        Intrinsics.checkExpressionValueIsNotNull(entry, "it");
                        file4.write(stringBuilder.append(entry.getIntValue()).toString());
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable) {
                    object2 = throwable;
                    throw throwable;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object3, (Throwable)object2);
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
        }
        AllocationTracker.INSTANCE.setVec2dAllocationStats(null);
        AllocationTracker.INSTANCE.setRect2dAllocationStats(null);
        AllocationTracker.INSTANCE.setVec3dAllocationStats(null);
    }

    @SubscribeEvent
    public final void debug(@NotNull RenderGameOverlayEvent.Text event) {
        Intrinsics.checkParameterIsNotNull(event, "event");
        if (!Minecraft.func_71410_x().field_71474_y.field_74330_P) {
            return;
        }
        event.getLeft().add("LibrarianLib Allocations:");
        ArrayList arrayList = event.getLeft();
        Intrinsics.checkExpressionValueIsNotNull(arrayList, "event.left");
        this.line(arrayList, "Vec3d", vec3dAllocations.getAverage(), vec3dPooledAllocations.getAverage(), AllocationTracker.INSTANCE.getVec3dSize(), AllocationTracker.INSTANCE.getVec3dAllocationStats());
        ArrayList arrayList2 = event.getLeft();
        Intrinsics.checkExpressionValueIsNotNull(arrayList2, "event.left");
        this.line(arrayList2, "Vec2d", vec2dAllocations.getAverage(), vec2dPooledAllocations.getAverage(), AllocationTracker.INSTANCE.getVec2dSize(), AllocationTracker.INSTANCE.getVec2dAllocationStats());
        ArrayList arrayList3 = event.getLeft();
        Intrinsics.checkExpressionValueIsNotNull(arrayList3, "event.left");
        this.line(arrayList3, "Rect2d", rect2dAllocations.getAverage(), null, AllocationTracker.INSTANCE.getRect2dSize(), AllocationTracker.INSTANCE.getRect2dAllocationStats());
    }

    public final void line(@NotNull List<String> list2, @NotNull String name, double allocations, @Nullable Double pooled, int size2, @Nullable Object2IntMap<?> stats) {
        String string;
        StringBuilder stringBuilder;
        Map map;
        Intrinsics.checkParameterIsNotNull(list2, "list");
        Intrinsics.checkParameterIsNotNull(name, "name");
        if (allocations == 0.0 && (pooled == null || Intrinsics.areEqual(pooled, 0.0)) && ((map = (Map)stats) == null || map.isEmpty())) {
            return;
        }
        String line = " - " + name + ':';
        line = line + ' ' + (int)allocations + " unpooled/s";
        if (pooled != null) {
            double percent = (double)100 * pooled / (allocations + pooled);
            line = line + " (" + (int)percent + "% pooled)";
        }
        double memory = (double)size2 * allocations;
        StringBuilder stringBuilder2 = new StringBuilder().append(line);
        if (memory > (double)B_PER_MB) {
            String string2 = " - %.2f MiB/s";
            Object[] objectArray = new Object[]{memory / (double)B_PER_MB};
            StringBuilder stringBuilder3 = stringBuilder2;
            String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull(string3, "java.lang.String.format(this, *args)");
            String string4 = string3;
            stringBuilder = stringBuilder3;
            string = string4;
        } else if (memory > (double)B_PER_KB) {
            String string5 = " - %.2f KiB/s";
            Object[] objectArray = new Object[]{memory / (double)B_PER_KB};
            StringBuilder stringBuilder4 = stringBuilder2;
            String string6 = String.format(string5, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull(string6, "java.lang.String.format(this, *args)");
            String string7 = string6;
            stringBuilder = stringBuilder4;
            string = string7;
        } else {
            String string8 = " - %d bytes/s";
            Object[] objectArray = new Object[]{(int)memory};
            StringBuilder stringBuilder5 = stringBuilder2;
            String string9 = String.format(string8, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkExpressionValueIsNotNull(string9, "java.lang.String.format(this, *args)");
            String string10 = string9;
            stringBuilder = stringBuilder5;
            string = string10;
        }
        line = stringBuilder.append(string).toString();
        if (stats != null) {
            line = line + " - Stats: " + stats.size() + " unique allocations";
        }
        list2.add(line);
    }

    private AllocationDisplay() {
    }

    static {
        AllocationDisplay allocationDisplay;
        INSTANCE = allocationDisplay = new AllocationDisplay();
        MinecraftForge.EVENT_BUS.register((Object)allocationDisplay);
        vec2dAllocations = new AllocationWindow();
        vec2dPooledAllocations = new AllocationWindow();
        rect2dAllocations = new AllocationWindow();
        vec3dAllocations = new AllocationWindow();
        vec3dPooledAllocations = new AllocationWindow();
        statsOutputDir = "~";
        B_PER_KB = 1024;
        B_PER_MB = 0x100000;
    }
}

