/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.render.item;

import codechicken.lib.model.ItemQuadBakery;
import codechicken.lib.model.bakedmodels.ModelProperties;
import codechicken.lib.model.bakery.generation.IItemBakery;
import codechicken.lib.texture.TextureUtils;
import cofh.core.item.ItemMulti;
import cofh.core.render.TextureHelper;
import cofh.core.util.helpers.ColorHelper;
import cofh.thermalexpansion.init.TEItems;
import cofh.thermalexpansion.init.TETextures;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ItemTextureQuadConverter;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class ModelReservoir
implements IItemBakery {
    private static final float NORTH_Z_FLUID = 0.468625f;
    private static final float SOUTH_Z_FLUID = 0.531375f;
    public static final ModelReservoir INSTANCE = new ModelReservoir();

    public List<BakedQuad> bakeItemQuads(EnumFacing face, ItemStack stack) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        if (face == null) {
            FluidStack fluid_stack;
            int index = ItemMulti.isCreative((ItemStack)stack) ? 5 : stack.func_77960_j();
            boolean hasColor = ColorHelper.hasColor0((ItemStack)stack);
            boolean active = TEItems.itemReservoir.isActive(stack);
            int mode = TEItems.itemReservoir.getMode(stack);
            LinkedList<TextureAtlasSprite> sprites = new LinkedList<TextureAtlasSprite>();
            sprites.add(index >= TETextures.RESERVOIR.length ? TextureUtils.getMissingSprite() : TETextures.RESERVOIR[index]);
            sprites.add(TETextures.RESERVOIR_MODE[(active ? 1 : 0) << 1 | mode]);
            if (hasColor) {
                sprites.add(TETextures.RESERVOIR_COLOR_0);
            }
            quads.addAll(ItemQuadBakery.bakeItem(sprites));
            if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("Fluid") && (fluid_stack = FluidStack.loadFluidStackFromNBT((NBTTagCompound)stack.func_77978_p().func_74775_l("Fluid"))) != null) {
                Fluid fluid = fluid_stack.getFluid();
                TextureAtlasSprite fluidSprite = TextureHelper.getTexture((ResourceLocation)fluid.getStill(fluid_stack));
                quads.addAll(ItemTextureQuadConverter.convertTexture((VertexFormat)DefaultVertexFormats.field_176599_b, (TRSRTransformation)TRSRTransformation.identity(), (TextureAtlasSprite)TETextures.RESERVOIR_MASK, (TextureAtlasSprite)fluidSprite, (float)0.468625f, (EnumFacing)EnumFacing.NORTH, (int)fluid.getColor(fluid_stack)));
                quads.addAll(ItemTextureQuadConverter.convertTexture((VertexFormat)DefaultVertexFormats.field_176599_b, (TRSRTransformation)TRSRTransformation.identity(), (TextureAtlasSprite)TETextures.RESERVOIR_MASK, (TextureAtlasSprite)fluidSprite, (float)0.531375f, (EnumFacing)EnumFacing.SOUTH, (int)fluid.getColor(fluid_stack)));
            }
        }
        return quads;
    }

    public ModelProperties.PerspectiveProperties getModelProperties(ItemStack stack) {
        return ModelProperties.PerspectiveProperties.DEFAULT_ITEM;
    }
}

