/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.machine;

import cofh.core.fluid.FluidTankCore;
import cofh.core.network.PacketBase;
import cofh.core.util.core.EnergyConfig;
import cofh.core.util.core.SideConfig;
import cofh.core.util.core.SlotConfig;
import cofh.core.util.helpers.AugmentHelper;
import cofh.core.util.helpers.ItemHelper;
import cofh.core.util.helpers.MathHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.machine.BlockMachine;
import cofh.thermalexpansion.block.machine.TileMachineBase;
import cofh.thermalexpansion.gui.client.machine.GuiPulverizer;
import cofh.thermalexpansion.gui.container.machine.ContainerPulverizer;
import cofh.thermalexpansion.init.TEProps;
import cofh.thermalexpansion.init.TESounds;
import cofh.thermalexpansion.util.managers.machine.PulverizerManager;
import cofh.thermalfoundation.init.TFFluids;
import java.util.Arrays;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class TilePulverizer
extends TileMachineBase {
    private static final int TYPE = BlockMachine.Type.PULVERIZER.getMetadata();
    public static int basePower = 20;
    public static final int FLUID_AMOUNT = 100;
    public static final int GEODE_ENERGY_MOD = 25;
    public static final int PETROTHEUM_ENERGY_MOD = 50;
    public static final int PETROTHEUM_SECONDARY_MOD = 25;
    private PulverizerManager.PulverizerRecipe curRecipe;
    private int inputTracker;
    private int outputTrackerPrimary;
    private int outputTrackerSecondary;
    private FluidTankCore tank = new FluidTankCore(4000);
    protected boolean augmentGeode;
    protected boolean augmentPetrotheum;
    protected boolean flagPetrotheum;

    public static void initialize() {
        TilePulverizer.SIDE_CONFIGS[TilePulverizer.TYPE] = new SideConfig();
        TilePulverizer.SIDE_CONFIGS[TilePulverizer.TYPE].numConfig = 7;
        TilePulverizer.SIDE_CONFIGS[TilePulverizer.TYPE].slotGroups = new int[][]{new int[0], {0}, {1}, {2}, {1, 2}, {0, 1, 2}, {0, 1, 2}};
        TilePulverizer.SIDE_CONFIGS[TilePulverizer.TYPE].sideTypes = new int[]{0, 1, 2, 3, 4, 7, 8};
        TilePulverizer.SIDE_CONFIGS[TilePulverizer.TYPE].defaultSides = new byte[]{3, 1, 2, 2, 2, 2};
        TilePulverizer.ALT_SIDE_CONFIGS[TilePulverizer.TYPE] = new SideConfig();
        TilePulverizer.ALT_SIDE_CONFIGS[TilePulverizer.TYPE].numConfig = 2;
        TilePulverizer.ALT_SIDE_CONFIGS[TilePulverizer.TYPE].slotGroups = new int[][]{new int[0], {0}, {1}, {2}, {1, 2}, {0, 1, 2}, {0, 1, 2}};
        TilePulverizer.ALT_SIDE_CONFIGS[TilePulverizer.TYPE].sideTypes = new int[]{0, 7};
        TilePulverizer.ALT_SIDE_CONFIGS[TilePulverizer.TYPE].defaultSides = new byte[]{1, 1, 1, 1, 1, 1};
        TilePulverizer.SLOT_CONFIGS[TilePulverizer.TYPE] = new SlotConfig();
        TilePulverizer.SLOT_CONFIGS[TilePulverizer.TYPE].allowInsertionSlot = new boolean[]{true, false, false, false};
        TilePulverizer.SLOT_CONFIGS[TilePulverizer.TYPE].allowExtractionSlot = new boolean[]{false, true, true, false};
        TilePulverizer.VALID_AUGMENTS[TilePulverizer.TYPE] = new HashSet();
        VALID_AUGMENTS[TYPE].add("machinePulverizerGeode");
        VALID_AUGMENTS[TYPE].add("machinePulverizerPetrotheum");
        VALID_AUGMENTS[TYPE].add("machineSecondary");
        VALID_AUGMENTS[TYPE].add("machineSecondaryNull");
        TilePulverizer.LIGHT_VALUES[TilePulverizer.TYPE] = 4;
        GameRegistry.registerTileEntity(TilePulverizer.class, (String)"thermalexpansion:machine_pulverizer");
        TilePulverizer.config();
    }

    public static void config() {
        String category = "Machine.Pulverizer";
        BlockMachine.enable[TilePulverizer.TYPE] = ThermalExpansion.CONFIG.get(category, "Enable", true);
        String comment = "Adjust this value to change the Energy consumption (in RF/t) for a Pulverizer. This base value will scale with block level and Augments.";
        basePower = ThermalExpansion.CONFIG.getConfiguration().getInt("BasePower", category, basePower, 10, 5000, comment);
        TilePulverizer.ENERGY_CONFIGS[TilePulverizer.TYPE] = new EnergyConfig();
        ENERGY_CONFIGS[TYPE].setDefaultParams(basePower, smallStorage);
    }

    public static int getPetrotheumOutputAmount(ItemStack stack) {
        int amount = stack.func_190916_E();
        return amount + Math.max(1, amount * 50 / 100);
    }

    public TilePulverizer() {
        this.inventory = new ItemStack[4];
        Arrays.fill(this.inventory, ItemStack.field_190927_a);
        this.createAllSlots(this.inventory.length);
        this.tank.setLock(TFFluids.fluidPetrotheum);
    }

    public int getType() {
        return TYPE;
    }

    @Override
    protected boolean canStart() {
        boolean augmentPetrotheumCheck;
        if (this.inventory[0].func_190926_b() || this.energyStorage.getEnergyStored() <= 0) {
            return false;
        }
        this.getRecipe();
        if (this.curRecipe == null) {
            return false;
        }
        if (this.inventory[0].func_190916_E() < this.curRecipe.getInput().func_190916_E()) {
            return false;
        }
        boolean bl = augmentPetrotheumCheck = this.augmentPetrotheum && PulverizerManager.isOre(this.inventory[0]);
        if (augmentPetrotheumCheck && this.tank.getFluidAmount() < 100) {
            return false;
        }
        ItemStack primaryItem = this.curRecipe.getPrimaryOutput();
        ItemStack secondaryItem = this.curRecipe.getSecondaryOutput();
        if (!(secondaryItem.func_190926_b() || this.inventory[2].func_190926_b() || this.augmentSecondaryNull)) {
            if (!ItemHelper.itemsIdentical((ItemStack)this.inventory[2], (ItemStack)secondaryItem)) {
                return false;
            }
            if (this.inventory[2].func_190916_E() + secondaryItem.func_190916_E() > secondaryItem.func_77976_d()) {
                return false;
            }
        }
        return this.inventory[1].func_190926_b() || ItemHelper.itemsIdentical((ItemStack)this.inventory[1], (ItemStack)primaryItem) && this.inventory[1].func_190916_E() + (augmentPetrotheumCheck ? TilePulverizer.getPetrotheumOutputAmount(primaryItem) : primaryItem.func_190916_E()) <= primaryItem.func_77976_d();
    }

    @Override
    protected boolean hasValidInput() {
        if (this.curRecipe == null) {
            this.getRecipe();
        }
        if (this.curRecipe == null) {
            return false;
        }
        if (this.augmentPetrotheum && PulverizerManager.isOre(this.inventory[0]) && this.tank.getFluidAmount() < 100) {
            return false;
        }
        return this.curRecipe.getInput().func_190916_E() <= this.inventory[0].func_190916_E();
    }

    @Override
    protected void clearRecipe() {
        this.curRecipe = null;
    }

    @Override
    protected void getRecipe() {
        this.curRecipe = PulverizerManager.getRecipe(this.inventory[0]);
    }

    @Override
    protected void processStart() {
        this.processRem = this.processMax = this.curRecipe.getEnergy() * this.energyMod / 100;
    }

    @Override
    protected void processFinish() {
        boolean augmentPetrotheumCheck;
        if (this.curRecipe == null) {
            this.getRecipe();
        }
        if (this.curRecipe == null) {
            this.processOff();
            return;
        }
        ItemStack primaryItem = this.curRecipe.getPrimaryOutput();
        ItemStack secondaryItem = this.curRecipe.getSecondaryOutput();
        boolean bl = augmentPetrotheumCheck = this.augmentPetrotheum && PulverizerManager.isOre(this.inventory[0]) && this.tank.getFluidAmount() >= 100;
        if (augmentPetrotheumCheck) {
            if (this.inventory[1].func_190926_b()) {
                this.inventory[1] = ItemHelper.cloneStack((ItemStack)primaryItem, (int)TilePulverizer.getPetrotheumOutputAmount(primaryItem));
            } else {
                this.inventory[1].func_190917_f(TilePulverizer.getPetrotheumOutputAmount(primaryItem));
            }
            this.tank.modifyFluidStored(-100);
        } else if (this.inventory[1].func_190926_b()) {
            this.inventory[1] = ItemHelper.cloneStack((ItemStack)primaryItem);
        } else {
            this.inventory[1].func_190917_f(primaryItem.func_190916_E());
        }
        if (!secondaryItem.func_190926_b()) {
            int modifiedChance = augmentPetrotheumCheck ? this.secondaryChance - 25 : this.secondaryChance;
            modifiedChance = MathHelper.clamp((int)modifiedChance, (int)5, (int)100);
            int recipeChance = this.curRecipe.getSecondaryOutputChance();
            if (recipeChance >= 100 || this.field_145850_b.field_73012_v.nextInt(modifiedChance) < recipeChance) {
                if (this.inventory[2].func_190926_b()) {
                    this.inventory[2] = ItemHelper.cloneStack((ItemStack)secondaryItem);
                } else if (this.inventory[2].func_77969_a(secondaryItem)) {
                    this.inventory[2].func_190917_f(secondaryItem.func_190916_E());
                }
                if (recipeChance > modifiedChance && this.field_145850_b.field_73012_v.nextInt(100) < recipeChance - modifiedChance) {
                    this.inventory[2].func_190917_f(secondaryItem.func_190916_E());
                }
                if (this.inventory[2].func_190916_E() > this.inventory[2].func_77976_d()) {
                    this.inventory[2].func_190920_e(this.inventory[2].func_77976_d());
                }
            }
        }
        this.inventory[0].func_190918_g(this.curRecipe.getInput().func_190916_E());
        if (this.inventory[0].func_190916_E() <= 0) {
            this.inventory[0] = ItemStack.field_190927_a;
        }
    }

    @Override
    protected void transferInput() {
        if (!this.getTransferIn()) {
            return;
        }
        for (int i = this.inputTracker + 1; i <= this.inputTracker + 6; ++i) {
            int side = i % 6;
            if (!SideConfig.isPrimaryInput((int)this.sideConfig.sideTypes[this.sideCache[side]]) || !this.extractItem(0, ITEM_TRANSFER[this.level], EnumFacing.field_82609_l[side])) continue;
            this.inputTracker = side;
            break;
        }
    }

    @Override
    protected void transferOutput() {
        int side;
        int i;
        if (!this.getTransferOut()) {
            return;
        }
        if (!this.inventory[1].func_190926_b()) {
            for (i = this.outputTrackerPrimary + 1; i <= this.outputTrackerPrimary + 6; ++i) {
                side = i % 6;
                if (!SideConfig.isPrimaryOutput((int)this.sideConfig.sideTypes[this.sideCache[side]]) || !this.transferItem(1, ITEM_TRANSFER[this.level], EnumFacing.field_82609_l[side])) continue;
                this.outputTrackerPrimary = side;
                break;
            }
        }
        if (this.inventory[2].func_190926_b()) {
            return;
        }
        for (i = this.outputTrackerSecondary + 1; i <= this.outputTrackerSecondary + 6; ++i) {
            side = i % 6;
            if (!SideConfig.isSecondaryOutput((int)this.sideConfig.sideTypes[this.sideCache[side]]) || !this.transferItem(2, ITEM_TRANSFER[this.level], EnumFacing.field_82609_l[side])) continue;
            this.outputTrackerSecondary = side;
            break;
        }
    }

    public Object getGuiClient(InventoryPlayer inventory) {
        return new GuiPulverizer(inventory, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventory) {
        return new ContainerPulverizer(inventory, (TileEntity)this);
    }

    public FluidTankCore getTank() {
        return this.tank;
    }

    public FluidStack getTankFluid() {
        return this.tank.getFluid();
    }

    public boolean augmentPetrotheum() {
        return this.augmentPetrotheum && this.flagPetrotheum;
    }

    public boolean fluidArrow() {
        return this.augmentPetrotheum && this.tank.getFluidAmount() >= 100 && PulverizerManager.isOre(this.inventory[0]);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.inputTracker = nbt.func_74762_e("TrackIn");
        this.outputTrackerPrimary = nbt.func_74762_e("TrackOut");
        this.outputTrackerSecondary = nbt.func_74762_e("TrackOut2");
        this.tank.readFromNBT(nbt);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("TrackIn", this.inputTracker);
        nbt.func_74768_a("TrackOut", this.outputTrackerPrimary);
        nbt.func_74768_a("TrackOut2", this.outputTrackerSecondary);
        this.tank.writeToNBT(nbt);
        return nbt;
    }

    @Override
    public PacketBase getGuiPacket() {
        PacketBase payload = super.getGuiPacket();
        payload.addBool(this.augmentPetrotheum);
        payload.addFluidStack(this.tank.getFluid());
        return payload;
    }

    @Override
    protected void handleGuiPacket(PacketBase payload) {
        super.handleGuiPacket(payload);
        this.flagPetrotheum = this.augmentPetrotheum = payload.getBool();
        this.tank.setFluid(payload.getFluidStack());
    }

    @Override
    protected void preAugmentInstall() {
        super.preAugmentInstall();
        this.augmentGeode = false;
        this.augmentPetrotheum = false;
    }

    @Override
    protected void postAugmentInstall() {
        super.postAugmentInstall();
        if (!this.augmentPetrotheum) {
            this.tank.drain(this.tank.getCapacity(), true);
        }
    }

    @Override
    protected boolean installAugmentToSlot(int slot) {
        String id = AugmentHelper.getAugmentIdentifier((ItemStack)this.augments[slot]);
        if (!this.augmentGeode && "machinePulverizerGeode".equals(id)) {
            this.augmentGeode = true;
            this.hasModeAugment = true;
            this.energyMod += 25;
            return true;
        }
        if (!this.augmentPetrotheum && "machinePulverizerPetrotheum".equals(id)) {
            this.augmentPetrotheum = true;
            this.hasModeAugment = true;
            this.energyMod += 50;
            this.tank.setLock(TFFluids.fluidPetrotheum);
            return true;
        }
        return super.installAugmentToSlot(slot);
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return slot != 0 || PulverizerManager.recipeExists(stack);
    }

    public SoundEvent getSoundEvent() {
        return TEProps.enableSounds ? TESounds.machinePulverizer : null;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing from) {
        return super.hasCapability(capability, from) || this.augmentPetrotheum && capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    public <T> T getCapability(Capability<T> capability, final EnumFacing from) {
        if (this.augmentPetrotheum && capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)new IFluidHandler(){

                public IFluidTankProperties[] getTankProperties() {
                    FluidTankInfo info = TilePulverizer.this.tank.getInfo();
                    return new IFluidTankProperties[]{new FluidTankProperties(info.fluid, info.capacity, true, false)};
                }

                public int fill(FluidStack resource, boolean doFill) {
                    return TilePulverizer.this.tank.fill(resource, doFill);
                }

                @Nullable
                public FluidStack drain(FluidStack resource, boolean doDrain) {
                    if (TilePulverizer.this.isActive) {
                        return null;
                    }
                    if (from == null || SideConfig.allowExtraction((int)((TilePulverizer)TilePulverizer.this).sideConfig.sideTypes[TilePulverizer.this.sideCache[from.ordinal()]])) {
                        return TilePulverizer.this.tank.drain(resource, doDrain);
                    }
                    return null;
                }

                @Nullable
                public FluidStack drain(int maxDrain, boolean doDrain) {
                    if (TilePulverizer.this.isActive) {
                        return null;
                    }
                    if (from == null || SideConfig.allowExtraction((int)((TilePulverizer)TilePulverizer.this).sideConfig.sideTypes[TilePulverizer.this.sideCache[from.ordinal()]])) {
                        return TilePulverizer.this.tank.drain(maxDrain, doDrain);
                    }
                    return null;
                }
            });
        }
        return (T)super.getCapability(capability, from);
    }
}

