/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.machine;

import cofh.core.fluid.FluidTankCore;
import cofh.core.network.PacketBase;
import cofh.core.util.core.EnergyConfig;
import cofh.core.util.core.SideConfig;
import cofh.core.util.core.SlotConfig;
import cofh.core.util.helpers.AugmentHelper;
import cofh.core.util.helpers.FluidHelper;
import cofh.core.util.helpers.ItemHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.machine.BlockMachine;
import cofh.thermalexpansion.block.machine.TileMachineBase;
import cofh.thermalexpansion.gui.client.machine.GuiFurnace;
import cofh.thermalexpansion.gui.container.machine.ContainerFurnace;
import cofh.thermalexpansion.init.TEProps;
import cofh.thermalexpansion.init.TESounds;
import cofh.thermalexpansion.util.managers.machine.FurnaceManager;
import cofh.thermalfoundation.init.TFFluids;
import java.util.Arrays;
import java.util.HashSet;
import javax.annotation.Nullable;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class TileFurnace
extends TileMachineBase {
    private static final int TYPE = BlockMachine.Type.FURNACE.getMetadata();
    public static int basePower = 20;
    public static final int FOOD_ENERGY_MOD = 50;
    public static final int ORE_ENERGY_MOD = 50;
    public static final int PYRO_ENERGY_MOD = 50;
    private FurnaceManager.FurnaceRecipe curRecipe;
    private int inputTracker;
    private int outputTracker;
    private int outputTrackerFluid;
    private FluidTankCore tank = new FluidTankCore(4000);
    protected boolean augmentFood;
    protected boolean augmentOre;
    protected boolean augmentPyrolysis;
    protected boolean flagPyrolysis;

    public static void initialize() {
        TileFurnace.SIDE_CONFIGS[TileFurnace.TYPE] = new SideConfig();
        TileFurnace.SIDE_CONFIGS[TileFurnace.TYPE].numConfig = 5;
        TileFurnace.SIDE_CONFIGS[TileFurnace.TYPE].slotGroups = new int[][]{new int[0], {0}, {1}, {0, 1}, {0, 1}};
        TileFurnace.SIDE_CONFIGS[TileFurnace.TYPE].sideTypes = new int[]{0, 1, 4, 7, 8};
        TileFurnace.SIDE_CONFIGS[TileFurnace.TYPE].defaultSides = new byte[]{1, 1, 2, 2, 2, 2};
        TileFurnace.ALT_SIDE_CONFIGS[TileFurnace.TYPE] = new SideConfig();
        TileFurnace.ALT_SIDE_CONFIGS[TileFurnace.TYPE].numConfig = 2;
        TileFurnace.ALT_SIDE_CONFIGS[TileFurnace.TYPE].slotGroups = new int[][]{new int[0], {0}, {1}, {0, 1}, {0, 1}};
        TileFurnace.ALT_SIDE_CONFIGS[TileFurnace.TYPE].sideTypes = new int[]{0, 7};
        TileFurnace.ALT_SIDE_CONFIGS[TileFurnace.TYPE].defaultSides = new byte[]{1, 1, 1, 1, 1, 1};
        TileFurnace.SLOT_CONFIGS[TileFurnace.TYPE] = new SlotConfig();
        TileFurnace.SLOT_CONFIGS[TileFurnace.TYPE].allowInsertionSlot = new boolean[]{true, false, false};
        TileFurnace.SLOT_CONFIGS[TileFurnace.TYPE].allowExtractionSlot = new boolean[]{false, true, false};
        TileFurnace.VALID_AUGMENTS[TileFurnace.TYPE] = new HashSet();
        VALID_AUGMENTS[TYPE].add("machineFurnaceFood");
        VALID_AUGMENTS[TYPE].add("machineFurnaceOre");
        VALID_AUGMENTS[TYPE].add("machineFurnacePyrolysis");
        TileFurnace.LIGHT_VALUES[TileFurnace.TYPE] = 14;
        GameRegistry.registerTileEntity(TileFurnace.class, (String)"thermalexpansion:machine_furnace");
        TileFurnace.config();
    }

    public static void config() {
        String category = "Machine.Furnace";
        BlockMachine.enable[TileFurnace.TYPE] = ThermalExpansion.CONFIG.get(category, "Enable", true);
        String comment = "Adjust this value to change the Energy consumption (in RF/t) for a Redstone Furnace. This base value will scale with block level and Augments.";
        basePower = ThermalExpansion.CONFIG.getConfiguration().getInt("BasePower", category, basePower, 10, 5000, comment);
        TileFurnace.ENERGY_CONFIGS[TileFurnace.TYPE] = new EnergyConfig();
        ENERGY_CONFIGS[TYPE].setDefaultParams(basePower, smallStorage);
    }

    public TileFurnace() {
        this.inventory = new ItemStack[3];
        Arrays.fill(this.inventory, ItemStack.field_190927_a);
        this.createAllSlots(this.inventory.length);
        this.tank.setLock(TFFluids.fluidCreosote);
    }

    public int getType() {
        return TYPE;
    }

    @Override
    protected int calcEnergy() {
        if (this.augmentPyrolysis) {
            return Math.min(this.energyConfig.minPower, this.energyStorage.getEnergyStored());
        }
        return super.calcEnergy();
    }

    @Override
    protected boolean canStart() {
        if (this.inventory[0].func_190926_b() || this.energyStorage.getEnergyStored() <= 0) {
            return false;
        }
        if (this.augmentFood && !FurnaceManager.isFood(this.inventory[0]) || this.augmentOre && !FurnaceManager.isOre(this.inventory[0])) {
            return false;
        }
        this.getRecipe();
        if (this.curRecipe == null) {
            return false;
        }
        if (this.inventory[0].func_190916_E() < this.curRecipe.getInput().func_190916_E()) {
            return false;
        }
        ItemStack output = this.curRecipe.getOutput();
        return this.inventory[1].func_190926_b() || ItemHelper.itemsIdentical((ItemStack)this.inventory[1], (ItemStack)output) && this.inventory[1].func_190916_E() + output.func_190916_E() <= output.func_77976_d();
    }

    @Override
    protected boolean hasValidInput() {
        if (this.augmentFood && !FurnaceManager.isFood(this.inventory[0]) || this.augmentOre && !FurnaceManager.isOre(this.inventory[0])) {
            return false;
        }
        if (this.curRecipe == null) {
            this.getRecipe();
        }
        if (this.curRecipe == null) {
            return false;
        }
        return this.curRecipe.getInput().func_190916_E() <= this.inventory[0].func_190916_E();
    }

    @Override
    protected void clearRecipe() {
        this.curRecipe = null;
    }

    @Override
    protected void getRecipe() {
        this.curRecipe = FurnaceManager.getRecipe(this.inventory[0], this.augmentPyrolysis);
    }

    @Override
    protected void processStart() {
        this.processRem = this.processMax = this.curRecipe.getEnergy() * this.energyMod / 100;
    }

    @Override
    protected void processFinish() {
        if (this.curRecipe == null) {
            this.getRecipe();
        }
        if (this.curRecipe == null) {
            this.processOff();
            return;
        }
        ItemStack output = this.curRecipe.getOutput();
        if (this.inventory[1].func_190926_b()) {
            this.inventory[1] = ItemHelper.cloneStack((ItemStack)output);
        } else {
            this.inventory[1].func_190917_f(output.func_190916_E());
        }
        if (this.augmentPyrolysis) {
            this.tank.fill(new FluidStack(TFFluids.fluidCreosote, this.curRecipe.getCreosote()), true);
        } else if ((this.augmentFood && FurnaceManager.isFood(this.inventory[0]) || this.augmentOre && FurnaceManager.isOre(this.inventory[0])) && this.inventory[1].func_190916_E() < this.inventory[1].func_77976_d()) {
            this.inventory[1].func_190917_f(Math.max(1, output.func_190916_E() / 2));
        }
        this.inventory[0].func_190918_g(this.curRecipe.getInput().func_190916_E());
        if (this.inventory[0].func_190916_E() <= 0) {
            this.inventory[0] = ItemStack.field_190927_a;
        }
    }

    @Override
    protected void transferInput() {
        if (!this.getTransferIn()) {
            return;
        }
        for (int i = this.inputTracker + 1; i <= this.inputTracker + 6; ++i) {
            int side = i % 6;
            if (!SideConfig.isPrimaryInput((int)this.sideConfig.sideTypes[this.sideCache[side]]) || !this.extractItem(0, ITEM_TRANSFER[this.level], EnumFacing.field_82609_l[side])) continue;
            this.inputTracker = side;
            break;
        }
    }

    @Override
    protected void transferOutput() {
        if (!this.getTransferOut()) {
            return;
        }
        if (this.augmentPyrolysis) {
            this.transferOutputFluid();
        }
        if (this.inventory[1].func_190926_b()) {
            return;
        }
        for (int i = this.outputTracker + 1; i <= this.outputTracker + 6; ++i) {
            int side = i % 6;
            if (!SideConfig.isPrimaryOutput((int)this.sideConfig.sideTypes[this.sideCache[side]]) || !this.transferItem(1, ITEM_TRANSFER[this.level], EnumFacing.field_82609_l[side])) continue;
            this.outputTracker = side;
            break;
        }
    }

    private void transferOutputFluid() {
        if (!this.getTransferOut()) {
            return;
        }
        if (this.tank.getFluidAmount() <= 0) {
            return;
        }
        FluidStack output = new FluidStack(this.tank.getFluid(), Math.min(this.tank.getFluidAmount(), FLUID_TRANSFER[this.level]));
        for (int i = this.outputTrackerFluid + 1; i <= this.outputTrackerFluid + 6; ++i) {
            int toDrain;
            int side = i % 6;
            if (!SideConfig.isPrimaryOutput((int)this.sideConfig.sideTypes[this.sideCache[side]]) || (toDrain = FluidHelper.insertFluidIntoAdjacentFluidHandler((TileEntity)this, (EnumFacing)EnumFacing.field_82609_l[side], (FluidStack)output, (boolean)true)) <= 0) continue;
            this.tank.drain(toDrain, true);
            this.outputTrackerFluid = side;
            break;
        }
    }

    @Override
    public void func_73660_a() {
        if (this.augmentPyrolysis && this.timeCheckEighth()) {
            this.transferOutputFluid();
        }
        super.func_73660_a();
    }

    public Object getGuiClient(InventoryPlayer inventory) {
        return new GuiFurnace(inventory, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventory) {
        return new ContainerFurnace(inventory, (TileEntity)this);
    }

    public FluidTankCore getTank() {
        return this.tank;
    }

    public FluidStack getTankFluid() {
        return this.tank.getFluid();
    }

    public boolean augmentFood() {
        return this.augmentFood;
    }

    public boolean augmentOre() {
        return this.augmentOre;
    }

    public boolean augmentPyrolysis() {
        return this.augmentPyrolysis;
    }

    public boolean augmentPyrolysisClient() {
        return this.augmentPyrolysis && this.flagPyrolysis;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.inputTracker = nbt.func_74762_e("TrackIn");
        this.outputTracker = nbt.func_74762_e("TrackOut");
        this.outputTrackerFluid = nbt.func_74762_e("TrackOutFluid");
        this.tank.readFromNBT(nbt);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("TrackIn", this.inputTracker);
        nbt.func_74768_a("TrackOut", this.outputTracker);
        nbt.func_74768_a("TrackOutFluid", this.outputTrackerFluid);
        this.tank.writeToNBT(nbt);
        return nbt;
    }

    @Override
    public PacketBase getGuiPacket() {
        PacketBase payload = super.getGuiPacket();
        payload.addBool(this.augmentFood);
        payload.addBool(this.augmentOre);
        payload.addBool(this.augmentPyrolysis);
        payload.addFluidStack(this.tank.getFluid());
        return payload;
    }

    @Override
    protected void handleGuiPacket(PacketBase payload) {
        super.handleGuiPacket(payload);
        this.augmentFood = payload.getBool();
        this.augmentOre = payload.getBool();
        this.flagPyrolysis = this.augmentPyrolysis = payload.getBool();
        this.tank.setFluid(payload.getFluidStack());
    }

    @Override
    protected void preAugmentInstall() {
        super.preAugmentInstall();
        this.augmentFood = false;
        this.augmentOre = false;
        this.augmentPyrolysis = false;
    }

    @Override
    protected void postAugmentInstall() {
        super.postAugmentInstall();
        if (!this.augmentPyrolysis) {
            this.tank.clearLocked();
            this.tank.setFluid(null);
        }
    }

    @Override
    protected boolean installAugmentToSlot(int slot) {
        String id = AugmentHelper.getAugmentIdentifier((ItemStack)this.augments[slot]);
        if (!this.augmentFood && "machineFurnaceFood".equals(id)) {
            this.augmentFood = true;
            this.hasModeAugment = true;
            this.energyMod += 50;
            return true;
        }
        if (!this.augmentOre && "machineFurnaceOre".equals(id)) {
            this.augmentOre = true;
            this.hasModeAugment = true;
            this.energyMod += 50;
            return true;
        }
        if (!this.augmentPyrolysis && "machineFurnacePyrolysis".equals(id)) {
            this.augmentPyrolysis = true;
            this.hasModeAugment = true;
            this.energyMod += 50;
            this.tank.setLock(TFFluids.fluidCreosote);
            return true;
        }
        return super.installAugmentToSlot(slot);
    }

    @Override
    public int getInfoMaxEnergyPerTick() {
        return this.augmentPyrolysis ? this.energyConfig.minPower : this.energyConfig.maxPower;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return slot != 0 || (this.augmentFood ? FurnaceManager.isFood(stack) : (this.augmentOre ? FurnaceManager.isOre(stack) && FurnaceManager.recipeExists(stack, this.augmentPyrolysis) : FurnaceManager.recipeExists(stack, this.augmentPyrolysis)));
    }

    public SoundEvent getSoundEvent() {
        return TEProps.enableSounds ? TESounds.machineFurnace : null;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing from) {
        return super.hasCapability(capability, from) || this.augmentPyrolysis && capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    public <T> T getCapability(Capability<T> capability, final EnumFacing from) {
        if (this.augmentPyrolysis && capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)new IFluidHandler(){

                public IFluidTankProperties[] getTankProperties() {
                    FluidTankInfo info = TileFurnace.this.tank.getInfo();
                    return new IFluidTankProperties[]{new FluidTankProperties(info.fluid, info.capacity, true, false)};
                }

                public int fill(FluidStack resource, boolean doFill) {
                    return 0;
                }

                @Nullable
                public FluidStack drain(FluidStack resource, boolean doDrain) {
                    if (from == null || SideConfig.allowExtraction((int)((TileFurnace)TileFurnace.this).sideConfig.sideTypes[TileFurnace.this.sideCache[from.ordinal()]])) {
                        return TileFurnace.this.tank.drain(resource, doDrain);
                    }
                    return null;
                }

                @Nullable
                public FluidStack drain(int maxDrain, boolean doDrain) {
                    if (from == null || SideConfig.allowExtraction((int)((TileFurnace)TileFurnace.this).sideConfig.sideTypes[TileFurnace.this.sideCache[from.ordinal()]])) {
                        return TileFurnace.this.tank.drain(maxDrain, doDrain);
                    }
                    return null;
                }
            });
        }
        return (T)super.getCapability(capability, from);
    }
}

