/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.block.device;

import cofh.api.core.IAccelerable;
import cofh.core.fluid.FluidTankCore;
import cofh.core.gui.container.ContainerTileAugmentable;
import cofh.core.network.PacketBase;
import cofh.core.util.core.SideConfig;
import cofh.core.util.core.SlotConfig;
import cofh.core.util.helpers.BlockHelper;
import cofh.core.util.helpers.RenderHelper;
import cofh.thermalexpansion.ThermalExpansion;
import cofh.thermalexpansion.block.device.BlockDevice;
import cofh.thermalexpansion.block.device.TileDeviceBase;
import cofh.thermalexpansion.gui.client.device.GuiHeatSink;
import cofh.thermalexpansion.init.TETextures;
import cofh.thermalexpansion.util.managers.device.CoolantManager;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileHeatSink
extends TileDeviceBase
implements ITickable {
    private static final int TYPE = BlockDevice.Type.HEAT_SINK.getMetadata();
    public static int fluidAmount = 100;
    public static final int USE_FACTOR = 5;
    private boolean cached;
    private IAccelerable[] accelerables = new IAccelerable[6];
    private FluidTankCore tank = new FluidTankCore(4000);
    private FluidStack renderFluid = new FluidStack(FluidRegistry.WATER, 0);
    private int coolantRF;
    private int coolantFactor = 20;

    public static void initialize() {
        TileHeatSink.SIDE_CONFIGS[TileHeatSink.TYPE] = new SideConfig();
        TileHeatSink.SIDE_CONFIGS[TileHeatSink.TYPE].numConfig = 2;
        TileHeatSink.SIDE_CONFIGS[TileHeatSink.TYPE].slotGroups = new int[][]{new int[0], new int[0]};
        TileHeatSink.SIDE_CONFIGS[TileHeatSink.TYPE].sideTypes = new int[]{0, 1};
        TileHeatSink.SIDE_CONFIGS[TileHeatSink.TYPE].defaultSides = new byte[]{0, 1, 1, 1, 1, 1};
        TileHeatSink.SLOT_CONFIGS[TileHeatSink.TYPE] = new SlotConfig();
        TileHeatSink.SLOT_CONFIGS[TileHeatSink.TYPE].allowInsertionSlot = new boolean[0];
        TileHeatSink.SLOT_CONFIGS[TileHeatSink.TYPE].allowExtractionSlot = new boolean[0];
        TileHeatSink.LIGHT_VALUES[TileHeatSink.TYPE] = 3;
        GameRegistry.registerTileEntity(TileHeatSink.class, (String)"thermalexpansion:device_heat_sink");
        TileHeatSink.config();
    }

    public static void config() {
        String category = "Device.HeatSink";
        BlockDevice.enable[TileHeatSink.TYPE] = ThermalExpansion.CONFIG.get(category, "Enable", true);
    }

    public int getType() {
        return TYPE;
    }

    public void onNeighborBlockChange() {
        super.onNeighborBlockChange();
        this.updateAdjacentHandlers();
    }

    public void func_73660_a() {
        boolean curActive = this.isActive;
        if (this.isActive) {
            if (this.coolantRF <= 0) {
                if (this.tank.getFluidAmount() >= fluidAmount) {
                    String prevID = this.renderFluid.getFluid().getName();
                    this.coolantRF += CoolantManager.getCoolantRF100mB(this.tank.getFluid());
                    this.coolantFactor = CoolantManager.getCoolantFactor(this.tank.getFluid());
                    if (!prevID.equals(this.renderFluid.getFluid().getName())) {
                        this.sendFluidPacket();
                    }
                    this.tank.drain(fluidAmount, true);
                    if (this.field_145850_b.field_73012_v.nextInt(100) < this.coolantFactor) {
                        this.updateAccelerables();
                    }
                } else {
                    this.isActive = false;
                }
            } else if (this.field_145850_b.field_73012_v.nextInt(100) < this.coolantFactor) {
                this.updateAccelerables();
            }
            if (!this.redstoneControlOrDisable()) {
                this.isActive = false;
            }
        } else if (this.redstoneControlOrDisable() && this.canStart()) {
            this.isActive = true;
        }
        if (!this.cached) {
            this.updateAdjacentHandlers();
        }
        this.updateIfChanged(curActive);
    }

    protected void updateAdjacentHandlers() {
        for (int i = 0; i < 6; ++i) {
            this.accelerables[i] = null;
            TileEntity tile = BlockHelper.getAdjacentTileEntity((TileEntity)this, (int)i);
            if (!(tile instanceof IAccelerable)) continue;
            this.accelerables[i] = (IAccelerable)tile;
        }
        this.cached = true;
    }

    protected boolean canStart() {
        return this.coolantRF > 0 || this.tank.getFluidAmount() >= fluidAmount;
    }

    protected void updateAccelerables() {
        for (int i = 0; i < 6; ++i) {
            if (this.accelerables[i] == null) continue;
            this.coolantRF -= 5 * this.accelerables[i].updateAccelerable();
        }
    }

    public int getScaledSpeed(int scale) {
        return this.isActive ? 16 : 0;
    }

    public Object getGuiClient(InventoryPlayer inventory) {
        return new GuiHeatSink(inventory, (TileEntity)this);
    }

    public Object getGuiServer(InventoryPlayer inventory) {
        return new ContainerTileAugmentable(inventory, (TileEntity)this);
    }

    public FluidTankCore getTank() {
        return this.tank;
    }

    public FluidStack getTankFluid() {
        return this.tank.getFluid();
    }

    public int getCoolantRF() {
        return this.coolantRF;
    }

    public int getCoolantFactor() {
        return this.coolantFactor;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.coolantRF = nbt.func_74762_e("Coolant");
        this.coolantFactor = nbt.func_74762_e("CoolantFactor");
        this.tank.readFromNBT(nbt);
        if (!CoolantManager.isValidCoolant(this.tank.getFluid())) {
            this.tank.setFluid(null);
        }
        if (this.coolantFactor <= 0) {
            this.coolantFactor = 20;
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74768_a("Coolant", this.coolantRF);
        nbt.func_74768_a("CoolantFactor", this.coolantFactor);
        this.tank.writeToNBT(nbt);
        return nbt;
    }

    public PacketBase getFluidPacket() {
        PacketBase payload = super.getFluidPacket();
        payload.addFluidStack(this.renderFluid);
        return payload;
    }

    public PacketBase getGuiPacket() {
        PacketBase payload = super.getGuiPacket();
        payload.addInt(this.coolantRF);
        payload.addInt(this.coolantFactor);
        if (this.tank.getFluid() == null) {
            payload.addFluidStack(this.renderFluid);
        } else {
            payload.addFluidStack(this.tank.getFluid());
        }
        return payload;
    }

    public PacketBase getTilePacket() {
        PacketBase payload = super.getTilePacket();
        if (this.tank.getFluid() == null) {
            payload.addFluidStack(this.renderFluid);
        } else {
            payload.addFluidStack(this.tank.getFluid());
        }
        return payload;
    }

    protected void handleFluidPacket(PacketBase payload) {
        super.handleFluidPacket(payload);
        this.renderFluid = payload.getFluidStack();
        this.callBlockUpdate();
    }

    protected void handleGuiPacket(PacketBase payload) {
        super.handleGuiPacket(payload);
        this.coolantRF = payload.getInt();
        this.coolantFactor = payload.getInt();
        this.tank.setFluid(payload.getFluidStack());
    }

    @SideOnly(value=Side.CLIENT)
    public void handleTilePacket(PacketBase payload) {
        super.handleTilePacket(payload);
        this.renderFluid = payload.getFluidStack();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture(int side, int pass) {
        if (pass == 0) {
            if (side == 0) {
                return TETextures.DEVICE_BOTTOM;
            }
            if (side == 1) {
                return TETextures.DEVICE_TOP;
            }
            return side != this.facing ? TETextures.DEVICE_SIDE : (this.isActive ? RenderHelper.getFluidTexture((FluidStack)this.renderFluid) : TETextures.DEVICE_FACE[TYPE]);
        }
        if (side < 6) {
            return side != this.facing ? TETextures.CONFIG[this.sideConfig.sideTypes[this.sideCache[side]]] : (this.isActive ? TETextures.DEVICE_ACTIVE[TYPE] : TETextures.DEVICE_FACE[TYPE]);
        }
        return TETextures.DEVICE_SIDE;
    }

    @Override
    public boolean hasFluidUnderlay() {
        return true;
    }

    @Override
    public FluidStack getRenderFluid() {
        return this.renderFluid;
    }

    @Override
    public int getColorMask(BlockRenderLayer layer, EnumFacing side) {
        return layer == BlockRenderLayer.SOLID && side.ordinal() == this.facing && this.isActive ? this.renderFluid.getFluid().getColor(this.renderFluid) << 8 | 0xFF : super.getColorMask(layer, side);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing from) {
        return super.hasCapability(capability, from) || capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY;
    }

    public <T> T getCapability(Capability<T> capability, final EnumFacing from) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY.cast((Object)new IFluidHandler(){

                public IFluidTankProperties[] getTankProperties() {
                    FluidTankInfo info = TileHeatSink.this.tank.getInfo();
                    return new IFluidTankProperties[]{new FluidTankProperties(info.fluid, info.capacity, true, true)};
                }

                public int fill(FluidStack resource, boolean doFill) {
                    if (CoolantManager.isValidCoolant(resource) && (from == null || SideConfig.allowInsertion((int)((TileHeatSink)TileHeatSink.this).sideConfig.sideTypes[TileHeatSink.this.sideCache[from.ordinal()]]))) {
                        return TileHeatSink.this.tank.fill(resource, doFill);
                    }
                    return 0;
                }

                @Nullable
                public FluidStack drain(FluidStack resource, boolean doDrain) {
                    if (from == null || SideConfig.allowExtraction((int)((TileHeatSink)TileHeatSink.this).sideConfig.sideTypes[TileHeatSink.this.sideCache[from.ordinal()]])) {
                        return TileHeatSink.this.tank.drain(resource, doDrain);
                    }
                    return null;
                }

                @Nullable
                public FluidStack drain(int maxDrain, boolean doDrain) {
                    if (from == null || SideConfig.allowExtraction((int)((TileHeatSink)TileHeatSink.this).sideConfig.sideTypes[TileHeatSink.this.sideCache[from.ordinal()]])) {
                        return TileHeatSink.this.tank.drain(maxDrain, doDrain);
                    }
                    return null;
                }
            });
        }
        return (T)super.getCapability(capability, from);
    }
}

