/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.render;

import java.text.SimpleDateFormat;
import java.util.Date;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.model.ModelSkeletonHead;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ovh.corail.tombstone.ConfigTombstone;
import ovh.corail.tombstone.block.BlockGraveBase;
import ovh.corail.tombstone.block.GraveModel;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.TextureHelper;
import ovh.corail.tombstone.tileentity.TileEntityWritableGrave;

@SideOnly(value=Side.CLIENT)
public class RenderWritableGrave
extends TileEntitySpecialRenderer<TileEntityWritableGrave> {
    private final ModelSkeletonHead skeletonHead = new ModelSkeletonHead(0, 0, 64, 32);

    public void render(TileEntityWritableGrave te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        int rotationIndex;
        float modY;
        float value;
        boolean renderHalloween;
        if (te == null) {
            return;
        }
        boolean bl = renderHalloween = ConfigTombstone.client.graveSkinRule == ConfigTombstone.CatClient.GraveSkinRule.FORCE_HALLOWEEN || Helper.isDateAroundHalloween(te.func_145831_w()) && ConfigTombstone.client.graveSkinRule != ConfigTombstone.CatClient.GraveSkinRule.FORCE_NORMAL;
        if (!te.hasOwner() && !renderHalloween) {
            return;
        }
        IBlockState knownState = te.func_145831_w().func_180495_p(te.func_174877_v());
        if (!(knownState.func_177230_c() instanceof BlockGraveBase)) {
            return;
        }
        EnumFacing facing = (EnumFacing)knownState.func_177229_b((IProperty)BlockGraveBase.FACING);
        BlockGraveBase grave = (BlockGraveBase)knownState.func_177230_c();
        if (renderHalloween) {
            GlStateManager.func_179091_B();
            GlStateManager.func_179094_E();
            GlStateManager.func_179129_p();
            GlStateManager.func_179141_d();
            float modX = 0.5f;
            float modY2 = 0.07f;
            float modZ = 0.5f;
            block0 : switch (grave.getGraveType()) {
                case GRAVE_NORMAL: {
                    modY2 += 0.35f;
                    break;
                }
                case GRAVE_CROSS: {
                    switch (facing) {
                        case SOUTH: {
                            modZ -= 0.3f;
                            modX -= 0.4f;
                            break block0;
                        }
                        case WEST: {
                            modX += 0.3f;
                            modZ -= 0.4f;
                            break block0;
                        }
                        case EAST: {
                            modX -= 0.3f;
                            modZ += 0.4f;
                            break block0;
                        }
                    }
                    modZ += 0.3f;
                    modX += 0.4f;
                    break;
                }
                case TOMBSTONE: {
                    modY2 += 0.6f;
                    break;
                }
                default: {
                    modY2 += 0.1f;
                }
            }
            TextureHelper.SKELETON_HEAD.bindTexture();
            GlStateManager.func_179109_b((float)((float)x + modX), (float)((float)y + modY2), (float)((float)z + modZ));
            GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)facing.func_185119_l(), (float)0.0f, (float)1.0f, (float)0.0f);
            if (grave.getGraveType() == GraveModel.GRAVE_NORMAL || grave.getGraveType() == GraveModel.GRAVE_SIMPLE) {
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GlStateManager.func_179152_a((float)0.2f, (float)0.2f, (float)0.2f);
                Minecraft.func_71410_x().func_175599_af().func_181564_a(new ItemStack(Helper.isNight(te.func_145831_w()) ? Blocks.field_150428_aP : Blocks.field_150423_aK), ItemCameraTransforms.TransformType.NONE);
            } else {
                this.skeletonHead.func_78088_a(null, partialTicks, 0.0f, 0.0f, 0.0f, 0.0f, 0.015625f);
            }
            GlStateManager.func_179121_F();
        }
        if (!te.hasOwner()) {
            return;
        }
        float modX = 0.5f;
        float modZ = 0.5f;
        switch (grave.getGraveType()) {
            case GRAVE_CROSS: {
                value = 0.25f;
                modY = 0.06375f;
                break;
            }
            case GRAVE_NORMAL: {
                value = 0.12625f;
                modY = 0.5f;
                break;
            }
            case GRAVE_SIMPLE: {
                value = 0.18875f;
                modY = 0.4f;
                break;
            }
            default: {
                value = 0.56375f;
                modY = 0.25f;
            }
        }
        boolean is_cross = grave.getGraveType() == GraveModel.GRAVE_CROSS;
        switch (facing) {
            case SOUTH: {
                rotationIndex = 0;
                if (is_cross) {
                    modZ = 1.0f - value;
                    break;
                }
                modZ = value;
                break;
            }
            case WEST: {
                rotationIndex = -1;
                if (is_cross) {
                    modX = value;
                    break;
                }
                modX = 1.0f - value;
                break;
            }
            case EAST: {
                rotationIndex = 1;
                if (is_cross) {
                    modX = 1.0f - value;
                    break;
                }
                modX = value;
                break;
            }
            default: {
                rotationIndex = 2;
                modZ = is_cross ? value : 1.0f - value;
            }
        }
        GlStateManager.func_179091_B();
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179140_f();
        GlStateManager.func_179109_b((float)((float)x + modX), (float)((float)y + modY), (float)((float)z + modZ));
        GlStateManager.func_179114_b((float)(90.0f * (float)rotationIndex), (float)0.0f, (float)1.0f, (float)0.0f);
        if (is_cross) {
            GlStateManager.func_179114_b((float)90.0f, (float)-1.0f, (float)0.0f, (float)0.0f);
        }
        GlStateManager.func_179132_a((boolean)false);
        FontRenderer fontRender = this.func_147498_b();
        GlStateManager.func_179094_E();
        float scale = 0.007f;
        GlStateManager.func_179152_a((float)scale, (float)(-scale), (float)scale);
        this.showString(TextFormatting.BOLD + LangKey.MESSAGE_RIP.getClientTranslation(new Object[0]), fontRender, 0, ConfigTombstone.client.textColorRIP + -16777216);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        scale = 0.005f;
        GlStateManager.func_179152_a((float)scale, (float)(-scale), (float)scale);
        this.showString(TextFormatting.BOLD + te.getOwnerName(), fontRender, 11, ConfigTombstone.client.textColorOwner + -16777216);
        GlStateManager.func_179121_F();
        GlStateManager.func_179094_E();
        scale = ConfigTombstone.client.dateInMCTime ? 0.005f : 0.004f;
        GlStateManager.func_179152_a((float)scale, (float)(-scale), (float)scale);
        int textColorDeathDate = ConfigTombstone.client.textColorDeathDate + -16777216;
        this.showString(TextFormatting.BOLD + LangKey.MESSAGE_DIED_ON.getClientTranslation(new Object[0]), fontRender, 26, textColorDeathDate);
        if (ConfigTombstone.client.dateInMCTime) {
            long days = te.countTicks / 24000;
            String dateString = LangKey.MESSAGE_DAY.getClientTranslation(days);
            this.showString(TextFormatting.BOLD + dateString, fontRender, 36, textColorDeathDate);
        } else {
            Date date = new Date(te.getOwnerDeathTime());
            String dateString = new SimpleDateFormat("dd/MM/yyyy").format(date);
            String timeString = LangKey.MESSAGE_AT.getClientTranslation(new Object[0]) + " " + new SimpleDateFormat("HH:mm:ss").format(date);
            this.showString(TextFormatting.BOLD + dateString, fontRender, 36, textColorDeathDate);
            this.showString(TextFormatting.BOLD + timeString, fontRender, 46, textColorDeathDate);
        }
        GlStateManager.func_179121_F();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179121_F();
        GlStateManager.func_179145_e();
    }

    private void showString(String content, FontRenderer fontRenderer, int posY, int color) {
        fontRenderer.func_175065_a(content, (float)(-fontRenderer.func_78256_a(content)) / 2.0f, (float)(posY - 30), color, true);
    }
}

