/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.block.BlockAnvil;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ovh.corail.tombstone.ConfigTombstone;
import ovh.corail.tombstone.command.CommandTBAcceptTeleport;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.item.ItemCraftingIngredient;
import ovh.corail.tombstone.item.ItemTablet;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemTabletOfAssistance
extends ItemTablet {
    public ItemTabletOfAssistance() {
        super("tablet_of_assistance");
    }

    @Override
    public String func_77653_i(ItemStack stack) {
        String name = LangKey.makeServerTranslation(this.func_77667_c(stack) + ".name", new Object[0]);
        return this.isEnchanted(stack) ? LangKey.MESSAGE_ENCHANTED_ITEM.getServerTranslation(name) : name;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag flag) {
        if (list.size() > 0) {
            list.set(0, StyleType.MESSAGE_SPECIAL.func_150218_j() + list.get(0));
        }
        if (Helper.canShowTooltip()) {
            if (!this.isEnchanted(stack)) {
                this.addItemDesc(list);
                this.addItemUse(list, "1", new Object[0]);
            } else {
                String engraved_name = this.getEngravedName(stack);
                if (engraved_name.isEmpty()) {
                    this.addItemDesc(list);
                    this.addItemUse(list, "2", StyleType.TOOLTIP_ITEM.func_150218_j() + "[" + ItemCraftingIngredient.IconType.GRAVE_DUST.getStack().func_82833_r() + "]");
                } else {
                    this.addInfo(list, LangKey.MESSAGE_ENGRAVED, "\"" + engraved_name + "\"");
                    this.addItemUse(list, "3", new Object[0]);
                }
            }
        }
        super.func_77624_a(stack, world, list, flag);
    }

    @Override
    public boolean canEnchant(World world, BlockPos gravePos, EntityPlayer player, ItemStack stack) {
        return ConfigTombstone.allowedMagicItems.allowTabletOfAssistance;
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return stack.func_77973_b() == this && NBTStackHelper.getBoolean(stack, "enchant");
    }

    @Override
    public boolean setEnchant(World world, BlockPos gravePos, EntityPlayer player, ItemStack stack) {
        if (stack.func_77973_b() == this) {
            NBTStackHelper.setBoolean(stack, "enchant", true);
            this.setUseCount(stack, this.getUseMax());
            return true;
        }
        return false;
    }

    public boolean setEngravedName(ItemStack stack, String engraved_name) {
        if (this.isEnchanted(stack)) {
            NBTStackHelper.setString(stack, "engraved_name", engraved_name);
            return true;
        }
        return false;
    }

    public String getEngravedName(ItemStack stack) {
        return this.isEnchanted(stack) ? NBTStackHelper.getString(stack, "engraved_name") : "";
    }

    @Override
    protected boolean doEffects(World world, EntityPlayerMP player, ItemStack stack) {
        String engraved_name = NBTStackHelper.getString(stack, "engraved_name");
        if (engraved_name.equals(player.func_70005_c_())) {
            LangKey.MESSAGE_TELEPORT_SAME_PLAYER.sendWarnMessage((ICommandSender)player, new Object[0]);
            return false;
        }
        assert (world.func_73046_m() != null);
        if (Stream.of(world.func_73046_m().func_71213_z()).noneMatch(p -> p.equals(engraved_name))) {
            if (Arrays.asList(world.func_73046_m().func_152358_ax().func_152654_a()).contains(engraved_name)) {
                LangKey.COMMAND_EXCEPTION_OFFLINE_PLAYER.sendWarnMessage((ICommandSender)player, new Object[0]);
            } else {
                LangKey.COMMAND_EXCEPTION_INVALID_PLAYER.sendWarnMessage((ICommandSender)player, new Object[0]);
            }
            return false;
        }
        EntityPlayerMP receiver = world.func_73046_m().func_184103_al().func_152612_a(engraved_name);
        if (receiver == null) {
            LangKey.MESSAGE_TELEPORT_FAILED.sendWarnMessage((ICommandSender)player, new Object[0]);
            return false;
        }
        if (receiver.field_71093_bK != player.field_71093_bK && !ConfigTombstone.general.teleportDim) {
            LangKey.MESSAGE_TELEPORT_SAME_DIMENSION.sendWarnMessage((ICommandSender)player, new Object[0]);
            return false;
        }
        ITextComponent hereClick = LangKey.MESSAGE_HERE.createComponentCommand("/tbacceptteleport " + player.func_110124_au(), new Object[0]);
        LangKey.MESSAGE_REQUEST_TO_JOIN_RECEIVER.sendSpecialMessage((ICommandSender)receiver, hereClick, player.func_70005_c_());
        CommandTBAcceptTeleport.addTicket((EntityPlayer)receiver, (EntityPlayer)player, 120);
        LangKey.MESSAGE_REQUEST_TO_JOIN_SENDER.sendSpecialMessage((ICommandSender)player, receiver.func_70005_c_());
        ModTriggers.USE_ASSISTANCE.trigger(player);
        return true;
    }

    @Override
    protected boolean canBlockInteractFirst(IBlockState state, ItemStack stack) {
        return super.canBlockInteractFirst(state, stack) || state.func_177230_c() instanceof BlockAnvil;
    }
}

