/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ovh.corail.tombstone.ConfigTombstone;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.item.ItemScroll;
import ovh.corail.tombstone.registry.ModTriggers;

public class ItemScrollOfKnowledge
extends ItemScroll {
    public ItemScrollOfKnowledge() {
        super("scroll_of_knowledge");
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag flag) {
        if (Helper.canShowTooltip()) {
            if (!this.isEnchanted(stack)) {
                this.addItemDesc(list, "1", new Object[0]);
                this.addItemUse(list, "1", new Object[0]);
            } else {
                this.addItemDesc(list, "2", new Object[0]);
                this.addInfo(list, LangKey.MESSAGE_STORED_EXPERIENCE, this.getStoredXp(stack));
                this.addItemUse(list, "2", new Object[0]);
            }
        }
        super.func_77624_a(stack, world, list, flag);
    }

    @Override
    public boolean canEnchant(World world, BlockPos gravePos, EntityPlayer player, ItemStack stack) {
        return ConfigTombstone.allowedMagicItems.allowScrollOfKnowledge;
    }

    @Override
    public boolean isEnchanted(ItemStack stack) {
        return this.getStoredXp(stack) > 0;
    }

    @Override
    public ITextComponent getEnchantSuccessMessage(EntityPlayer player) {
        return LangKey.MESSAGE_LOSE_EXPERIENCE_SUCCESS.getTranslation(new Object[0]);
    }

    @Override
    public ITextComponent getEnchantFailedMessage(EntityPlayer player) {
        return LangKey.MESSAGE_LOSE_EXPERIENCE_FAILED.getTranslation(new Object[0]);
    }

    @Override
    public boolean setEnchant(World world, BlockPos gravePos, EntityPlayer player, ItemStack stack) {
        boolean valid = this.setStoredXp(stack, EntityHelper.getPlayerTotalXp(player));
        if (valid) {
            player.field_71068_ca = 0;
            player.field_71067_cb = 0;
            player.field_71106_cc = 0.0f;
        }
        return valid;
    }

    @Override
    protected boolean doEffects(World world, EntityPlayerMP player, ItemStack stack) {
        int i;
        int storedXp = this.getStoredXp(stack);
        if (storedXp > (i = Integer.MAX_VALUE - player.field_71067_cb)) {
            LangKey.MESSAGE_EARN_EXPERIENCE_FAILED.sendWarnMessage((ICommandSender)player, new Object[0]);
            return false;
        }
        EntityHelper.setPlayerXp((EntityPlayer)player, EntityHelper.getPlayerTotalXp((EntityPlayer)player) + storedXp);
        LangKey.MESSAGE_EARN_EXPERIENCE_SUCCESS.sendSpecialMessage((ICommandSender)player, new Object[0]);
        ModTriggers.USE_KNOWLEDGE.trigger(player);
        return true;
    }

    public int getStoredXp(ItemStack stack) {
        int storedXp = NBTStackHelper.getInteger(stack, "stored_xp");
        return storedXp > 0 ? storedXp : 0;
    }

    public boolean setStoredXp(ItemStack stack, int xp) {
        if (stack.func_77973_b() == this && xp > 0) {
            NBTStackHelper.setInteger(stack, "stored_xp", xp);
            return true;
        }
        return false;
    }
}

