/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.api.magic.ISoulConsumer;
import ovh.corail.tombstone.api.magic.TBSoulConsumerProvider;
import ovh.corail.tombstone.block.BlockDecorativeGrave;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.Helper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.NBTStackHelper;
import ovh.corail.tombstone.helper.SoundHandler;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.TimeHelper;
import ovh.corail.tombstone.item.ItemGeneric;

public abstract class ItemGraveMagic
extends ItemGeneric
implements ISoulConsumer {
    public ItemGraveMagic(String name) {
        super(name, true, false, false);
        this.func_77625_d(1);
    }

    public String func_77653_i(ItemStack stack) {
        String name = super.func_77653_i(stack);
        return StyleType.MESSAGE_SPECIAL.func_150218_j() + (this.isAncient(stack) ? LangKey.MESSAGE_ANCIENT_ITEM.getServerTranslation(name) : (this.isEnchanted(stack) ? LangKey.MESSAGE_ENCHANTED_ITEM.getServerTranslation(name) : name));
    }

    public boolean isAncient(ItemStack stack) {
        return stack.func_77973_b() == this && NBTStackHelper.getBoolean(stack, "ancient");
    }

    protected abstract boolean doEffects(World var1, EntityPlayerMP var2, ItemStack var3);

    protected ItemStack onConsumeItem(EntityPlayer player, ItemStack stack) {
        return ItemStack.field_190927_a;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return this.isEnchanted(stack);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag flag) {
        if (!Helper.canShowTooltip()) {
            this.addInfoShowTooltip(list);
        }
        if (this.isEnchanted(stack)) {
            int cd;
            int uses;
            if (this.canConsumeOnUse() && (uses = this.getUseCount(stack)) > 0) {
                this.addInfo(list, LangKey.MESSAGE_USE_LEFT, uses);
            }
            if ((cd = this.getCooldown(world, stack)) > 10) {
                this.addWarn(list, LangKey.MESSAGE_IN_COOLDOWN, TimeHelper.getTimeString(cd));
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (this.isEnchanted(stack) && !this.isCooldown(world, stack)) {
            player.func_184598_c(hand);
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return super.func_77659_a(world, player, hand);
    }

    public boolean func_111207_a(ItemStack stack, EntityPlayer player, EntityLivingBase target, EnumHand hand) {
        return false;
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        if (player != null && this.canBlockInteractFirst(world.func_180495_p(pos), player.func_184586_b(hand))) {
            return EnumActionResult.PASS;
        }
        if (player != null) {
            this.func_77659_a(world, player, hand);
        }
        return EnumActionResult.SUCCESS;
    }

    protected boolean canBlockInteractFirst(IBlockState state, ItemStack stack) {
        return !this.isEnchanted(stack) || state.func_177230_c() instanceof BlockDecorativeGrave;
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase entity, int timeLeft) {
        if (entity.field_70170_p.field_72995_K && timeLeft == this.func_77626_a(stack) && this.isEnchanted(stack)) {
            ModTombstone.PROXY.produceParticleCasting(entity, p -> !p.func_184587_cr());
        }
    }

    public ItemStack func_77654_b(ItemStack stack, World world, EntityLivingBase entity) {
        if (EntityHelper.isValidPlayerMP((Entity)entity)) {
            EntityPlayerMP player = (EntityPlayerMP)entity;
            if (this.isEnchanted(stack)) {
                int useCount = this.getUseCount(stack);
                if (useCount < 0) {
                    return ItemStack.field_190927_a;
                }
                if (this.doEffects(world, player, stack)) {
                    SoundHandler.playSoundAllAround("magic_use01", world, player.func_180425_c());
                    if (!this.canConsumeOnUse() || --useCount > 0) {
                        this.setCooldown(world, stack, this.getCastingCooldown());
                        this.setUseCount(stack, useCount);
                        return stack;
                    }
                    return this.onConsumeItem((EntityPlayer)player, stack);
                }
                player.func_184811_cZ().func_185145_a((Item)this, 10);
                return stack;
            }
        }
        return stack;
    }

    public int func_77626_a(ItemStack stack) {
        return 40;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public abstract int getCastingCooldown();

    public boolean isCooldown(World world, ItemStack stack) {
        return this.getCooldown(world, stack) > 0;
    }

    public int getCooldown(@Nullable World world, ItemStack stack) {
        long cooldown_time;
        if (world != null && stack.func_77973_b() == this && (cooldown_time = NBTStackHelper.getLong(stack, "cooldown_time", 0L)) > 0L) {
            int cd = (int)(cooldown_time - TimeHelper.worldTicks(world));
            if (cd > this.getCastingCooldown()) {
                this.setCooldown(world, stack, this.getCastingCooldown());
                return this.getCastingCooldown();
            }
            return Math.max(cd, 0);
        }
        return 0;
    }

    public void setCooldown(@Nullable World world, ItemStack stack, int time) {
        if (world != null && stack.func_77973_b() == this) {
            NBTStackHelper.setLong(stack, "cooldown_time", TimeHelper.worldTicks(world) + (long)time);
        }
    }

    public abstract int getUseMax();

    public abstract boolean canConsumeOnUse();

    public int getUseCount(ItemStack stack) {
        if (stack.func_77973_b() != this) {
            return 0;
        }
        if (this.getUseMax() == 1 || !this.canConsumeOnUse()) {
            return 1;
        }
        return Math.max(0, NBTStackHelper.getInteger(stack, "useCount"));
    }

    protected void setUseCount(ItemStack stack, int useCount) {
        if (this.canConsumeOnUse()) {
            NBTStackHelper.setInteger(stack, "useCount", useCount);
        }
    }

    @Override
    public ITextComponent getEnchantSuccessMessage(EntityPlayer player) {
        return LangKey.MESSAGE_ENCHANT_ITEM_SUCCESS.getTranslation(new Object[0]);
    }

    @Override
    public ITextComponent getEnchantFailedMessage(EntityPlayer player) {
        return LangKey.MESSAGE_ENCHANT_ITEM_FAILED.getTranslation(new Object[0]);
    }

    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new TBSoulConsumerProvider(this);
    }
}

