/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.helper;

import com.google.common.base.Predicate;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import io.github.opencubicchunks.cubicchunks.api.world.ICube;
import io.github.opencubicchunks.cubicchunks.api.world.ICubicWorld;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.LocalDate;
import java.time.temporal.ChronoField;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemEnchantedBook;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.EnumSkyBlock;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.border.WorldBorder;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.storage.ExtendedBlockStorage;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.EnumHelper;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.versioning.DefaultArtifactVersion;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import ovh.corail.tombstone.ConfigTombstone;
import ovh.corail.tombstone.ModTombstone;
import ovh.corail.tombstone.api.capability.Perk;
import ovh.corail.tombstone.api.magic.ISoulConsumer;
import ovh.corail.tombstone.command.CommandTBAcceptTeleport;
import ovh.corail.tombstone.command.CommandTBBind;
import ovh.corail.tombstone.command.CommandTBKnownledge;
import ovh.corail.tombstone.command.CommandTBRecovery;
import ovh.corail.tombstone.command.CommandTBRequestTeleport;
import ovh.corail.tombstone.command.CommandTBRestoreInventory;
import ovh.corail.tombstone.command.CommandTBReviveFamiliar;
import ovh.corail.tombstone.command.CommandTBShowLastGrave;
import ovh.corail.tombstone.command.CommandTBSiege;
import ovh.corail.tombstone.command.CommandTBTeleport;
import ovh.corail.tombstone.command.CommandTBTeleportDeath;
import ovh.corail.tombstone.command.CommandTBTeleportDiscovery;
import ovh.corail.tombstone.command.CommandTBTeleportGrave;
import ovh.corail.tombstone.command.CommandTBTeleportHome;
import ovh.corail.tombstone.command.CommandTBTeleportVillage;
import ovh.corail.tombstone.compatibility.SupportMods;
import ovh.corail.tombstone.helper.ContributorStore;
import ovh.corail.tombstone.helper.EntityHelper;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.Location;
import ovh.corail.tombstone.helper.SpawnHelper;
import ovh.corail.tombstone.helper.StyleType;
import ovh.corail.tombstone.helper.SupportStructures;
import ovh.corail.tombstone.helper.TeleportUtils;
import ovh.corail.tombstone.helper.WorldFunctionInjector;
import ovh.corail.tombstone.item.ItemCraftingIngredient;
import ovh.corail.tombstone.item.ItemScrollBuff;
import ovh.corail.tombstone.registry.ModBlocks;
import ovh.corail.tombstone.registry.ModEnchantments;
import ovh.corail.tombstone.registry.ModItems;

public class Helper {
    public static final Random random = new Random();
    public static Boolean isHalloween = null;
    private static Boolean isAprilFools = null;
    public static boolean isContributor = false;
    private static ContributorStore CONTRIBUTORS = ContributorStore.of();
    private static final URL CONTRIBUTORS_URL;

    public static boolean isContributor(EntityPlayer player) {
        if (player.field_70170_p.field_72995_K) {
            return isContributor;
        }
        return CONTRIBUTORS.contains(player);
    }

    public static boolean isDisabledPerk(@Nullable Perk perk) {
        return perk == null || perk.isDisabled();
    }

    public static int getRandom(int min, int max) {
        return random.nextInt(max - min + 1) + min;
    }

    public static float getRandom(float min, float max) {
        return random.nextFloat() * (max - min) + min;
    }

    public static double getRandom(double min, double max) {
        return random.nextDouble() * (max - min) + min;
    }

    public static boolean getRandom() {
        return random.nextBoolean();
    }

    @Nullable
    public static <T> T getRandomInList(List<T> list) {
        return list.isEmpty() ? null : (T)list.get(random.nextInt(list.size()));
    }

    public static String dump(Object o) {
        return ToStringBuilder.reflectionToString((Object)o, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public static boolean existClass(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    public static BlockPos getCloserValidPos(World world, BlockPos pos) {
        boolean validY;
        WorldBorder border = world.func_175723_af();
        boolean validXZ = border.func_177746_a(pos);
        boolean bl = validY = !world.func_189509_E(pos);
        if (validXZ && validY) {
            return pos;
        }
        int x = pos.func_177958_n();
        int y = pos.func_177956_o();
        int z = pos.func_177952_p();
        if (!validXZ) {
            x = Math.min(Math.max(pos.func_177958_n(), (int)border.func_177726_b()), (int)border.func_177728_d());
            z = Math.min(Math.max(pos.func_177952_p(), (int)border.func_177736_c()), (int)border.func_177733_e());
        }
        if (!validY) {
            y = SupportMods.CUBIC_CHUNKS.isLoaded() && ((ICubicWorld)world).isCubicWorld() ? Math.max(Math.min(y, ((ICubicWorld)world).getMaxHeight()), ((ICubicWorld)world).getMinHeight()) : Math.max(Math.min(pos.func_177956_o(), world.field_73011_w.getActualHeight()), 0);
        }
        return new BlockPos(x, y, z);
    }

    public static boolean isValidPos(World world, BlockPos pos) {
        return world.func_175723_af().func_177746_a(pos) && !world.func_189509_E(pos);
    }

    public static boolean isValidDimension(int dim) {
        return Helper.getDimensionIds().contains(dim);
    }

    private static List<Integer> getDimensionIds() {
        return Arrays.asList(DimensionManager.getStaticDimensionIDs());
    }

    public static List<String> getDimensionIdsAsStringList() {
        return Helper.getDimensionIds().stream().map(Object::toString).collect(Collectors.toList());
    }

    public static Location findNearestStructure(WorldServer world, BlockPos pos, SupportStructures struct, boolean unexplored) {
        BlockPos startingPos = pos;
        for (int nbTry = 0; nbTry < 10; ++nbTry) {
            startingPos = Helper.getCloserValidPos((World)world, startingPos.func_177963_a(random.nextGaussian() * 1000.0, 0.0, random.nextGaussian() * 1000.0));
            BlockPos foundPos = world.func_190528_a(struct.getStructureName(), startingPos, unexplored);
            if (foundPos == null || !Helper.isValidPos((World)world, foundPos) || !struct.isValidBiome(world.func_180494_b(foundPos).getRegistryName())) continue;
            Location structureLoc = new Location(foundPos, (World)world);
            if (struct == SupportStructures.Village && unexplored && Helper.isVillageExplored((World)world, structureLoc.getPos())) continue;
            return structureLoc;
        }
        return Location.ORIGIN;
    }

    public static boolean isVillageExplored(World world, BlockPos villagePos) {
        return world.func_175714_ae().func_75540_b().stream().anyMatch(v -> v.func_180608_a().equals((Object)villagePos));
    }

    public static Location findSpawnForVillage(WorldServer world, BlockPos villagePos) {
        return new SpawnHelper(world, world.func_175672_r(villagePos)).findSpawnPlace();
    }

    public static <T extends Entity> T teleportEntity(T entity, Location loc) {
        return (T)TeleportUtils.teleportEntity(entity, loc.dim, (double)loc.x + 0.5, (double)loc.y + 0.1, (double)loc.z + 0.5);
    }

    public static <T extends Entity> T teleportToGrave(T entity, Location loc) {
        return Helper.teleportEntity(entity, new Location(loc.getPos().func_177984_a(), loc.dim));
    }

    public static boolean isRuleKeepInventory(EntityPlayer player) {
        return Helper.isRuleKeepInventory(player.field_70170_p);
    }

    public static boolean isRuleKeepInventory(World world) {
        return world.func_82736_K().func_82766_b("keepInventory");
    }

    public static void removeNoEvent(World world, BlockPos pos) {
        Helper.placeNoEvent(world, pos, Blocks.field_150350_a.func_176223_P());
    }

    public static void placeNoEvent(World world, BlockPos pos, IBlockState state) {
        ExtendedBlockStorage storage;
        if (!ConfigTombstone.general.gravesByPassGriefingRules) {
            world.func_180501_a(pos, state, 3);
            return;
        }
        if (SupportMods.CUBIC_CHUNKS.isLoaded() && ((ICubicWorld)world).isCubicWorld()) {
            ICubicWorld cubicWorld = (ICubicWorld)world;
            ICube cube = cubicWorld.getCubeFromBlockCoords(pos);
            storage = cube.getStorage();
            if (storage == null) {
                cube.setLightFor(EnumSkyBlock.BLOCK, pos, cube.getLightFor(EnumSkyBlock.BLOCK, pos));
                storage = cube.getStorage();
            }
        } else {
            Chunk chunk = world.func_175726_f(pos);
            ExtendedBlockStorage[] storageArray = chunk.func_76587_i();
            storage = storageArray[pos.func_177956_o() >> 4];
            if (storage == null) {
                ExtendedBlockStorage extendedBlockStorage = new ExtendedBlockStorage(pos.func_177956_o() >> 4 << 4, world.field_73011_w.func_191066_m());
                storageArray[pos.func_177956_o() >> 4] = extendedBlockStorage;
                storage = extendedBlockStorage;
            }
            chunk.func_76630_e();
        }
        IBlockState oldState = storage.func_177485_a(pos.func_177958_n() & 0xF, pos.func_177956_o() & 0xF, pos.func_177952_p() & 0xF);
        storage.func_177484_a(pos.func_177958_n() & 0xF, pos.func_177956_o() & 0xF, pos.func_177952_p() & 0xF, state);
        if (state.getLightOpacity((IBlockAccess)world, pos) != oldState.getLightOpacity((IBlockAccess)world, pos) || state.getLightValue((IBlockAccess)world, pos) != oldState.getLightValue((IBlockAccess)world, pos)) {
            world.func_175664_x(pos);
        }
        world.markAndNotifyBlock(pos, world.func_175726_f(pos), oldState, state, 3);
    }

    public static boolean canShowTooltip() {
        return ConfigTombstone.client.showEnhancedTooltips || GuiScreen.func_146272_n();
    }

    public static boolean isDateAroundHalloween() {
        return isHalloween != null && isHalloween != false;
    }

    public static boolean isDateAroundHalloween(World world) {
        if (isHalloween == null) {
            return Helper.isDateAroundHalloween(world.func_83015_S());
        }
        return isHalloween;
    }

    private static boolean isDateAroundHalloween(Calendar calendar) {
        if (isHalloween == null) {
            isHalloween = ConfigTombstone.general.persistantHalloween || calendar.get(2) + 1 == 10 && calendar.get(5) >= 20 || calendar.get(2) + 1 == 11 && calendar.get(5) <= 3;
        }
        return isHalloween;
    }

    public static boolean isAprilFoolsDay() {
        if (isAprilFools == null) {
            LocalDate date = LocalDate.now();
            isAprilFools = date.get(ChronoField.MONTH_OF_YEAR) == 4 && date.get(ChronoField.DAY_OF_MONTH) == 1;
        }
        return isAprilFools;
    }

    public static boolean isNight(World world) {
        float angle = world.func_72826_c(0.0f);
        return angle >= 0.245f && angle <= 0.755f;
    }

    public static boolean isDay(World world) {
        return !Helper.isNight(world);
    }

    @Nullable
    public static PotionEffect getRandomEffect(int duration, boolean isBad) {
        Potion potion;
        List potions = ForgeRegistries.POTIONS.getValuesCollection().stream().filter(isBad ? Helper::isBadEffect : Helper::isAllowedEffect).collect(Collectors.toList());
        if (potions.size() > 0 && (potion = (Potion)potions.get(random.nextInt(potions.size()))) != null) {
            int random = Helper.getRandom(1, 100);
            int level = random < 10 ? 4 : (random < 25 ? 3 : (random < 45 ? 2 : (random < 70 ? 1 : 0)));
            return new PotionEffect(potion, duration, level, true, true);
        }
        return null;
    }

    public static void addRandomPotion(EntityPlayer player, int duration, boolean withMessage) {
        Helper.addRandomPotion(player, duration, withMessage, false);
    }

    public static void addRandomPotion(EntityPlayer player, int duration, boolean withMessage, boolean isBad) {
        PotionEffect effect = Helper.getRandomEffect(duration, isBad);
        if (effect != null) {
            if (withMessage && !effect.func_188419_a().func_76393_a().isEmpty()) {
                LangKey.MESSAGE_SPELL_CAST_ON_YOU.sendMagicMessage((ICommandSender)player, LangKey.makeTranslationWithStyle(StyleType.MESSAGE_SPECIAL, effect.func_188419_a().func_76393_a(), new Object[0]));
            }
            EntityHelper.addPotion((EntityLivingBase)player, effect);
        }
    }

    public static boolean isAllowedEffect(@Nullable PotionEffect effectInstance) {
        return effectInstance != null && Helper.isAllowedEffect(effectInstance.func_188419_a());
    }

    public static boolean isAllowedEffect(@Nullable Potion potion) {
        return potion != null && !potion.func_76398_f() && !Helper.containRL(ConfigTombstone.general.unhandledBeneficialEffects, potion.getRegistryName());
    }

    public static boolean isBadEffect(@Nullable Potion potion) {
        return potion != null && potion.func_76398_f() && !Helper.containRL(ConfigTombstone.general.unhandledHarmfulEffects, potion.getRegistryName());
    }

    public static boolean containRL(String[] arrayRL, @Nullable ResourceLocation rl) {
        return rl != null && Arrays.stream(arrayRL).anyMatch(p -> p.contains(":") ? rl.toString().equals(p) : rl.func_110624_b().equals(p));
    }

    public static float[] getRGBColor3F(int color) {
        float[] rgb = new float[]{(float)(color >> 16 & 0xFF) / 255.0f, (float)(color >> 8 & 0xFF) / 255.0f, (float)(color & 0xFF) / 255.0f};
        return rgb;
    }

    public static float[] getHSBtoRGBF(float hue, float saturation, float brightness) {
        int r = 0;
        int g = 0;
        int b = 0;
        if (saturation == 0.0f) {
            g = b = (int)(brightness * 255.0f + 0.5f);
            r = b;
        } else {
            float h = (hue - (float)Math.floor(hue)) * 6.0f;
            float f = h - (float)Math.floor(h);
            float p = brightness * (1.0f - saturation);
            float q = brightness * (1.0f - saturation * f);
            float t = brightness * (1.0f - saturation * (1.0f - f));
            switch ((int)h) {
                case 0: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(t * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 1: {
                    r = (int)(q * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(p * 255.0f + 0.5f);
                    break;
                }
                case 2: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(brightness * 255.0f + 0.5f);
                    b = (int)(t * 255.0f + 0.5f);
                    break;
                }
                case 3: {
                    r = (int)(p * 255.0f + 0.5f);
                    g = (int)(q * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 4: {
                    r = (int)(t * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(brightness * 255.0f + 0.5f);
                    break;
                }
                case 5: {
                    r = (int)(brightness * 255.0f + 0.5f);
                    g = (int)(p * 255.0f + 0.5f);
                    b = (int)(q * 255.0f + 0.5f);
                }
            }
        }
        float[] rgb = new float[]{(float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f};
        return rgb;
    }

    public static void fillGradient(int left, int top, int right, int bottom, int color1, int color2, float zLevel, boolean isHorizontal) {
        float[] argb1 = Helper.getRGBColor3F(color1);
        float[] argb2 = Helper.getRGBColor3F(color2);
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179103_j((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        Helper.makeVertex(bufferbuilder, right, top, (int)zLevel, isHorizontal ? argb2 : argb1);
        Helper.makeVertex(bufferbuilder, left, top, (int)zLevel, argb1);
        Helper.makeVertex(bufferbuilder, left, bottom, (int)zLevel, isHorizontal ? argb1 : argb2);
        Helper.makeVertex(bufferbuilder, right, bottom, (int)zLevel, argb2);
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
    }

    private static void makeVertex(BufferBuilder bufferbuilder, int x, int y, int zLevel, float[] colorArray) {
        bufferbuilder.func_181662_b((double)x, (double)y, (double)zLevel).func_181666_a(colorArray[0], colorArray[1], colorArray[2], 1.0f).func_181675_d();
    }

    public static EnumEnchantmentType addEnchantmentType(String name, Predicate<Item> predic, EnumEnchantmentType fallback) {
        EnumEnchantmentType enchantType = EnumHelper.addEnchantmentType((String)name, predic);
        return enchantType == null ? fallback : enchantType;
    }

    public static boolean isModPresent(String modid, @Nullable String version) {
        return Loader.instance().getActiveModList().stream().filter(mod -> mod.getModId().equals(modid)).findFirst().map(mod -> version == null || mod.getProcessedVersion().compareTo((Object)new DefaultArtifactVersion(version)) >= 0).orElse(false);
    }

    public static Set<Enchantment> getTombstoneEnchantments(ItemStack stack) {
        NBTTagList nbttaglist;
        boolean isEnchantedBook;
        boolean bl = isEnchantedBook = stack.func_77973_b() == Items.field_151134_bR;
        if (!isEnchantedBook && ConfigTombstone.enchantments.isEnableEnchantmentSoulbound() && ConfigTombstone.enchantments.isEnableEnchantmentShadowStep() && ConfigTombstone.enchantments.isEnableEnchantmentMagicSiphon() && ConfigTombstone.enchantments.isEnableEnchantmentPlagueBringer()) {
            return Sets.newLinkedHashSet();
        }
        LinkedHashSet list = Sets.newLinkedHashSet();
        NBTTagList nBTTagList = nbttaglist = isEnchantedBook ? ItemEnchantedBook.func_92110_g((ItemStack)stack) : stack.func_77986_q();
        if (nbttaglist.func_74745_c() > 0) {
            HashMap enchants = new HashMap();
            Arrays.stream(new Enchantment[]{ModEnchantments.soulbound, ModEnchantments.shadow_step, ModEnchantments.magic_siphon, ModEnchantments.plague_bringer}).forEach(enchant -> enchants.put(Helper.getEnchantmentId(enchant), enchant));
            IntStream.range(0, nbttaglist.func_74745_c()).mapToObj(arg_0 -> ((NBTTagList)nbttaglist).func_150305_b(arg_0)).filter(nbt -> nbt.func_150297_b("id", 2)).forEach(nbt -> Optional.ofNullable(enchants.get(nbt.func_74765_d("id"))).ifPresent(list::add));
        }
        return list;
    }

    public static int getEnchantmentId(Enchantment enchantment) {
        return ((ForgeRegistry)ForgeRegistries.ENCHANTMENTS).getID((IForgeRegistryEntry)enchantment);
    }

    public static double lerp(double pct, double start, double end) {
        return start + pct * (end - start);
    }

    public static Capability.IStorage<ISoulConsumer> getNullStorage() {
        return new Capability.IStorage<ISoulConsumer>(){

            @Nullable
            public NBTBase writeNBT(Capability<ISoulConsumer> capability, ISoulConsumer instance, EnumFacing side) {
                return null;
            }

            public void readNBT(Capability<ISoulConsumer> capability, ISoulConsumer instance, EnumFacing side, NBTBase nbt) {
            }
        };
    }

    public static WorldFunctionInjector buildKnowledgeFunction() {
        return WorldFunctionInjector.builder().put(new ResourceLocation("tombstone", "knowledge"), (sender, params) -> {
            Entity entity = sender.func_174793_f();
            if (entity instanceof EntityPlayerMP) {
                EntityHelper.addKnowledge((EntityPlayerMP)entity, params.getInt("amount", 1));
            }
        }).build();
    }

    public static void initCommands(FMLServerStartingEvent event) {
        event.registerServerCommand((ICommand)new CommandTBTeleport());
        event.registerServerCommand((ICommand)new CommandTBTeleportGrave());
        event.registerServerCommand((ICommand)new CommandTBShowLastGrave());
        event.registerServerCommand((ICommand)new CommandTBRestoreInventory());
        event.registerServerCommand((ICommand)new CommandTBTeleportVillage());
        event.registerServerCommand((ICommand)new CommandTBTeleportDiscovery());
        event.registerServerCommand((ICommand)new CommandTBRecovery());
        event.registerServerCommand((ICommand)new CommandTBAcceptTeleport());
        event.registerServerCommand((ICommand)new CommandTBKnownledge());
        event.registerServerCommand((ICommand)new CommandTBSiege());
        event.registerServerCommand((ICommand)new CommandTBReviveFamiliar());
        event.registerServerCommand((ICommand)new CommandTBTeleportHome());
        event.registerServerCommand((ICommand)new CommandTBRequestTeleport());
        event.registerServerCommand((ICommand)new CommandTBBind());
        event.registerServerCommand((ICommand)new CommandTBTeleportDeath());
    }

    public static void loadContributors(MinecraftServer server) {
        if (CONTRIBUTORS.isEmpty()) {
            Futures.addCallback(ContributorStore.read(CONTRIBUTORS_URL, server.func_110454_ao()), (FutureCallback)new FutureCallback<ContributorStore>(){

                public void onSuccess(@Nullable ContributorStore result) {
                    CONTRIBUTORS = result;
                    ModTombstone.LOGGER.info("The list of contributors has been loaded successfully");
                }

                public void onFailure(@Nonnull Throwable t) {
                    ModTombstone.LOGGER.info("The list of contributors can't be loaded");
                }
            });
        } else {
            ModTombstone.LOGGER.info("The list of contributors was already loaded");
        }
    }

    public static void registerOreDicts() {
        OreDictionary.registerOre((String)"dustGrave", (ItemStack)ItemCraftingIngredient.IconType.GRAVE_DUST.getStack());
        OreDictionary.registerOre((String)"ingredientEnchantedGraveKey", (Item)Items.field_151079_bi);
        OreDictionary.registerOre((String)"decorativeGrave", (Block)ModBlocks.decorative_grave_simple);
        OreDictionary.registerOre((String)"decorativeGrave", (Block)ModBlocks.decorative_grave_normal);
        OreDictionary.registerOre((String)"decorativeGrave", (Block)ModBlocks.decorative_grave_cross);
        OreDictionary.registerOre((String)"decorativeGrave", (Block)ModBlocks.decorative_tombstone);
        for (ItemScrollBuff.SpellBuff buff : ItemScrollBuff.SpellBuff.values()) {
            OreDictionary.registerOre((String)"magicScroll", (ItemStack)new ItemStack((Item)ModItems.scroll_buff, 1, buff.ordinal()));
        }
        OreDictionary.registerOre((String)"magicScroll", (Item)ModItems.scroll_of_knowledge);
        OreDictionary.registerOre((String)"magicTablet", (Item)ModItems.tablet_of_recall);
        OreDictionary.registerOre((String)"magicTablet", (Item)ModItems.tablet_of_assistance);
        OreDictionary.registerOre((String)"magicTablet", (Item)ModItems.tablet_of_home);
        OreDictionary.registerOre((String)"magicTablet", (Item)ModItems.tablet_of_cupidity);
    }

    static {
        try {
            CONTRIBUTORS_URL = new URL("https://raw.githubusercontent.com/Corail31/trash/master/contributors.json");
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
    }
}

