/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.enchantment;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import ovh.corail.tombstone.helper.LangKey;
import ovh.corail.tombstone.helper.StyleType;

public abstract class TombstoneEnchantment
extends Enchantment {
    private final String customName;

    TombstoneEnchantment(String name, Enchantment.Rarity rarity, EnumEnchantmentType type, EntityEquipmentSlot[] slots) {
        super(rarity, type, slots);
        this.customName = name;
        this.setRegistryName("tombstone", name);
        this.func_77322_b(name);
    }

    protected abstract boolean isEnabled();

    public int func_77319_d() {
        return 1;
    }

    public int func_77325_b() {
        return 1;
    }

    public int func_77321_a(int lvl) {
        return 1;
    }

    public int func_77317_b(int lvl) {
        return 50;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack) {
        return this.isEnabled() && super.canApplyAtEnchantingTable(stack);
    }

    public boolean isAllowedOnBooks() {
        return this.isEnabled();
    }

    @SideOnly(value=Side.CLIENT)
    public List<String> getTooltipInfos(ItemStack stack) {
        ArrayList<String> infos = new ArrayList<String>();
        infos.add(LangKey.makeClientTranslationWithStyle(StyleType.TOOLTIP_ENCHANT, "enchantment.tombstone." + this.field_77350_z + ".desc", new Object[0]));
        if (!this.isEnabled()) {
            infos.add(LangKey.makeClientTranslationWithStyle(StyleType.COLOR_OFF, "tombstone.enchantment.disabled", new Object[0]));
        }
        return infos;
    }

    public String func_77320_a() {
        return "enchantment.tombstone." + this.customName + ".name";
    }
}

