/*
 * Decompiled with CFR 0.152.
 */
package ovh.corail.tombstone.compatibility;

import java.util.List;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import ovh.corail.tombstone.ConfigTombstone;
import ovh.corail.tombstone.compatibility.IEquipableCompat;
import ovh.corail.tombstone.helper.CallbackHandler;
import ovh.corail.tombstone.tileentity.TileEntityTombstone;
import techguns.api.capabilities.ITGExtendedPlayer;
import techguns.api.tginventory.ITGSpecialSlot;
import techguns.api.tginventory.TGSlotType;

public class CompatibilityTechguns
implements IEquipableCompat {
    public static final CompatibilityTechguns instance = new CompatibilityTechguns();
    @CapabilityInject(value=ITGExtendedPlayer.class)
    private static Capability<ITGExtendedPlayer> CAPABILITY_PLAYER = null;

    private CompatibilityTechguns() {
    }

    @Override
    public boolean autoEquip(ItemStack stack, EntityPlayer player) {
        boolean isTGStack;
        if (CAPABILITY_PLAYER == null) {
            return false;
        }
        boolean isFood = stack.func_77973_b() instanceof ItemFood;
        boolean bl = isTGStack = !isFood && stack.func_77973_b() instanceof ITGSpecialSlot;
        if (!isFood && !isTGStack) {
            return false;
        }
        ITGExtendedPlayer cap = (ITGExtendedPlayer)player.getCapability(CAPABILITY_PLAYER, null);
        if (cap == null) {
            return false;
        }
        IInventory techgunsInvent = cap.getTGInventory();
        if (techgunsInvent == null) {
            return false;
        }
        if (isFood) {
            for (int slot = 3; slot <= 5; ++slot) {
                if (!techgunsInvent.func_70301_a(slot).func_190926_b()) continue;
                techgunsInvent.func_70299_a(slot, stack.func_77946_l());
                return true;
            }
            return false;
        }
        for (int slot = 0; slot < techgunsInvent.func_70302_i_(); ++slot) {
            if (slot >= 3 && slot <= 5 || !techgunsInvent.func_70301_a(slot).func_190926_b() || !this.canEquipStackInSlot(stack, slot)) continue;
            techgunsInvent.func_70299_a(slot, stack.func_77946_l());
            return true;
        }
        return false;
    }

    private boolean canEquipStackInSlot(ItemStack stack, int slot) {
        return ((ITGSpecialSlot)stack.func_77973_b()).getSlot(stack) == this.getTypeFromSlot(slot);
    }

    private TGSlotType getTypeFromSlot(int slot) {
        switch (slot) {
            case 0: {
                return TGSlotType.FACESLOT;
            }
            case 1: {
                return TGSlotType.BACKSLOT;
            }
            case 2: {
                return TGSlotType.HANDSLOT;
            }
            case 3: 
            case 4: 
            case 5: {
                return TGSlotType.FOODSLOT;
            }
            case 6: {
                return TGSlotType.HEALSLOT;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                return TGSlotType.AMMOSLOT;
            }
        }
        return null;
    }

    public void snifferDrops(World world, BlockPos deathPlace, BlockPos gravePlace) {
        CallbackHandler.addCallback(1, () -> {
            TileEntity tile;
            double range = ConfigTombstone.general.snifferRange;
            List itemList = world.func_72872_a(EntityItem.class, new AxisAlignedBB((double)deathPlace.func_177958_n() - range, (double)deathPlace.func_177956_o() - range, (double)deathPlace.func_177952_p() - range, (double)deathPlace.func_177958_n() + range, (double)deathPlace.func_177956_o() + range, (double)deathPlace.func_177952_p() + range));
            if (itemList.isEmpty()) {
                return;
            }
            if (!world.func_175667_e(gravePlace)) {
                world.func_180495_p(gravePlace);
            }
            if (!((tile = world.func_175625_s(gravePlace)) instanceof TileEntityTombstone)) {
                return;
            }
            IItemHandler itemHandler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
            if (itemHandler == null) {
                return;
            }
            for (EntityItem entityItem : itemList) {
                if (entityItem == null || entityItem.func_92059_d().func_190926_b()) continue;
                entityItem.func_92058_a(ItemHandlerHelper.insertItemStacked((IItemHandler)itemHandler, (ItemStack)entityItem.func_92059_d(), (boolean)false));
            }
        });
    }
}

