/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.logic.editors;

import mcjty.lib.gui.events.BlockRenderEvent;
import mcjty.lib.gui.layout.HorizontalLayout;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.widgets.BlockRender;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Widget;
import mcjty.rftoolscontrol.api.parameters.ParameterType;
import mcjty.rftoolscontrol.api.parameters.ParameterValue;
import mcjty.rftoolscontrol.logic.editors.AbstractParameterEditor;
import mcjty.rftoolscontrol.logic.editors.ParameterEditorCallback;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class FluidEditor
extends AbstractParameterEditor {
    private BlockRender blockRender;

    @Override
    public void build(Minecraft mc, Gui gui, Panel panel, final ParameterEditorCallback callback) {
        Panel constantPanel = new Panel(mc, gui).setLayout((Layout)new HorizontalLayout());
        Label label = (Label)new Label(mc, gui).setText("Drop bucket:");
        constantPanel.addChild((Widget)label);
        this.blockRender = ((BlockRender)((BlockRender)((BlockRender)((BlockRender)new BlockRender(mc, gui).setDesiredWidth(118)).setDesiredHeight(18)).setFilledRectThickness(1)).setFilledBackground(-11184811)).setShowLabel(true);
        constantPanel.addChild((Widget)this.blockRender);
        this.blockRender.addSelectionEvent(new BlockRenderEvent(){

            public void select(Widget widget) {
                ItemStack holding = Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70445_o();
                if (holding.func_190926_b()) {
                    FluidEditor.this.blockRender.setRenderItem(null);
                } else {
                    FluidEditor.this.blockRender.setRenderItem((Object)FluidEditor.this.stackToFluid(holding));
                }
                callback.valueChanged(FluidEditor.this.readValue());
            }

            public void doubleClick(Widget widget) {
            }
        });
        this.createEditorPanel(mc, gui, panel, callback, constantPanel, ParameterType.PAR_FLUID);
    }

    @Override
    protected ParameterValue readConstantValue() {
        Object renderItem = this.blockRender.getRenderItem();
        if (renderItem instanceof ItemStack) {
            FluidStack fluidStack = this.stackToFluid((ItemStack)renderItem);
            return ParameterValue.constant(fluidStack);
        }
        if (renderItem instanceof FluidStack) {
            FluidStack stack = (FluidStack)renderItem;
            return ParameterValue.constant(stack);
        }
        return ParameterValue.constant(null);
    }

    private FluidStack stackToFluid(ItemStack stack) {
        IFluidHandler handler;
        if (stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null) && (handler = (IFluidHandler)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null)).getTankProperties() != null && handler.getTankProperties().length > 0 && handler.getTankProperties()[0] != null) {
            return handler.getTankProperties()[0].getContents();
        }
        if (stack.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null) && (handler = (IFluidHandler)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null)).getTankProperties() != null && handler.getTankProperties().length > 0 && handler.getTankProperties()[0] != null) {
            return handler.getTankProperties()[0].getContents();
        }
        return null;
    }

    @Override
    protected void writeConstantValue(ParameterValue value) {
        if (value == null || value.getValue() == null) {
            this.blockRender.setRenderItem(null);
        } else {
            FluidStack inv = (FluidStack)value.getValue();
            this.blockRender.setRenderItem((Object)inv);
        }
    }
}

