/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.logic.editors;

import mcjty.lib.gui.Window;
import mcjty.lib.gui.layout.HorizontalLayout;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.gui.widgets.Widget;
import mcjty.rftoolscontrol.api.parameters.ParameterType;
import mcjty.rftoolscontrol.api.parameters.ParameterValue;
import mcjty.rftoolscontrol.logic.editors.AbstractParameterEditor;
import mcjty.rftoolscontrol.logic.editors.ParameterEditorCallback;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;

public class FloatEditor
extends AbstractParameterEditor {
    private TextField field;

    @Override
    public void build(Minecraft mc, Gui gui, Panel panel, ParameterEditorCallback callback) {
        Panel constantPanel = new Panel(mc, gui).setLayout((Layout)new HorizontalLayout());
        this.field = new TextField(mc, gui).addTextEvent((parent, newText) -> callback.valueChanged(this.readValue())).addTextEnterEvent((parent, newText) -> this.closeWindow());
        constantPanel.addChild((Widget)this.field);
        this.createEditorPanel(mc, gui, panel, callback, constantPanel, ParameterType.PAR_FLOAT);
    }

    @Override
    public void initialFocusInternal(Window window) {
        window.setTextFocus((Widget)this.field);
    }

    @Override
    protected ParameterValue readConstantValue() {
        return ParameterValue.constant(FloatEditor.parseFloatSafe(this.field.getText()));
    }

    @Override
    protected void writeConstantValue(ParameterValue value) {
        if (value == null || value.getValue() == null) {
            this.field.setText("");
        } else {
            try {
                this.field.setText(Float.toString(((Float)value.getValue()).floatValue()));
            }
            catch (Exception e) {
                this.field.setText("");
            }
        }
    }
}

