/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolscontrol.blocks.craftingstation;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import mcjty.lib.base.ModBase;
import mcjty.lib.base.StyleConfig;
import mcjty.lib.gui.GenericGuiContainer;
import mcjty.lib.gui.Window;
import mcjty.lib.gui.events.BlockRenderEvent;
import mcjty.lib.gui.layout.HorizontalLayout;
import mcjty.lib.gui.layout.Layout;
import mcjty.lib.gui.layout.LayoutHint;
import mcjty.lib.gui.layout.PositionalLayout;
import mcjty.lib.gui.widgets.AbstractContainerWidget;
import mcjty.lib.gui.widgets.BlockRender;
import mcjty.lib.gui.widgets.Button;
import mcjty.lib.gui.widgets.Label;
import mcjty.lib.gui.widgets.Panel;
import mcjty.lib.gui.widgets.Slider;
import mcjty.lib.gui.widgets.TextField;
import mcjty.lib.gui.widgets.Widget;
import mcjty.lib.gui.widgets.WidgetList;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.rftoolscontrol.RFToolsControl;
import mcjty.rftoolscontrol.blocks.craftingstation.CraftingRequest;
import mcjty.rftoolscontrol.blocks.craftingstation.CraftingStationContainer;
import mcjty.rftoolscontrol.blocks.craftingstation.CraftingStationTileEntity;
import mcjty.rftoolscontrol.gui.GuiTools;
import mcjty.rftoolscontrol.network.PacketGetCraftableItems;
import mcjty.rftoolscontrol.network.PacketGetRequests;
import mcjty.rftoolscontrol.network.RFToolsCtrlMessages;
import mcjty.rftoolscontrol.setup.GuiProxy;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import org.lwjgl.input.Keyboard;

public class GuiCraftingStation
extends GenericGuiContainer<CraftingStationTileEntity> {
    public static final int WIDTH = 231;
    public static final int HEIGHT = 236;
    private static final ResourceLocation mainBackground = new ResourceLocation("rftoolscontrol", "textures/gui/craftingstation.png");
    private WidgetList recipeList;
    private WidgetList requestList;
    private TextField searchField;
    private Button cancelButton;
    private static List<ItemStack> fromServer_craftables = new ArrayList<ItemStack>();
    private static List<CraftingRequest> fromServer_requests = new ArrayList<CraftingRequest>();
    private int listDirty = 0;

    public static void storeCraftableForClient(List<ItemStack> items) {
        fromServer_craftables = new ArrayList<ItemStack>(items);
    }

    public static void storeRequestsForClient(List<CraftingRequest> requests) {
        fromServer_requests = new ArrayList<CraftingRequest>(requests);
    }

    public GuiCraftingStation(CraftingStationTileEntity tileEntity, CraftingStationContainer container) {
        super((ModBase)RFToolsControl.instance, RFToolsCtrlMessages.INSTANCE, (GenericTileEntity)tileEntity, (Container)container, GuiProxy.GUI_MANUAL_CONTROL, "craftingstation");
        this.field_146999_f = 231;
        this.field_147000_g = 236;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        Panel toplevel = (Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new PositionalLayout()).setBackground(mainBackground);
        this.initRecipeList(toplevel);
        this.initProgressList(toplevel);
        this.initButtons(toplevel);
        toplevel.setBounds(new Rectangle(this.field_147003_i, this.field_147009_r, 231, 236));
        this.window = new Window((GuiScreen)this, (AbstractContainerWidget)toplevel);
        this.window.event("cancel", (source, params) -> this.cancelRequest());
    }

    private void initButtons(Panel toplevel) {
        this.searchField = (TextField)new TextField(this.field_146297_k, (Gui)this).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(5, 5, 175, 16));
        this.cancelButton = (Button)((Button)((Button)((Button)new Button(this.field_146297_k, (Gui)this).setChannel("cancel")).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(180, 5, 46, 16))).setText("Cancel")).setTooltips(new String[]{TextFormatting.YELLOW + "Cancel request", "Cancel the currently selected", "crafting request"});
        ((Panel)toplevel.addChild((Widget)this.cancelButton)).addChild((Widget)this.searchField);
    }

    private void cancelRequest() {
        int selected = this.requestList.getSelected();
        if (selected == -1) {
            return;
        }
        this.sendServerCommand(RFToolsCtrlMessages.INSTANCE, "station.cancel", TypedMap.builder().put(CraftingStationTileEntity.PARAM_INDEX, (Object)selected).build());
    }

    private void initRecipeList(Panel toplevel) {
        this.recipeList = ((WidgetList)((WidgetList)new WidgetList(this.field_146297_k, (Gui)this).setName("recipes")).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(5, 23, 120, 128))).setPropagateEventsToChildren(true).setInvisibleSelection(true);
        Slider slider = (Slider)new Slider(this.field_146297_k, (Gui)this).setScrollableName("recipes").setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(126, 23, 9, 128));
        ((Panel)toplevel.addChild((Widget)this.recipeList)).addChild((Widget)slider);
    }

    private void initProgressList(Panel toplevel) {
        this.requestList = (WidgetList)((WidgetList)new WidgetList(this.field_146297_k, (Gui)this).setName("requests")).setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(136, 23, 80, 128));
        Slider slider = (Slider)new Slider(this.field_146297_k, (Gui)this).setScrollableName("requests").setLayoutHint((LayoutHint)new PositionalLayout.PositionalHint(217, 23, 9, 128));
        ((Panel)toplevel.addChild((Widget)this.requestList)).addChild((Widget)slider);
    }

    private void requestLists() {
        RFToolsCtrlMessages.INSTANCE.sendToServer((IMessage)new PacketGetCraftableItems(((CraftingStationTileEntity)this.tileEntity).func_174877_v()));
        RFToolsCtrlMessages.INSTANCE.sendToServer((IMessage)new PacketGetRequests(((CraftingStationTileEntity)this.tileEntity).func_174877_v()));
    }

    private void requestListsIfNeeded() {
        --this.listDirty;
        if (this.listDirty <= 0) {
            this.requestLists();
            this.listDirty = 10;
        }
    }

    private void updateRequestList() {
        this.requestList.removeChildren();
        for (CraftingRequest request : fromServer_requests) {
            ItemStack stack = request.getStack();
            Panel panel = (Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)new HorizontalLayout()).setDesiredWidth(16);
            this.requestList.addChild((Widget)panel);
            BlockRender blockRender = new BlockRender(this.field_146297_k, (Gui)this).setRenderItem((Object)stack).setOffsetX(-1).setOffsetY(-1);
            panel.addChild((Widget)blockRender);
            boolean failed = request.getFailed() != -1L;
            boolean ok = request.getOk() != -1L;
            panel.addChild((Widget)((Label)new Label(this.field_146297_k, (Gui)this).setColor(failed ? -53200 : (ok ? -13566160 : StyleConfig.colorTextNormal))).setText(failed ? "Failed!" : (ok ? "Ok" : "Wait (" + request.getTodo() + ")")));
        }
    }

    protected List<String> addCustomLines(List<String> oldList, BlockRender blockRender, ItemStack stack) {
        if (blockRender.getUserObject() instanceof Integer) {
            ArrayList<String> newlist = new ArrayList<String>();
            newlist.add(TextFormatting.GREEN + "Click: " + TextFormatting.WHITE + "craft single");
            newlist.add(TextFormatting.GREEN + "Shift + click: " + TextFormatting.WHITE + "craft amount");
            newlist.add("");
            newlist.addAll(oldList);
            return newlist;
        }
        return oldList;
    }

    private void updateRecipeList() {
        String filterText = this.searchField.getText().toLowerCase().trim();
        fromServer_craftables.sort((r1, r2) -> r1.func_82833_r().compareTo(r2.func_82833_r()));
        this.recipeList.removeChildren();
        Panel panel = null;
        int index = 0;
        for (final ItemStack stack : fromServer_craftables) {
            String displayName = stack.func_82833_r();
            if (!filterText.isEmpty() && !displayName.toLowerCase().contains(filterText)) continue;
            if (panel == null || panel.getChildCount() >= 6) {
                panel = (Panel)new Panel(this.field_146297_k, (Gui)this).setLayout((Layout)((HorizontalLayout)new HorizontalLayout().setSpacing(3)).setHorizontalMargin(1)).setDesiredHeight(16);
                this.recipeList.addChild((Widget)panel);
            }
            BlockRender blockRender = (BlockRender)new BlockRender(this.field_146297_k, (Gui)this).setRenderItem((Object)stack).setHilightOnHover(true).setOffsetX(-1).setOffsetY(-1).setUserObject((Object)index);
            ++index;
            blockRender.addSelectionEvent(new BlockRenderEvent(){

                public void select(Widget widget) {
                    BlockRender br = (BlockRender)widget;
                    Object item = br.getRenderItem();
                    if (item != null) {
                        boolean shift = Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54);
                        Object index = br.getUserObject();
                        if (shift) {
                            GuiCraftingStation.this.askAmountToCraft(stack);
                        } else {
                            GuiCraftingStation.this.requestItem(stack, 1);
                        }
                    }
                }

                public void doubleClick(Widget widget) {
                }
            });
            panel.addChild((Widget)blockRender);
        }
    }

    private Integer safeParse(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private void askAmountToCraft(ItemStack stack) {
        GuiTools.askSomething(this.field_146297_k, (Gui)this, this.getWindowManager(), 220, 50, "Craft amount:", "", s -> {
            Integer a = this.safeParse((String)s);
            if (a != null) {
                this.requestItem(stack, a);
            }
        });
    }

    private void requestItem(ItemStack stack, int amount) {
        this.sendServerCommand(RFToolsCtrlMessages.INSTANCE, "station.request", TypedMap.builder().put(CraftingStationTileEntity.PARAM_ITEMNAME, (Object)stack.func_77973_b().getRegistryName().toString()).put(CraftingStationTileEntity.PARAM_META, (Object)stack.func_77952_i()).put(CraftingStationTileEntity.PARAM_NBT, (Object)(stack.func_77942_o() ? stack.serializeNBT().toString() : "")).put(CraftingStationTileEntity.PARAM_AMOUNT, (Object)amount).build());
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.requestListsIfNeeded();
        this.updateRecipeList();
        this.updateRequestList();
        if (this.requestList.getSelected() >= this.requestList.getChildCount()) {
            this.requestList.setSelected(-1);
        }
        this.cancelButton.setEnabled(this.requestList.getSelected() != -1);
        this.drawWindow();
    }
}

