/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.mpr.json.utils;

import com.google.gson.annotations.SerializedName;
import insane96mcp.mpr.exceptions.InvalidJsonException;
import insane96mcp.mpr.json.IJsonObject;
import insane96mcp.mpr.json.utils.JsonEnchantment;
import insane96mcp.mpr.json.utils.JsonItemAttribute;
import insane96mcp.mpr.json.utils.JsonWeightDifficulty;
import insane96mcp.mpr.lib.Logger;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class JsonItem
extends WeightedRandom.Item
implements IJsonObject {
    public String id;
    public int data;
    private int weight;
    @SerializedName(value="weight_difficulty")
    private JsonWeightDifficulty weightDifficulty;
    @SerializedName(value="drop_chance")
    public float dropChance;
    public List<JsonEnchantment> enchantments;
    public List<JsonItemAttribute> attributes;
    public String nbt;
    public List<Integer> dimensions;
    private List<String> biomes;
    public transient List<Biome> biomesList;

    public JsonItem(int itemWeightIn) {
        super(itemWeightIn);
    }

    public String toString() {
        return String.format("Item{id: %s, data: %d, weight: %d, weightDifficulty: %s, dropChance: %f, enchantments: %s, attributes: %s, dimensions: %s, biomes: %s, nbt: %s}", this.id, this.data, this.weight, this.weightDifficulty, Float.valueOf(this.dropChance), this.enchantments, this.attributes, this.dimensions, this.biomes, this.nbt);
    }

    @Override
    public void Validate(File file) throws InvalidJsonException {
        if (this.id == null) {
            throw new InvalidJsonException("Missing Id for " + this, file);
        }
        if (Item.func_111206_d((String)this.id) == null) {
            Logger.Warning("Failed to find item with id " + this.id);
        }
        if (this.weight <= 0) {
            throw new InvalidJsonException("Missing weight (or weight <= 0) for " + this, file);
        }
        this.field_76292_a = this.weight;
        if (this.weightDifficulty == null) {
            this.weightDifficulty = new JsonWeightDifficulty();
        }
        if (this.dropChance == 0.0f) {
            Logger.Debug("Drop Chance has been set to 0 (or omitted). Will now default to 8.5f. If you want mobs to not drop this item, set dropChance to -1");
            this.dropChance = 8.5f;
        } else if (this.dropChance == -1.0f) {
            Logger.Debug("Drop Chance has been set to -1. Mob no longer drops this item in any case");
            this.dropChance = -32768.0f;
        }
        if (this.enchantments == null) {
            this.enchantments = new ArrayList<JsonEnchantment>();
        }
        if (!this.enchantments.isEmpty()) {
            for (JsonEnchantment enchantment : this.enchantments) {
                enchantment.Validate(file);
            }
        }
        if (this.attributes == null) {
            this.attributes = new ArrayList<JsonItemAttribute>();
        }
        if (!this.attributes.isEmpty()) {
            for (JsonItemAttribute itemAttribute : this.attributes) {
                itemAttribute.Validate(file);
            }
        }
        if (this.dimensions == null) {
            this.dimensions = new ArrayList<Integer>();
        }
        this.biomesList = new ArrayList<Biome>();
        if (this.biomes == null) {
            this.biomes = new ArrayList<String>();
        } else {
            for (String biome : this.biomes) {
                ResourceLocation biomeLoc = new ResourceLocation(biome);
                Biome b = (Biome)Biome.field_185377_q.func_82594_a((Object)biomeLoc);
                this.biomesList.add(b);
            }
        }
    }

    public boolean HasDimension(World world) {
        boolean hasDimension = this.dimensions.isEmpty();
        for (Integer dimension : this.dimensions) {
            if (world.field_73011_w.getDimension() != dimension.intValue()) continue;
            hasDimension = true;
        }
        return hasDimension;
    }

    public boolean HasBiome(World world, BlockPos pos) {
        boolean hasBiome = this.biomesList.isEmpty();
        Biome b = world.func_180494_b(pos);
        for (Biome biome : this.biomesList) {
            if (!biome.equals(b)) continue;
            hasBiome = true;
        }
        return hasBiome;
    }

    public JsonItem GetWeightWithDifficulty(World world) {
        JsonItem item2 = this.copy();
        switch (world.func_175659_aa()) {
            case EASY: {
                item2.field_76292_a += this.weightDifficulty.easy;
                break;
            }
            case NORMAL: {
                item2.field_76292_a += this.weightDifficulty.normal;
                break;
            }
            case HARD: {
                item2.field_76292_a += this.weightDifficulty.hard;
                break;
            }
        }
        return item2;
    }

    protected JsonItem copy() {
        JsonItem jsonItem = new JsonItem(this.weight);
        jsonItem.attributes = this.attributes;
        jsonItem.data = this.data;
        jsonItem.dropChance = this.dropChance;
        jsonItem.enchantments = this.enchantments;
        jsonItem.id = this.id;
        jsonItem.field_76292_a = this.field_76292_a;
        jsonItem.nbt = this.nbt;
        jsonItem.weight = this.weight;
        jsonItem.weightDifficulty = this.weightDifficulty;
        return jsonItem;
    }
}

