/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.mpr.json;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;
import insane96mcp.mpr.MobsPropertiesRandomness;
import insane96mcp.mpr.exceptions.InvalidJsonException;
import insane96mcp.mpr.json.IJsonObject;
import insane96mcp.mpr.json.JsonAttribute;
import insane96mcp.mpr.json.JsonEquipment;
import insane96mcp.mpr.json.JsonGroup;
import insane96mcp.mpr.json.JsonPotionEffect;
import insane96mcp.mpr.json.mobs.JsonCreeper;
import insane96mcp.mpr.json.mobs.JsonGhast;
import insane96mcp.mpr.lib.Logger;
import insane96mcp.mpr.utils.Utils;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;

public class JsonMob
implements IJsonObject {
    public static List<JsonMob> mobs = new ArrayList<JsonMob>();
    @SerializedName(value="mob_id")
    public String mobId;
    public String group;
    @SerializedName(value="potion_effects")
    public List<JsonPotionEffect> potionEffects;
    public List<JsonAttribute> attributes;
    public JsonEquipment equipment;
    public JsonCreeper creeper;
    public JsonGhast ghast;

    public String toString() {
        return String.format("Mob{id: %s, group: %s, potionEffects: %s, attributes: %s, equipment: %s, creeper: %s, ghast: %s}", this.mobId, this.group, this.potionEffects, this.attributes, this.equipment, this.creeper, this.ghast);
    }

    public static boolean LoadJsons() {
        File jsonFolder = new File(MobsPropertiesRandomness.configPath + "json");
        if (!jsonFolder.exists()) {
            jsonFolder.mkdir();
        }
        mobs.clear();
        boolean correctlyReloaded = true;
        Gson gson = new Gson();
        ArrayList<File> jsonFiles = Utils.ListFilesForFolder(jsonFolder);
        for (File file : jsonFiles) {
            if (file.getName().startsWith("_")) continue;
            try {
                Logger.Debug("Reading file " + file.getName());
                FileReader fileReader = new FileReader(file);
                JsonMob mob = (JsonMob)gson.fromJson((Reader)fileReader, JsonMob.class);
                Logger.Debug(mob.toString());
                mob.Validate(file);
                mobs.add(mob);
            }
            catch (Exception e) {
                correctlyReloaded = false;
                Logger.Error("Failed to parse file with name " + file.getName());
                Logger.Error(e.toString());
                e.printStackTrace();
            }
        }
        if (correctlyReloaded) {
            Logger.Info("Reloaded All JSONs");
        } else {
            Logger.Info("Reloaded All JSONs with errors");
        }
        return correctlyReloaded;
    }

    @Override
    public void Validate(File file) throws InvalidJsonException {
        if (this.mobId == null && this.group == null) {
            throw new InvalidJsonException("Missing mob_id or group for " + this.toString(), file);
        }
        if (this.mobId != null && this.group != null) {
            Logger.Debug("mob_id and group are both present, mob_id will be ignored");
        }
        if (this.mobId != null) {
            String[] splitId = this.mobId.split(":");
            if (splitId.length != 2) {
                throw new InvalidJsonException("Invalid mob_id " + this.mobId, file);
            }
            ResourceLocation resourceLocation = new ResourceLocation(this.mobId);
            if (!EntityList.func_180125_b((ResourceLocation)resourceLocation) && !this.mobId.endsWith("*")) {
                throw new InvalidJsonException("mob_id " + this.mobId + " does not exist", file);
            }
        }
        if (this.group != null && !JsonGroup.DoesGroupExist(this.group)) {
            throw new InvalidJsonException("group " + this.group + " does not exist", file);
        }
        if (this.potionEffects == null) {
            this.potionEffects = new ArrayList<JsonPotionEffect>();
        }
        for (JsonPotionEffect potionEffect : this.potionEffects) {
            potionEffect.Validate(file);
        }
        if (this.attributes == null) {
            this.attributes = new ArrayList<JsonAttribute>();
        }
        for (JsonAttribute attribute : this.attributes) {
            attribute.Validate(file);
        }
        if (this.equipment == null) {
            this.equipment = new JsonEquipment();
        }
        this.equipment.Validate(file);
        if (this.creeper != null) {
            this.creeper.Validate(file);
        }
        if (this.ghast != null) {
            this.ghast.Validate(file);
        }
    }

    public static void Apply(EntityJoinWorldEvent event) {
        if (mobs.isEmpty()) {
            return;
        }
        Entity entity = event.getEntity();
        World world = event.getWorld();
        Random random = world.field_73012_v;
        JsonCreeper.FixAreaEffectClouds(entity);
        if (!(entity instanceof EntityLiving)) {
            return;
        }
        EntityLiving entityLiving = (EntityLiving)entity;
        NBTTagCompound tags = entityLiving.getEntityData();
        boolean isAlreadyChecked = tags.func_74767_n(MobsPropertiesRandomness.RESOURCE_PREFIX + "checked");
        if (isAlreadyChecked) {
            return;
        }
        boolean shouldNotBeProcessed = tags.func_74767_n(MobsPropertiesRandomness.RESOURCE_PREFIX + "prevent_processing");
        if (shouldNotBeProcessed) {
            return;
        }
        JsonPotionEffect.Apply(entityLiving, world, random);
        JsonAttribute.Apply(entityLiving, world, random);
        JsonEquipment.Apply(entityLiving, world, random);
        JsonCreeper.Apply(entityLiving, world, random);
        JsonGhast.Apply((Entity)entityLiving, world, random);
        tags.func_74757_a(MobsPropertiesRandomness.RESOURCE_PREFIX + "checked", true);
    }
}

