/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.mpr.json;

import com.google.gson.annotations.SerializedName;
import insane96mcp.mpr.exceptions.InvalidJsonException;
import insane96mcp.mpr.json.IJsonObject;
import insane96mcp.mpr.json.JsonMob;
import insane96mcp.mpr.json.utils.JsonEnchantment;
import insane96mcp.mpr.json.utils.JsonItem;
import insane96mcp.mpr.json.utils.JsonItemAttribute;
import insane96mcp.mpr.json.utils.JsonSlot;
import insane96mcp.mpr.json.utils.JsonUtils;
import insane96mcp.mpr.lib.Logger;
import java.io.File;
import java.util.Random;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class JsonEquipment
implements IJsonObject {
    public JsonSlot head;
    public JsonSlot chest;
    public JsonSlot legs;
    public JsonSlot feets;
    @SerializedName(value="main_hand")
    public JsonSlot mainHand;
    @SerializedName(value="off_hand")
    public JsonSlot offHand;

    public String toString() {
        return String.format("Equipment{head: %s, chest: %s, legs: %s, feets: %s, mainHand: %s, offHand: %s}", this.head, this.chest, this.legs, this.feets, this.mainHand, this.offHand);
    }

    @Override
    public void Validate(File file) throws InvalidJsonException {
        if (this.head != null) {
            this.head.Validate(file);
        }
        if (this.chest != null) {
            this.chest.Validate(file);
        }
        if (this.legs != null) {
            this.legs.Validate(file);
        }
        if (this.feets != null) {
            this.feets.Validate(file);
        }
        if (this.mainHand != null) {
            this.mainHand.Validate(file);
        }
        if (this.offHand != null) {
            this.offHand.Validate(file);
        }
    }

    public static void Apply(EntityLiving entity, World world, Random random) {
        if (world.field_72995_K) {
            return;
        }
        for (JsonMob mob : JsonMob.mobs) {
            if (!JsonUtils.matchesEntity(entity, world, random, mob)) continue;
            JsonEquipment.ApplyEquipmentToSlot(entity, world, random, mob.equipment.head, EntityEquipmentSlot.HEAD);
            JsonEquipment.ApplyEquipmentToSlot(entity, world, random, mob.equipment.chest, EntityEquipmentSlot.CHEST);
            JsonEquipment.ApplyEquipmentToSlot(entity, world, random, mob.equipment.legs, EntityEquipmentSlot.LEGS);
            JsonEquipment.ApplyEquipmentToSlot(entity, world, random, mob.equipment.feets, EntityEquipmentSlot.FEET);
            JsonEquipment.ApplyEquipmentToSlot(entity, world, random, mob.equipment.mainHand, EntityEquipmentSlot.MAINHAND);
            JsonEquipment.ApplyEquipmentToSlot(entity, world, random, mob.equipment.offHand, EntityEquipmentSlot.OFFHAND);
        }
    }

    private static void ApplyEquipmentToSlot(EntityLiving entity, World world, Random random, JsonSlot slot, EntityEquipmentSlot entityEquipmentSlot) {
        if (slot == null) {
            return;
        }
        if (!slot.overrideVanilla && !entity.func_184582_a(entityEquipmentSlot).func_190926_b()) {
            return;
        }
        if (slot.replaceOnly && entity.func_184582_a(entityEquipmentSlot).func_190926_b()) {
            return;
        }
        if (!slot.chance.ChanceMatches(entity, world, random)) {
            return;
        }
        JsonItem choosenItem = slot.GetRandomItem(world, entity.func_180425_c());
        if (choosenItem == null) {
            return;
        }
        ItemStack itemStack = new ItemStack(Item.func_111206_d((String)choosenItem.id), 1, choosenItem.data);
        NBTTagCompound tag = new NBTTagCompound();
        if (choosenItem.nbt != null) {
            try {
                tag = JsonToNBT.func_180713_a((String)choosenItem.nbt);
                NBTTagCompound tagCompound = new NBTTagCompound();
                tagCompound.func_74782_a("tag", (NBTBase)tag);
                itemStack.deserializeNBT(tagCompound);
            }
            catch (NBTException e) {
                Logger.Error("Failed to parse NBT for " + choosenItem);
                e.printStackTrace();
            }
        }
        JsonEnchantment.Apply(entity, world, random, choosenItem, itemStack);
        entity.func_184201_a(entityEquipmentSlot, itemStack);
        for (JsonItemAttribute itemAttribute : choosenItem.attributes) {
            float amount = MathHelper.func_151240_a((Random)random, (float)itemAttribute.amount.GetMin(), (float)itemAttribute.amount.GetMax()) / 100.0f;
            AttributeModifier modifier = new AttributeModifier(itemAttribute.id, itemAttribute.modifier, (double)amount, itemAttribute.operation.ordinal());
            EntityEquipmentSlot modifierSlot = itemAttribute.slot == null ? entityEquipmentSlot : itemAttribute.slot;
            itemStack.func_185129_a(itemAttribute.attributeName, modifier, modifierSlot);
        }
        entity.func_184642_a(entityEquipmentSlot, choosenItem.dropChance / 100.0f);
    }
}

