/*
 * Decompiled with CFR 0.152.
 */
package me.dierke9.ddssutils.world.util.subbiome;

import me.dierke9.ddssutils.world.NoiseProvider;
import me.dierke9.ddssutils.world.util.subbiome.FreebiBiome;

public class FreebiBiomes {
    public static final FreebiBiome LOWLAND = new FreebiLowland();
    public static final FreebiBiome HIGHLAND = new FreebiHighland();
    public static final FreebiBiome STEPPEMESA = new FreebiSteppeMesa();
    public static final FreebiBiome ALGORITHM_SPECIAL = new FreebiSpecial();

    public static class FreebiSpecial
    extends FreebiBiome {
        public double d0 = 0.0;
        public double d1 = 0.0;

        public FreebiSpecial() {
            super("Special");
        }

        public FreebiBiome withDoubles(double d0in, double d1in) {
            this.d0 = d0in;
            this.d1 = d1in;
            return this;
        }

        @Override
        public int getBaseHeightAtPos(int posX, int posZ) {
            return 0;
        }
    }

    public static class FreebiSteppeMesa
    extends FreebiBiome {
        public FreebiSteppeMesa() {
            super("SteppeMesa");
        }

        @Override
        public int getBaseHeightAtPos(int posX, int posZ) {
            return 70;
        }

        @Override
        public double getHeightVariationAtPos(int posX, int posZ) {
            double d = 0.0;
            for (int meta = 0; meta < NoiseProvider.getOctaves().length; ++meta) {
                if (meta == 1) continue;
                if (meta == 0) {
                    d += FreebiSteppeMesa.toSteps(NoiseProvider.getOctaves()[meta].eval2d(posX, posZ));
                    continue;
                }
                d += NoiseProvider.getOctaves()[meta].eval2d(posX, posZ);
            }
            return d;
        }

        private static double toSteps(double eval2d) {
            if (eval2d <= 0.0) {
                return eval2d;
            }
            double megascale = NoiseProvider.getOctaves()[0].megaScale;
            if (eval2d < megascale / 3.0) {
                return megascale / 6.0;
            }
            if (eval2d < 2.0 * megascale / 3.0) {
                return 3.0 * megascale / 6.0;
            }
            return 5.0 * megascale / 6.0;
        }
    }

    public static class FreebiHighland
    extends FreebiBiome {
        public FreebiHighland() {
            super("Highland");
        }

        @Override
        public int getBaseHeightAtPos(int posX, int posZ) {
            return 140;
        }
    }

    public static class FreebiLowland
    extends FreebiBiome {
        public FreebiLowland() {
            super("Lowland");
        }

        @Override
        public int getBaseHeightAtPos(int posX, int posZ) {
            return 70;
        }
    }
}

